from _typeshed import Incomplete
from collections.abc import Iterator
from functools import cached_property

from networkx.classes.coreviews import AdjacencyView
from networkx.classes.graph import Graph, _Node
from networkx.classes.reportviews import DiDegreeView, OutEdgeView

class DiGraph(Graph[_Node]):
    @cached_property
    def succ(self) -> AdjacencyView[_Node, _Node, dict[str, Incomplete]]: ...
    @cached_property
    def pred(self) -> AdjacencyView[_Node, _Node, dict[str, Incomplete]]: ...
    def has_successor(self, u: _Node, v: _Node) -> bool: ...
    def has_predecessor(self, u: _Node, v: _Node) -> bool: ...
    def successors(self, n: _Node) -> Iterator[_Node]: ...
    def predecessors(self, n: _Node) -> Iterator[_Node]: ...
    @cached_property
    def out_edges(self) -> OutEdgeView[_Node]: ...
    @cached_property
    def in_edges(self) -> OutEdgeView[_Node]: ...
    @cached_property
    def in_degree(self) -> DiDegreeView[_Node]: ...
    @cached_property
    def out_degree(self) -> DiDegreeView[_Node]: ...
    def to_undirected(self, reciprocal: bool = False, as_view: bool = False): ...  # type: ignore[override]  # Has an additional `reciprocal` keyword argument
    def reverse(self, copy: bool = True) -> DiGraph[_Node]: ...
    def copy(self, as_view: bool = False) -> DiGraph[_Node]: ...
