# Summary

- [Introduction](./introduction.md)
- [Quickstart](./quickstart.md)
- [Prerequisites](./prerequisites/index.md)
  - [npm (optional)](./prerequisites/npm.md)
  - [considerations](./prerequisites/considerations.md)
  - [Non-`rustup` setups](./prerequisites/non-rustup-setups.md)
- [Commands](./commands/index.md)
  - [`new`](./commands/new.md)
  - [`build`](./commands/build.md)
  - [`test`](./commands/test.md)
  - [`pack` and `publish`](./commands/pack-and-publish.md)
  - [`init` (DEPRECATED)](./commands/init.md)
- [Tutorials](./tutorials/index.md)
  - [Hybrid applications with Webpack](./tutorials/hybrid-applications-with-webpack/index.md)
    - [Getting started](./tutorials/hybrid-applications-with-webpack/getting-started.md)
    - [Using your library](./tutorials/hybrid-applications-with-webpack/using-your-library.md)
  - [npm browser packages](./tutorials/npm-browser-packages/index.md)
    - [Getting started](./tutorials/npm-browser-packages/getting-started.md)
      - [Manual Setup](./tutorials/npm-browser-packages/getting-started/manual-setup.md)
    - [Template deep dive](./tutorials/npm-browser-packages/template-deep-dive/index.md)
      - [`Cargo.toml`](./tutorials/npm-browser-packages/template-deep-dive/cargo-toml.md)
      - [`src/lib.rs`](./tutorials/npm-browser-packages/template-deep-dive/src-lib-rs.md)
      - [`src/utils.rs`](./tutorials/npm-browser-packages/template-deep-dive/src-utils-rs.md)
      - [`wee_alloc`](./tutorials/npm-browser-packages/template-deep-dive/wee_alloc.md)
      - [`tests/web.rs`](./tutorials/npm-browser-packages/template-deep-dive/tests-web-rs.md)
    - [Building your project](./tutorials/npm-browser-packages/building-your-project.md)
    - [Testing your project](./tutorials/npm-browser-packages/testing-your-project.md)
    - [Packaging and publishing](./tutorials/npm-browser-packages/packaging-and-publishing.md)
    - [Using your library](./tutorials/npm-browser-packages/using-your-library.md)
- [`Cargo.toml` Configuration](./cargo-toml-configuration.md)
- [Contributing](./contributing.md)
