/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.awt;

import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.ErrorReporter;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class MessagePopup
implements ActionListener,
ErrorReporter {
    private String errorMessage;
    private Controller errorSource;
    private Component source;
    private Window popup;

    public MessagePopup(Component component) {
        this.source = component;
    }

    @Override
    public void setErrorMessage(Controller controller, String string) {
        Component component;
        if (this.popup != null) {
            this.clearErrorMessage();
        }
        if (string == null) {
            return;
        }
        this.errorSource = controller;
        this.errorMessage = string;
        for (component = this.source; component != null && !(component instanceof Frame); component = component.getParent()) {
        }
        this.popup = component != null ? new Dialog((Frame)component, "Error Message", true) : new Frame("Error Message");
        this.popup.setBackground(Color.white);
        this.popup.add((Component)new MC(string), "Center");
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2, 10, 10));
        Button button = new Button("    OK    ");
        button.addActionListener(this);
        panel.add(button);
        this.popup.add((Component)panel, "South");
        this.popup.pack();
        if (component == null) {
            this.popup.setLocation(100, 80);
        } else {
            this.popup.setLocation(component.getLocation().x + 50, component.getLocation().y + 30);
        }
        this.popup.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MessagePopup.this.popup.dispose();
            }
        });
        this.popup.setVisible(true);
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public synchronized void clearErrorMessage() {
        if (this.popup == null) {
            return;
        }
        this.popup.dispose();
        this.errorMessage = null;
        if (this.errorSource != null) {
            this.errorSource.errorCleared();
        }
        this.errorSource = null;
        this.popup = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.clearErrorMessage();
    }

    private static class MC
    extends Canvas {
        private String message;
        private Vector messageStrings;
        private int messageWidth;
        private int messageHeight;
        private Font font;
        private int lineHeight;
        private int fontAscent;

        MC(String string) {
            this.message = string == null ? "" : string;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.messageStrings == null) {
                this.makeStringList();
            }
            return new Dimension(this.messageWidth + 20, this.messageHeight + 20);
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            if (this.messageStrings == null) {
                this.makeStringList();
            }
            if ((n2 = (this.getSize().height - this.messageHeight) / 2 + this.fontAscent) < this.fontAscent) {
                n2 = this.fontAscent;
            }
            if ((n = (this.getSize().width - this.messageWidth) / 2) < 0) {
                n = 0;
            }
            graphics.setFont(this.font);
            for (int i = 0; i < this.messageStrings.size(); ++i) {
                graphics.drawString((String)this.messageStrings.elementAt(i), n, n2);
                n2 += this.lineHeight;
            }
        }

        private void makeStringList() {
            this.messageStrings = new Vector();
            this.font = new Font("Dialog", 0, 12);
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            this.lineHeight = fontMetrics.getHeight() + 3;
            this.fontAscent = fontMetrics.getAscent();
            int n = fontMetrics.stringWidth(this.message);
            if (n <= 280) {
                this.messageStrings.addElement(this.message);
                this.messageWidth = 280;
                this.messageHeight = this.lineHeight;
            } else {
                this.messageWidth = n > 1800 ? Math.min(500, n / 6) : 300;
                int n2 = 0;
                String string = "    ";
                String string2 = "";
                this.message = this.message + " ";
                for (int i = 0; i < this.message.length(); ++i) {
                    if (this.message.charAt(i) == ' ') {
                        if (fontMetrics.stringWidth(string + string2) > this.messageWidth + 8) {
                            this.messageStrings.addElement(string);
                            n2 = Math.max(n2, fontMetrics.stringWidth(string));
                            string = "";
                        }
                        if ((string = string + string2).length() > 0) {
                            string = string + ' ';
                        }
                        string2 = "";
                        continue;
                    }
                    string2 = string2 + this.message.charAt(i);
                }
                if (string.length() > 0) {
                    this.messageStrings.addElement(string);
                    n2 = Math.max(n2, fontMetrics.stringWidth(string));
                }
                this.messageHeight = this.lineHeight * this.messageStrings.size() - fontMetrics.getLeading();
                this.messageWidth = Math.max(280, n2);
            }
        }
    }
}

