#
# presets.py
#
# Copyright (C) 2017 Ratanak Lun <ratanakvlun@gmail.com>
#
# This module is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This software is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# Linking this software with other modules is making a combined work
# based on this software. Thus, the terms and conditions of the GNU
# General Public License cover the whole combination.
#
# As a special exception, the copyright holders of this software give
# you permission to link this software with independent modules to
# produce a combined work, regardless of the license terms of these
# independent modules, and to copy and distribute the resulting work
# under terms of your choice, provided that you also meet, for each
# linked module in the combined work, the terms and conditions of the
# license of that module. An independent module is a module which is
# not derived from or based on this software. If you modify this
# software, you may extend this exception to your version of the
# software, but you are not obligated to do so. If you do not wish to
# do so, delete this exception statement from your version.
#

"""Presets for libtorrent."""

LIBTORRENT_DEFAULTS = {
  "active_checking": 1,
  "active_dht_limit": 88,
  "active_downloads": 3,
  "active_limit": 15,
  "active_loaded_limit": 0,
  "active_lsd_limit": 60,
  "active_seeds": 5,
  "active_tracker_limit": 1600,
  "aio_max": 300,
  "aio_threads": 4,
  "alert_queue_size": 1000,
  "allow_i2p_mixed": False,
  "allow_multiple_connections_per_ip": False,
  "allow_partial_disk_writes": True,
  "allow_reordered_disk_operations": True,
  "allowed_enc_level": 3,
  "allowed_fast_set_size": 10,
  "always_send_user_agent": False,
  "announce_crypto_support": True,
  "announce_double_nat": False,
  "announce_ip": "",
  "announce_to_all_tiers": False,
  "announce_to_all_trackers": False,
  "anonymous_mode": False,
  "apply_ip_filter_to_trackers": True,
  "auto_manage_interval": 30,
  "auto_manage_prefer_seeds": False,
  "auto_manage_startup": 60,
  "auto_scrape_interval": 1800,
  "auto_scrape_min_interval": 300,
  "auto_sequential": True,
  "auto_upload_slots": True,
  "auto_upload_slots_rate_based": True,
  "ban_web_seeds": True,
  "broadcast_lsd": True,
  "cache_buffer_chunk_size": 16,
  "cache_expiry": 300,
  "cache_size": 1024,
  "cache_size_volatile": 256,
  "checking_mem_usage": 256,
  "choking_algorithm": 0,
  "close_file_interval": 0,
  "close_redundant_connections": True,
  "coalesce_reads": False,
  "coalesce_writes": False,
  "connect_seed_every_n_download": 10,
  "connection_speed": 10,
  "connections_limit": 200,
  "connections_slack": 10,
  "contiguous_recv_buffer": True,
  "decrease_est_reciprocation_rate": 3,
  "default_cache_min_age": 1,
  "default_est_reciprocation_rate": 16000,
  "dht_announce_interval": 900,
  "dht_bootstrap_nodes": "dht.libtorrent.org:25401",
  "dht_upload_rate_limit": 4000,
  "disable_hash_checks": False,
  "disk_cache_algorithm": 2,
  "disk_io_read_mode": 0,
  "disk_io_write_mode": 0,
  "dont_count_slow_torrents": True,
  "dont_flush_write_cache": False,
  "download_rate_limit": 0,
  "drop_skipped_requests": False,
  "enable_dht": True,
  "enable_incoming_tcp": True,
  "enable_incoming_utp": True,
  "enable_lsd": True,
  "enable_natpmp": True,
  "enable_outgoing_tcp": True,
  "enable_outgoing_utp": True,
  "enable_upnp": True,
  "explicit_cache_interval": 30,
  "explicit_read_cache": False,
  "file_checks_delay_per_block": 0,
  "file_pool_size": 40,
  "force_proxy": False,
  "free_torrent_hashes": True,
  "guided_read_cache": False,
  "half_open_limit": 2147483647,
  "handshake_client_version": "",
  "handshake_timeout": 10,
  "hashing_threads": 1,
  "i2p_hostname": "",
  "i2p_port": 0,
  "ignore_limits_on_local_network": True,
  "ignore_resume_timestamps": False,
  "in_enc_policy": 1,
  "inactive_down_rate": 2048,
  "inactive_up_rate": 2048,
  "inactivity_timeout": 600,
  "incoming_starts_queued_torrents": False,
  "increase_est_reciprocation_rate": 20,
  "initial_picker_threshold": 4,
  "lazy_bitfields": False,
  "listen_interfaces": "0.0.0.0:6881",
  "listen_queue_size": 5,
  "listen_system_port_fallback": True,
  "local_download_rate_limit": 0,
  "local_service_announce_interval": 300,
  "local_upload_rate_limit": 0,
  "lock_disk_cache": False,
  "lock_files": False,
  "low_prio_disk": True,
  "max_allowed_in_request_queue": 500,
  "max_failcount": 3,
  "max_http_recv_buffer_size": 835584,
  "max_metadata_size": 31457280,
  "max_out_request_queue": 500,
  "max_paused_peerlist_size": 1000,
  "max_peerlist_size": 3000,
  "max_pex_peers": 50,
  "max_queued_disk_bytes": 1048576,
  "max_queued_disk_bytes_low_watermark": 0,
  "max_rejects": 50,
  "max_retry_port_bind": 10,
  "max_suggest_pieces": 10,
  "min_announce_interval": 300,
  "min_reconnect_time": 60,
  "mixed_mode_algorithm": 1,
  "mmap_cache": "",
  "network_threads": 0,
  "no_atime_storage": True,
  "no_connect_privileged_ports": False,
  "no_recheck_incomplete_resume": False,
  "num_optimistic_unchoke_slots": 0,
  "num_want": 200,
  "optimistic_disk_retry": 600,
  "optimistic_unchoke_interval": 30,
  "optimize_hashing_for_speed": True,
  "out_enc_policy": 1,
  "outgoing_interfaces": "",
  "peer_connect_timeout": 15,
  "peer_timeout": 120,
  "peer_tos": 0,
  "peer_turnover": 4,
  "peer_turnover_cutoff": 90,
  "peer_turnover_interval": 300,
  "piece_timeout": 20,
  "predictive_piece_announce": 0,
  "prefer_rc4": False,
  "prefer_udp_trackers": True,
  "prioritize_partial_pieces": False,
  "proxy_hostname": "",
  "proxy_hostnames": True,
  "proxy_password": "",
  "proxy_peer_connections": True,
  "proxy_port": 0,
  "proxy_tracker_connections": True,
  "proxy_type": 0,
  "proxy_username": "",
  "rate_limit_ip_overhead": True,
  "rate_limit_utp": False,
  "read_cache_line_size": 32,
  "read_job_every": 10,
  "recv_socket_buffer_size": 0,
  "report_redundant_bytes": True,
  "report_True_downloaded": False,
  "report_web_seed_downloads": True,
  "request_queue_time": 3,
  "request_timeout": 60,
  "seed_choking_algorithm": 0,
  "seed_time_limit": 86400,
  "seed_time_ratio_limit": 700,
  "seeding_outgoing_connections": True,
  "seeding_piece_quota": 20,
  "send_buffer_low_watermark": 10240,
  "send_buffer_watermark": 512000,
  "send_buffer_watermark_factor": 50,
  "send_redundant_have": True,
  "send_socket_buffer_size": 0,
  "share_mode_target": 3,
  "share_ratio_limit": 200,
  "smooth_connects": True,
  "ssl_listen": 0,
  "stop_tracker_timeout": 5,
  "strict_end_game_mode": True,
  "strict_super_seeding": False,
  "suggest_mode": 0,
  "support_merkle_torrents": True,
  "support_share_mode": True,
  "tick_interval": 500,
  "torrent_connect_boost": 10,
  "tracker_backoff": 250,
  "tracker_completion_timeout": 30,
  "tracker_maximum_response_length": 1048576,
  "tracker_receive_timeout": 10,
  "udp_tracker_token_expiry": 60,
  "unchoke_interval": 15,
  "unchoke_slots_limit": 8,
  "upload_rate_limit": 0,
  "upnp_ignore_nonrouters": False,
  "urlseed_max_request_bytes": 16777216,
  "urlseed_pipeline_size": 5,
  "urlseed_timeout": 20,
  "urlseed_wait_retry": 30,
  "use_dht_as_fallback": False,
  "use_disk_cache_pool": True,
  "use_disk_read_ahead": True,
  "use_parole_mode": True,
  "use_read_cache": True,
  "use_write_cache": True,
  "utp_connect_timeout": 3000,
  "utp_delayed_ack": 0,
  "utp_dynamic_sock_buf": False,
  "utp_fin_resends": 2,
  "utp_gain_factor": 3000,
  "utp_loss_multiplier": 50,
  "utp_min_timeout": 500,
  "utp_num_resends": 3,
  "utp_syn_resends": 2,
  "utp_target_delay": 100,
  "volatile_read_cache": False,
  "web_seed_name_lookup_retry": 1800,
  "whole_pieces_threshold": 20,
  "write_cache_line_size": 16
}

MIN_MEMORY_USAGE = {
  "aio_threads": 1,
  "alert_queue_size": 100,
  "allow_multiple_connections_per_ip": False,
  "cache_buffer_chunk_size": 1,
  "cache_size": 0,
  "checking_mem_usage": 2,
  "close_redundant_connections": True,
  "coalesce_reads": False,
  "coalesce_writes": False,
  "connection_speed": 5,
  "contiguous_recv_buffer": False,
  "disk_io_read_mode": 2,
  "disk_io_write_mode": 2,
  "file_checks_delay_per_block": 5,
  "file_pool_size": 4,
  "inactivity_timeout": 120,
  "max_allowed_in_request_queue": 100,
  "max_failcount": 2,
  "max_http_recv_buffer_size": 1048576,
  "max_out_request_queue": 300,
  "max_paused_peerlist_size": 50,
  "max_peerlist_size": 500,
  "max_queued_disk_bytes": 1,
  "max_rejects": 10,
  "network_threads": 0,
  "optimize_hashing_for_speed": False,
  "prefer_udp_trackers": True,
  "prioritize_partial_pieces": True,
  "recv_socket_buffer_size": 16384,
  "send_buffer_watermark": 9,
  "send_socket_buffer_size": 16384,
  "upnp_ignore_nonrouters": True,
  "use_disk_read_ahead": False,
  "use_parole_mode": False,
  "use_read_cache": False,
  "utp_dynamic_sock_buf": False,
  "whole_pieces_threshold": 2
}

HIGH_PERFORMANCE_SEED = {
  "active_dht_limit": 600,
  "active_limit": 2000,
  "active_seeds": 2000,
  "active_tracker_limit": 2000,
  "aio_threads": 8,
  "alert_queue_size": 10000,
  "allow_multiple_connections_per_ip": True,
  "allowed_fast_set_size": 0,
  "auto_upload_slots": False,
  "cache_buffer_chunk_size": 128,
  "cache_expiry": 30,
  "cache_size": 65536,
  "checking_mem_usage": 320,
  "choking_algorithm": 0,
  "close_redundant_connections": True,
  "coalesce_reads": False,
  "coalesce_writes": False,
  "connection_speed": 500,
  "connections_limit": 8000,
  "dht_upload_rate_limit": 20000,
  "disk_cache_algorithm": 2,
  "explicit_read_cache": False,
  "file_pool_size": 500,
  "inactivity_timeout": 20,
  "listen_queue_size": 3000,
  "lock_disk_cache": False,
  "low_prio_disk": False,
  "max_allowed_in_request_queue": 2000,
  "max_failcount": 1,
  "max_http_recv_buffer_size": 6291456,
  "max_out_request_queue": 1500,
  "max_queued_disk_bytes": 7340032,
  "max_rejects": 10,
  "mixed_mode_algorithm": 0,
  "network_threads": 0,
  "no_atime_storage": True,
  "optimize_hashing_for_speed": True,
  "peer_timeout": 20,
  "read_cache_line_size": 32,
  "read_job_every": 100,
  "recv_socket_buffer_size": 1048576,
  "request_timeout": 10,
  "send_buffer_low_watermark": 1048576,
  "send_buffer_watermark": 3145728,
  "send_buffer_watermark_factor": 150,
  "send_socket_buffer_size": 1048576,
  "suggest_mode": 1,
  "unchoke_slots_limit": 2000,
  "use_disk_cache_pool": True,
  "use_read_cache": True,
  "utp_dynamic_sock_buf": True,
  "write_cache_line_size": 256
}
