/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.blockdevicelib.vmdk;

import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import java.nio.ByteBuffer;

public class VMDKMetadataMarker {
    private final long offsetInVMDK;
    private final long numSectors;
    private final int size;
    private final int type;

    public VMDKMetadataMarker(long offsetInVMDK, ByteBuffer buffer) {
        this.offsetInVMDK = offsetInVMDK;
        this.numSectors = buffer.getLong();
        this.size = buffer.getInt();
        this.type = !this.isCompressedGrain() ? buffer.getInt() : 0;
    }

    public boolean isGrainTable() {
        return this.size == 0 && this.type == 1;
    }

    public boolean isGrainDirectory() {
        return this.size == 0 && this.type == 2;
    }

    public boolean isFooter() {
        return this.size == 0 && this.type == 3;
    }

    public boolean isCompressedGrain() {
        return this.size != 0;
    }

    public long getNumSectors() {
        return this.numSectors;
    }

    public long getLba() throws ImageVerificationException {
        if (!this.isCompressedGrain()) {
            throw new ImageVerificationException("Trying to retrieve block device offset from non-grain marker offset:" + this.offsetInVMDK + ")");
        }
        return this.numSectors;
    }

    public long getOffsetInVMDK() {
        return this.offsetInVMDK;
    }

    public int getSize() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }
}

