/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.service.impl;

import com.amazon.aes.service.CustomerGatewayConfigurationService;
import com.amazon.aes.service.S3Connection;
import com.amazon.aes.service.S3Service;
import com.amazon.aes.service.impl.S3ServiceImpl;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class CustomerGatewayConfigurationServiceImpl
implements CustomerGatewayConfigurationService {
    private String bucket = System.getProperty("xslt.bucket", "ec2-downloads");
    private String xsltName = System.getProperty("xslt.key", "2009-07-15/customer-gateway-%s.xslt");
    private AWSCredentials s3Creds = null;
    private String verbatimFormat = "xml";
    private S3Service s3Service = new S3ServiceImpl();

    public CustomerGatewayConfigurationServiceImpl() {
        String awsKeyId = System.getProperty("xslt.awsKeyId");
        String awsPassword = System.getProperty("xslt.awsPassword");
        if (null != awsKeyId || null != awsPassword) {
            this.s3Creds = new BasicAWSCredentials(awsKeyId, awsPassword);
        }
    }

    @Override
    public CustomerGatewayConfigurationService.ConfigurationOutputter getConfigurationOutputterByLocation(PrintStream output, String location) throws TransformerConfigurationException {
        File xsltFile = new File(location);
        if (!xsltFile.exists()) {
            throw new GeneralError("File " + location + " does not exist");
        }
        StreamSource xsltSource = new StreamSource(xsltFile);
        return this.getConfigurationOutputter(output, xsltSource);
    }

    @Override
    public CustomerGatewayConfigurationService.ConfigurationOutputter getConfigurationOutputterByFormat(final PrintStream output, String format) throws TransformerConfigurationException {
        if (format == null || "".equals(format)) {
            return new CustomerGatewayConfigurationService.ConfigurationOutputter(){

                @Override
                public void output(String string) {
                }
            };
        }
        if (this.verbatimFormat.equals(format)) {
            return new CustomerGatewayConfigurationService.ConfigurationOutputter(){

                @Override
                public void output(String config) {
                    if (config != null && !"".equals(config)) {
                        output.println(config);
                    }
                }
            };
        }
        S3Connection connection = this.s3Service.makeS3Connection(this.s3Creds, this.bucket);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        S3Connection.OperationResult result = connection.get(String.format(this.xsltName, format), outputStream);
        if (result.getOperationCode() != S3Connection.OperationCode.OK) {
            throw new GeneralError("Could not retrieve XSLT for format " + format + ": " + result.getMsg());
        }
        StreamSource xsltSource = new StreamSource(new ByteArrayInputStream(outputStream.toByteArray()));
        return this.getConfigurationOutputter(output, xsltSource);
    }

    protected CustomerGatewayConfigurationService.ConfigurationOutputter getConfigurationOutputter(final PrintStream output, Source xsltSource) throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        final Transformer transformer = transformerFactory.newTransformer(xsltSource);
        return new CustomerGatewayConfigurationService.ConfigurationOutputter(){

            @Override
            public void output(String config) {
                if (config == null || "".equals(config)) {
                    return;
                }
                try {
                    transformer.transform(new StreamSource(new StringReader(config)), new StreamResult(output));
                }
                catch (TransformerException e) {
                    throw new GeneralError("Error transforming the configuration: " + e.getMessage(), e);
                }
            }
        };
    }
}

