/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazonaws.services.ec2.model.VpcPeeringConnection;
import org.apache.commons.cli.Options;

public class AcceptVpcPeeringConnection
extends BaseCmd {
    public AcceptVpcPeeringConnection(String[] args) {
        super("ec2apcx", "ec2-accept-vpc-peering-connection");
        this.init(new Options());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "[GENERAL OPTIONS] VPCPEERINGCONNECTION";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Accept a VPC Peering Connection.");
    }

    @Override
    public void printOptions() {
        super.printOptions(false);
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("VPCPEERINGCONNECTION");
        this.warnIfTooManyNonOptions();
        RequestResultPair result = jec2.acceptVpcPeeringConnection(this.getNonOptions()[0]);
        out.outputVpcPeeringConnection(System.out, (VpcPeeringConnection)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new AcceptVpcPeeringConnection(args).invoke();
    }
}

