/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazonaws.services.ec2.model.PrefixList;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribePrefixLists
extends BaseCmd {
    public DescribePrefixLists(String[] args) {
        super("ec2dpl", "ec2-describe-prefix-lists");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "PREFIXLIST [, PREFIXLIST] [--filter NAME=VALUE, ..] ";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        options.addOption(OptionBuilder.create((String)"F"));
        options.addOption(DescribePrefixLists.createOptionWithArgs(null, "max-results", MAX_RESULTS_DESC, "MAX_RESULTS"));
        options.addOption(DescribePrefixLists.createOptionWithArgs(null, "next-token", NEXT_TOKEN_DESC, "NEXT_TOKEN"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describes available prefix lists. A prefix list is required for creating an outbound security group rule that allows traffic from a VPC to access an AWS service through a VPC endpoint.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
        this.printOption("max-results");
        this.printOption("next-token");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp;
        Integer maxResults;
        String[] prefixListIds = this.getNonOptions();
        try {
            maxResults = this.getOptionInteger("max-results");
        }
        catch (NumberFormatException e) {
            maxResults = null;
        }
        String nextToken = this.getOptionValue("next-token");
        boolean automaticPaging = nextToken == null && maxResults == null;
        ArrayList<PrefixList> prefixLists = new ArrayList<PrefixList>();
        do {
            rsp = jec2.describePrefixLists(prefixListIds, this.getFilters(true), maxResults, nextToken);
            prefixLists.addAll((Collection)rsp.getResponse());
            nextToken = rsp.getNextToken();
        } while (automaticPaging && nextToken != null && !nextToken.isEmpty());
        out.outputPrefixLists(System.out, prefixLists);
        out.printNextToken(System.out, nextToken);
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new DescribePrefixLists(args).invoke();
    }
}

