/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VpcAttributeType;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ModifyVpcAttribute
extends BaseCmd {
    private static final String VPC_DESC = "The ID of a VPC.";
    private static final String DNS_SUPPORT = "dns-support";
    private static final String[] DNS_SUPPORT_DESC = new String[]{"Whether the DNS resolution provided by Amazon is supported for the VPC.", "Specify true to enable this DNS resolution, or false to disable it."};
    private static final String DNS_HOSTNAMES = "dns-hostnames";
    private static final String[] DNS_HOSTNAMES_DESC = new String[]{"Whether DNS hostnames are supported for the instances launched in this VPC.", "Specify true to enable DNS hostnames, or false to disable them. This option", "isn't valid if dns-support is false."};

    public ModifyVpcAttribute(String[] args) {
        super("ec2mva", "ec2-modify-vpc-attribute");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"vpc");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)this.joinDescription(VPC_DESC));
        o.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)DNS_SUPPORT);
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ModifyVpcAttribute.joinDescription(DNS_SUPPORT_DESC));
        o.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)DNS_HOSTNAMES);
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ModifyVpcAttribute.joinDescription(DNS_HOSTNAMES_DESC));
        o.addOption(OptionBuilder.create((String)"d"));
        return o;
    }

    @Override
    protected String getOptionString() {
        return "-c VPC (--dns-support true|false) (--dns-hostnames true|false)";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Modifies the attributes of a VPC.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("vpc");
        this.printOption(DNS_SUPPORT);
        this.printOption(DNS_HOSTNAMES);
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertOptionSet("vpc");
        String vpcId = this.getOptionValue("vpc");
        this.assertOnlyOneOptionSet(new String[]{DNS_SUPPORT, DNS_HOSTNAMES});
        VpcAttributeType type = null;
        Boolean value = null;
        if (this.isOptionSet(DNS_SUPPORT)) {
            type = VpcAttributeType.enableDnsSupport;
            value = this.getBooleanOption(DNS_SUPPORT);
        } else if (this.isOptionSet(DNS_HOSTNAMES)) {
            type = VpcAttributeType.enableDnsHostnames;
            value = this.getBooleanOption(DNS_HOSTNAMES);
        }
        RequestResultPair rsp = jec2.modifyVpcAttribute(vpcId, type, value);
        out.output(System.out, (Boolean)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new ModifyVpcAttribute(args).invoke();
    }
}

