/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.css;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.css.CSSHandler;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.ValidationContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Locale;
import org.idpf.epubcheck.util.css.CssExceptions;
import org.idpf.epubcheck.util.css.CssInputStream;
import org.idpf.epubcheck.util.css.CssParser;
import org.idpf.epubcheck.util.css.CssSource;

public class CSSChecker
implements ContentChecker {
    private final ValidationContext context;
    private final Report report;
    private final String path;
    private final Mode mode;
    private final String value;
    private int line;
    private final boolean isStyleAttribute;

    public CSSChecker(ValidationContext context) {
        this(context, Mode.FILE, null, -1, false);
    }

    public CSSChecker(ValidationContext context, String value, int line, boolean isStyleAttribute) {
        this(context, Mode.STRING, value, line, isStyleAttribute);
    }

    private CSSChecker(ValidationContext context, Mode mode, String value, int line, boolean isStyleAttribute) {
        this.context = context;
        this.report = context.report;
        this.path = context.path;
        this.mode = mode;
        this.value = value;
        this.line = line;
        this.isStyleAttribute = isStyleAttribute;
    }

    @Override
    public void runChecks() {
        CssSource source = null;
        try {
            if (this.mode == Mode.FILE && !((OCFPackage)this.context.ocf.get()).hasEntry(this.path)) {
                this.report.message(MessageId.RSC_001, EPUBLocation.create(((OCFPackage)this.context.ocf.get()).getName()), this.path);
                return;
            }
            CSSHandler handler = new CSSHandler(this.context);
            if (this.mode == Mode.STRING && this.line > -1) {
                handler.setStartingLineNumber(this.line);
            }
            source = this.getCssSource();
            this.parseItem(source, handler);
            handler.setStartingLineNumber(-1);
            this.line = -1;
        }
        catch (Exception e) {
            this.report.message(MessageId.PKG_008, EPUBLocation.create(this.path), e.getMessage());
        }
        finally {
            if (source != null) {
                try {
                    CssInputStream iStream = source.getInputStream();
                    if (iStream != null) {
                        ((InputStream)iStream).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    CssSource getCssSource() throws IOException {
        CssSource source = null;
        if (this.mode == Mode.FILE) {
            String charset;
            source = new CssSource(this.path, this.context.resourceProvider.getInputStream(this.path));
            if (source.getInputStream().getBomCharset().isPresent() && !(charset = ((String)source.getInputStream().getBomCharset().get()).toLowerCase(Locale.ROOT)).equals("utf-8") && !charset.startsWith("utf-16")) {
                this.report.message(MessageId.CSS_004, EPUBLocation.create(this.path), charset);
            }
            if (source.getInputStream().getCssCharset().isPresent() && !(charset = ((String)source.getInputStream().getCssCharset().get()).toLowerCase(Locale.ROOT)).equals("utf-8") && !charset.startsWith("utf-16")) {
                this.report.message(MessageId.CSS_003, EPUBLocation.create(this.path, ""), charset);
            }
        }
        return source;
    }

    void parseItem(CssSource source, CSSHandler handler) throws IOException, CssExceptions.CssException {
        if (!this.isStyleAttribute) {
            if (this.mode == Mode.FILE) {
                new CssParser(this.context.locale).parse(source, handler, handler);
            } else {
                new CssParser(this.context.locale).parse(new StringReader(this.value), this.path, handler, handler);
            }
        } else {
            new CssParser(this.context.locale).parseStyleAttribute(new StringReader(this.value), this.path, handler, handler);
        }
    }

    private static enum Mode {
        FILE,
        STRING;

    }
}

