/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.io.IOException;
import org.aesh.command.CommandDefinition;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.model.state.State;

@CommandDefinition(name="undo", description="Undo the last editing command")
public class StateUndoCommand
extends PmSessionCommand {
    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            State state = invoc.getPmSession().getState();
            if (!state.hasActions()) {
                throw new ProvisioningException(Errors.historyIsEmpty());
            }
            state.pop(invoc.getPmSession());
        }
        catch (IOException | ProvisioningException ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.undoFailed(), ex);
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }
}

