/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.Future;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.api.model.Type;
import org.jd.gui.service.type.TypeFactoryService;
import org.jd.gui.spi.TypeFactory;
import org.jd.gui.util.exception.ExceptionUtil;

public class UriUtil {
    public static URI createURI(API api, Collection<Future<Indexes>> collectionOfFutureIndexes, Container.Entry entry, String query, String fragment) {
        URI uri = entry.getUri();
        try {
            Type type;
            String path = uri.getPath();
            TypeFactory typeFactory = TypeFactoryService.getInstance().get(entry);
            if (typeFactory != null && (type = typeFactory.make(api, entry, fragment)) != null) {
                path = UriUtil.getOuterPath(collectionOfFutureIndexes, entry, type);
            }
            return new URI(uri.getScheme(), uri.getHost(), path, query, fragment);
        }
        catch (URISyntaxException e) {
            assert (ExceptionUtil.printStackTrace(e));
            return uri;
        }
    }

    protected static String getOuterPath(Collection<Future<Indexes>> collectionOfFutureIndexes, Container.Entry entry, Type type) {
        block5: {
            String outerName = type.getOuterName();
            if (outerName != null) {
                try {
                    for (Future<Indexes> futureIndexes : collectionOfFutureIndexes) {
                        Collection outerEntries;
                        if (!futureIndexes.isDone() || (outerEntries = futureIndexes.get().getIndex("typeDeclarations").get(outerName)) == null) continue;
                        for (Container.Entry outerEntry : outerEntries) {
                            if (outerEntry.getContainer() != entry.getContainer()) continue;
                            return outerEntry.getUri().getPath();
                        }
                    }
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block5;
                    throw new AssertionError();
                }
            }
        }
        return entry.getUri().getPath();
    }
}

