/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.im.InputContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformManager;

public final class KeyboardUtils {
    public static final int EXTENDED_KEYCODE_FLAG = 0x1000000;
    private static final Map<Integer, Integer> regularKeyCodesMap = new LinkedHashMap<Integer, Integer>();

    private KeyboardUtils() {
    }

    public static Map<Integer, Integer> getRegularKeyCodesMap() {
        return regularKeyCodesMap;
    }

    public static List<Character> getCharactersForKey(char row, int column) {
        return KeyboardUtils.getCharactersForKey(row, column, InputContext.getInstance().getLocale());
    }

    public static List<Character> getCharactersForKey(char row, int column, Locale l) {
        if (l == null) {
            l = I18n.getOriginalLocale();
        }
        if ('E' == row && 0 == column) {
            ArrayList<Character> result = new ArrayList<Character>();
            switch (l.getLanguage()) {
                case "ar": {
                    result.add(Character.valueOf('\u0630'));
                    result.add(Character.valueOf('>'));
                    break;
                }
                case "fr": {
                    if ("CA".equals(l.getCountry())) {
                        result.add(Character.valueOf('#'));
                    } else if (!"LU".equals(l.getCountry())) {
                        result.add(Character.valueOf('\u00b2'));
                    }
                    result.add(Character.valueOf('$'));
                    if (!PlatformManager.isPlatformUnixoid()) break;
                    result.add(Character.valueOf('\u0153'));
                    break;
                }
                case "sq": 
                case "it": 
                case "pt": {
                    if ("BR".equals(l.getCountry())) {
                        result.add(Character.valueOf('\''));
                        break;
                    }
                    result.add(Character.valueOf('\\'));
                    break;
                }
                case "de": {
                    result.add(Character.valueOf('\u0082'));
                    result.add(Character.valueOf('\u02c6'));
                    break;
                }
                case "cs": 
                case "he": {
                    result.add(Character.valueOf(';'));
                    break;
                }
                case "hu": {
                    result.add(Character.valueOf('0'));
                    break;
                }
                case "bs": 
                case "hr": 
                case "sl": 
                case "sr": {
                    result.add(Character.valueOf('\u00b8'));
                    break;
                }
                case "ro": {
                    result.add(Character.valueOf(']'));
                    break;
                }
                case "da": 
                case "fo": {
                    result.add(Character.valueOf('\u00bd'));
                    break;
                }
                case "nl": {
                    result.add(Character.valueOf('@'));
                    break;
                }
                case "et": {
                    result.add(Character.valueOf('\u008a'));
                    result.add(Character.valueOf('\u02c7'));
                    break;
                }
                case "is": {
                    result.add(Character.valueOf('\u00b0'));
                    break;
                }
                case "es": {
                    if ("ES".equals(l.getCountry())) break;
                    result.add(Character.valueOf('|'));
                    break;
                }
                case "tr": {
                    result.add(Character.valueOf('\"'));
                    result.add(Character.valueOf('*'));
                    break;
                }
            }
            switch (l.getCountry()) {
                case "LU": {
                    result.add(Character.valueOf('\u00b2'));
                }
                case "CH": 
                case "LI": 
                case "FI": 
                case "SE": {
                    result.add(Character.valueOf('\u00a7'));
                    break;
                }
                case "CA": {
                    result.add(Character.valueOf('/'));
                    break;
                }
                case "NO": {
                    result.add(Character.valueOf('|'));
                    break;
                }
                case "ES": {
                    result.add(Character.valueOf('\u00ba'));
                    break;
                }
            }
            if (PlatformManager.isPlatformOsx()) {
                result.add(Character.valueOf('\u00a7'));
            }
            result.add(Character.valueOf('`'));
            result.add(Character.valueOf('\u0080'));
            result.add(Character.valueOf('\u02cb'));
            return result;
        }
        throw new UnsupportedOperationException();
    }

    public static Map<Integer, Character> getExtendedKeyCodes(Locale locale) {
        LinkedHashMap<Integer, Character> map = new LinkedHashMap<Integer, Character>();
        KeyboardUtils.addLatinCharacters(map);
        KeyboardUtils.addSymbolCharacters(map);
        if (locale == null) {
            locale = I18n.getOriginalLocale();
        }
        switch (locale.getScript()) {
            case "Arab": 
            case "Aran": {
                KeyboardUtils.addArabicCharacters(map);
                break;
            }
            case "Armn": {
                KeyboardUtils.addArmenianCharacters(map);
                break;
            }
            case "Cyrl": {
                KeyboardUtils.addCyrillicCharacters(map);
                break;
            }
            case "Geok": 
            case "Geor": {
                KeyboardUtils.addGeorgianCharacters(map);
                break;
            }
            case "Grek": {
                KeyboardUtils.addGreekCharacters(map);
                break;
            }
            case "Hebr": {
                KeyboardUtils.addHebrewCharacters(map);
                break;
            }
            case "Hira": 
            case "Jpan": 
            case "Kana": {
                KeyboardUtils.addJapaneseCharacters(map);
                break;
            }
            case "Thai": {
                KeyboardUtils.addThaiCharacters(map);
                break;
            }
        }
        return map;
    }

    static void addLatinCharacters(Map<Integer, Character> map) {
        map.put(0x1000060, Character.valueOf('`'));
        map.put(16777340, Character.valueOf('|'));
        map.put(16777342, Character.valueOf('~'));
        map.put(16777378, Character.valueOf('\u00a2'));
        map.put(16777379, Character.valueOf('\u00a3'));
        map.put(16777381, Character.valueOf('\u00a5'));
        map.put(16777383, Character.valueOf('\u00a7'));
        map.put(16777384, Character.valueOf('\u00a8'));
        map.put(16777387, Character.valueOf('\u00ab'));
        map.put(0x10000B0, Character.valueOf('\u00b0'));
        map.put(0x10000B1, Character.valueOf('\u00b1'));
        map.put(16777394, Character.valueOf('\u00b2'));
        map.put(16777395, Character.valueOf('\u00b3'));
        map.put(16777396, Character.valueOf('\u00b4'));
        map.put(16777397, Character.valueOf('\u00b5'));
        map.put(16777398, Character.valueOf('\u00b6'));
        map.put(16777399, Character.valueOf('\u00b7'));
        map.put(16777401, Character.valueOf('\u00b9'));
        map.put(16777402, Character.valueOf('\u00ba'));
        map.put(0x10000BB, Character.valueOf('\u00bb'));
        map.put(16777404, Character.valueOf('\u00bc'));
        map.put(16777405, Character.valueOf('\u00bd'));
        map.put(16777406, Character.valueOf('\u00be'));
        map.put(16777407, Character.valueOf('\u00bf'));
        map.put(16777412, Character.valueOf('\u00c4'));
        map.put(16777413, Character.valueOf('\u00c5'));
        map.put(16777414, Character.valueOf('\u00c6'));
        map.put(16777415, Character.valueOf('\u00c7'));
        map.put(0x10000D1, Character.valueOf('\u00d1'));
        map.put(16777430, Character.valueOf('\u00d6'));
        map.put(16777431, Character.valueOf('\u00d7'));
        map.put(16777432, Character.valueOf('\u00d8'));
        map.put(16777439, Character.valueOf('\u00df'));
        map.put(0x10000E0, Character.valueOf('\u00e0'));
        map.put(0x10000E1, Character.valueOf('\u00e1'));
        map.put(16777442, Character.valueOf('\u00e2'));
        map.put(16777444, Character.valueOf('\u00e4'));
        map.put(16777445, Character.valueOf('\u00e5'));
        map.put(16777446, Character.valueOf('\u00e6'));
        map.put(16777447, Character.valueOf('\u00e7'));
        map.put(16777448, Character.valueOf('\u00e8'));
        map.put(16777449, Character.valueOf('\u00e9'));
        map.put(16777450, Character.valueOf('\u00ea'));
        map.put(16777451, Character.valueOf('\u00eb'));
        map.put(16777452, Character.valueOf('\u00ec'));
        map.put(16777453, Character.valueOf('\u00ed'));
        map.put(0x10000EE, Character.valueOf('\u00ee'));
        map.put(0x10000F0, Character.valueOf('\u00f0'));
        map.put(0x10000F1, Character.valueOf('\u00f1'));
        map.put(16777458, Character.valueOf('\u00f2'));
        map.put(16777459, Character.valueOf('\u00f3'));
        map.put(16777460, Character.valueOf('\u00f4'));
        map.put(16777461, Character.valueOf('\u00f5'));
        map.put(16777462, Character.valueOf('\u00f6'));
        map.put(16777463, Character.valueOf('\u00f7'));
        map.put(16777464, Character.valueOf('\u00f8'));
        map.put(16777465, Character.valueOf('\u00f9'));
        map.put(16777466, Character.valueOf('\u00fa'));
        map.put(16777467, Character.valueOf('\u00fb'));
        map.put(16777468, Character.valueOf('\u00fc'));
        map.put(16777469, Character.valueOf('\u00fd'));
        map.put(16777470, Character.valueOf('\u00fe'));
        map.put(0x1000101, Character.valueOf('\u0101'));
        map.put(0x1000103, Character.valueOf('\u0103'));
        map.put(0x1000105, Character.valueOf('\u0105'));
        map.put(0x1000107, Character.valueOf('\u0107'));
        map.put(0x1000109, Character.valueOf('\u0109'));
        map.put(0x100010B, Character.valueOf('\u010b'));
        map.put(0x100010D, Character.valueOf('\u010d'));
        map.put(0x1000111, Character.valueOf('\u0111'));
        map.put(0x1000113, Character.valueOf('\u0113'));
        map.put(0x1000117, Character.valueOf('\u0117'));
        map.put(0x1000119, Character.valueOf('\u0119'));
        map.put(0x100011B, Character.valueOf('\u011b'));
        map.put(0x100011D, Character.valueOf('\u011d'));
        map.put(0x100011F, Character.valueOf('\u011f'));
        map.put(0x1000121, Character.valueOf('\u0121'));
        map.put(16777507, Character.valueOf('\u0123'));
        map.put(16777509, Character.valueOf('\u0125'));
        map.put(16777511, Character.valueOf('\u0127'));
        map.put(16777515, Character.valueOf('\u012b'));
        map.put(16777519, Character.valueOf('\u012f'));
        map.put(0x1000130, Character.valueOf('\u0130'));
        map.put(0x1000131, Character.valueOf('\u0131'));
        map.put(16777525, Character.valueOf('\u0135'));
        map.put(16777527, Character.valueOf('\u0137'));
        map.put(16777528, Character.valueOf('\u0138'));
        map.put(16777532, Character.valueOf('\u013c'));
        map.put(16777534, Character.valueOf('\u013e'));
        map.put(16777538, Character.valueOf('\u0142'));
        map.put(16777542, Character.valueOf('\u0146'));
        map.put(16777544, Character.valueOf('\u0148'));
        map.put(16777547, Character.valueOf('\u014b'));
        map.put(16777549, Character.valueOf('\u014d'));
        map.put(0x1000151, Character.valueOf('\u0151'));
        map.put(16777555, Character.valueOf('\u0153'));
        map.put(16777559, Character.valueOf('\u0157'));
        map.put(16777561, Character.valueOf('\u0159'));
        map.put(16777563, Character.valueOf('\u015b'));
        map.put(16777565, Character.valueOf('\u015d'));
        map.put(16777567, Character.valueOf('\u015f'));
        map.put(0x1000161, Character.valueOf('\u0161'));
        map.put(16777571, Character.valueOf('\u0163'));
        map.put(16777573, Character.valueOf('\u0165'));
        map.put(16777575, Character.valueOf('\u0167'));
        map.put(16777579, Character.valueOf('\u016b'));
        map.put(16777581, Character.valueOf('\u016d'));
        map.put(16777583, Character.valueOf('\u016f'));
        map.put(0x1000171, Character.valueOf('\u0171'));
        map.put(16777587, Character.valueOf('\u0173'));
        map.put(16777596, Character.valueOf('\u017c'));
        map.put(16777598, Character.valueOf('\u017e'));
        map.put(0x10001A1, Character.valueOf('\u01a1'));
        map.put(0x10001B0, Character.valueOf('\u01b0'));
        map.put(16777703, Character.valueOf('\u01e7'));
        map.put(16777817, Character.valueOf('\u0259'));
        map.put(16777945, Character.valueOf('\u02d9'));
        map.put(16777947, Character.valueOf('\u02db'));
        map.put(16785081, Character.valueOf('\u1eb9'));
        map.put(16785099, Character.valueOf('\u1ecb'));
        map.put(16785101, Character.valueOf('\u1ecd'));
        map.put(16785125, Character.valueOf('\u1ee5'));
    }

    static void addGreekCharacters(Map<Integer, Character> map) {
        map.put(16778161, Character.valueOf('\u03b1'));
        map.put(16778162, Character.valueOf('\u03b2'));
        map.put(16778163, Character.valueOf('\u03b3'));
        map.put(16778164, Character.valueOf('\u03b4'));
        map.put(16778165, Character.valueOf('\u03b5'));
        map.put(16778166, Character.valueOf('\u03b6'));
        map.put(16778167, Character.valueOf('\u03b7'));
        map.put(16778168, Character.valueOf('\u03b8'));
        map.put(16778169, Character.valueOf('\u03b9'));
        map.put(16778170, Character.valueOf('\u03ba'));
        map.put(16778171, Character.valueOf('\u03bb'));
        map.put(16778172, Character.valueOf('\u03bc'));
        map.put(16778173, Character.valueOf('\u03bd'));
        map.put(16778174, Character.valueOf('\u03be'));
        map.put(16778175, Character.valueOf('\u03bf'));
        map.put(16778176, Character.valueOf('\u03c0'));
        map.put(16778177, Character.valueOf('\u03c1'));
        map.put(16778178, Character.valueOf('\u03c2'));
        map.put(16778179, Character.valueOf('\u03c3'));
        map.put(16778180, Character.valueOf('\u03c4'));
        map.put(16778181, Character.valueOf('\u03c5'));
        map.put(16778182, Character.valueOf('\u03c6'));
        map.put(16778183, Character.valueOf('\u03c7'));
        map.put(16778184, Character.valueOf('\u03c8'));
        map.put(16778185, Character.valueOf('\u03c9'));
    }

    static void addCyrillicCharacters(Map<Integer, Character> map) {
        map.put(16778288, Character.valueOf('\u0430'));
        map.put(16778289, Character.valueOf('\u0431'));
        map.put(16778290, Character.valueOf('\u0432'));
        map.put(16778291, Character.valueOf('\u0433'));
        map.put(16778292, Character.valueOf('\u0434'));
        map.put(16778293, Character.valueOf('\u0435'));
        map.put(16778294, Character.valueOf('\u0436'));
        map.put(16778295, Character.valueOf('\u0437'));
        map.put(16778296, Character.valueOf('\u0438'));
        map.put(16778297, Character.valueOf('\u0439'));
        map.put(16778298, Character.valueOf('\u043a'));
        map.put(16778299, Character.valueOf('\u043b'));
        map.put(16778300, Character.valueOf('\u043c'));
        map.put(16778301, Character.valueOf('\u043d'));
        map.put(16778302, Character.valueOf('\u043e'));
        map.put(16778303, Character.valueOf('\u043f'));
        map.put(0x1000440, Character.valueOf('\u0440'));
        map.put(0x1000441, Character.valueOf('\u0441'));
        map.put(16778306, Character.valueOf('\u0442'));
        map.put(16778307, Character.valueOf('\u0443'));
        map.put(0x1000444, Character.valueOf('\u0444'));
        map.put(16778309, Character.valueOf('\u0445'));
        map.put(16778310, Character.valueOf('\u0446'));
        map.put(16778311, Character.valueOf('\u0447'));
        map.put(16778312, Character.valueOf('\u0448'));
        map.put(16778313, Character.valueOf('\u0449'));
        map.put(16778314, Character.valueOf('\u044a'));
        map.put(16778315, Character.valueOf('\u044b'));
        map.put(16778316, Character.valueOf('\u044c'));
        map.put(16778317, Character.valueOf('\u044d'));
        map.put(16778318, Character.valueOf('\u044e'));
        map.put(16778319, Character.valueOf('\u044f'));
        map.put(16778321, Character.valueOf('\u0451'));
        map.put(16778322, Character.valueOf('\u0452'));
        map.put(16778323, Character.valueOf('\u0453'));
        map.put(16778324, Character.valueOf('\u0454'));
        map.put(16778325, Character.valueOf('\u0455'));
        map.put(16778326, Character.valueOf('\u0456'));
        map.put(16778327, Character.valueOf('\u0457'));
        map.put(16778328, Character.valueOf('\u0458'));
        map.put(16778329, Character.valueOf('\u0459'));
        map.put(16778330, Character.valueOf('\u045a'));
        map.put(16778331, Character.valueOf('\u045b'));
        map.put(16778332, Character.valueOf('\u045c'));
        map.put(16778334, Character.valueOf('\u045e'));
        map.put(16778335, Character.valueOf('\u045f'));
        map.put(16778385, Character.valueOf('\u0491'));
        map.put(16778387, Character.valueOf('\u0493'));
        map.put(16778391, Character.valueOf('\u0497'));
        map.put(16778395, Character.valueOf('\u049b'));
        map.put(16778397, Character.valueOf('\u049d'));
        map.put(16778403, Character.valueOf('\u04a3'));
        map.put(16778415, Character.valueOf('\u04af'));
        map.put(16778417, Character.valueOf('\u04b1'));
        map.put(16778419, Character.valueOf('\u04b3'));
        map.put(16778425, Character.valueOf('\u04b9'));
        map.put(16778427, Character.valueOf('\u04bb'));
        map.put(16778457, Character.valueOf('\u04d9'));
        map.put(16778473, Character.valueOf('\u04e9'));
    }

    static void addArmenianCharacters(Map<Integer, Character> map) {
        map.put(16778586, Character.valueOf('\u055a'));
        map.put(16778587, Character.valueOf('\u055b'));
        map.put(16778588, Character.valueOf('\u055c'));
        map.put(16778589, Character.valueOf('\u055d'));
        map.put(16778590, Character.valueOf('\u055e'));
        map.put(16778591, Character.valueOf('\u055f'));
        map.put(16778593, Character.valueOf('\u0561'));
        map.put(16778594, Character.valueOf('\u0562'));
        map.put(16778595, Character.valueOf('\u0563'));
        map.put(16778596, Character.valueOf('\u0564'));
        map.put(16778597, Character.valueOf('\u0565'));
        map.put(16778598, Character.valueOf('\u0566'));
        map.put(16778599, Character.valueOf('\u0567'));
        map.put(16778600, Character.valueOf('\u0568'));
        map.put(16778601, Character.valueOf('\u0569'));
        map.put(16778602, Character.valueOf('\u056a'));
        map.put(16778603, Character.valueOf('\u056b'));
        map.put(16778604, Character.valueOf('\u056c'));
        map.put(16778605, Character.valueOf('\u056d'));
        map.put(16778606, Character.valueOf('\u056e'));
        map.put(16778607, Character.valueOf('\u056f'));
        map.put(16778608, Character.valueOf('\u0570'));
        map.put(16778609, Character.valueOf('\u0571'));
        map.put(16778610, Character.valueOf('\u0572'));
        map.put(16778611, Character.valueOf('\u0573'));
        map.put(16778612, Character.valueOf('\u0574'));
        map.put(16778613, Character.valueOf('\u0575'));
        map.put(16778614, Character.valueOf('\u0576'));
        map.put(16778615, Character.valueOf('\u0577'));
        map.put(16778616, Character.valueOf('\u0578'));
        map.put(16778617, Character.valueOf('\u0579'));
        map.put(16778618, Character.valueOf('\u057a'));
        map.put(16778619, Character.valueOf('\u057b'));
        map.put(16778620, Character.valueOf('\u057c'));
        map.put(16778621, Character.valueOf('\u057d'));
        map.put(16778622, Character.valueOf('\u057e'));
        map.put(16778623, Character.valueOf('\u057f'));
        map.put(16778624, Character.valueOf('\u0580'));
        map.put(16778625, Character.valueOf('\u0581'));
        map.put(16778626, Character.valueOf('\u0582'));
        map.put(16778627, Character.valueOf('\u0583'));
        map.put(16778628, Character.valueOf('\u0584'));
        map.put(16778629, Character.valueOf('\u0585'));
        map.put(16778630, Character.valueOf('\u0586'));
        map.put(16778631, Character.valueOf('\u0587'));
        map.put(16778633, Character.valueOf('\u0589'));
    }

    static void addHebrewCharacters(Map<Integer, Character> map) {
        map.put(16778704, Character.valueOf('\u05d0'));
        map.put(16778705, Character.valueOf('\u05d1'));
        map.put(16778706, Character.valueOf('\u05d2'));
        map.put(16778707, Character.valueOf('\u05d3'));
        map.put(16778708, Character.valueOf('\u05d4'));
        map.put(16778709, Character.valueOf('\u05d5'));
        map.put(16778710, Character.valueOf('\u05d6'));
        map.put(16778711, Character.valueOf('\u05d7'));
        map.put(16778712, Character.valueOf('\u05d8'));
        map.put(16778713, Character.valueOf('\u05d9'));
        map.put(16778714, Character.valueOf('\u05da'));
        map.put(16778715, Character.valueOf('\u05db'));
        map.put(16778716, Character.valueOf('\u05dc'));
        map.put(16778717, Character.valueOf('\u05dd'));
        map.put(16778718, Character.valueOf('\u05de'));
        map.put(16778719, Character.valueOf('\u05df'));
        map.put(16778720, Character.valueOf('\u05e0'));
        map.put(16778721, Character.valueOf('\u05e1'));
        map.put(16778722, Character.valueOf('\u05e2'));
        map.put(16778723, Character.valueOf('\u05e3'));
        map.put(16778724, Character.valueOf('\u05e4'));
        map.put(16778725, Character.valueOf('\u05e5'));
        map.put(16778726, Character.valueOf('\u05e6'));
        map.put(16778727, Character.valueOf('\u05e7'));
        map.put(16778728, Character.valueOf('\u05e8'));
        map.put(16778729, Character.valueOf('\u05e9'));
        map.put(16778730, Character.valueOf('\u05ea'));
    }

    static void addArabicCharacters(Map<Integer, Character> map) {
        map.put(16778764, Character.valueOf('\u060c'));
        map.put(16778779, Character.valueOf('\u061b'));
        map.put(16778785, Character.valueOf('\u0621'));
        map.put(16778788, Character.valueOf('\u0624'));
        map.put(16778790, Character.valueOf('\u0626'));
        map.put(16778791, Character.valueOf('\u0627'));
        map.put(16778792, Character.valueOf('\u0628'));
        map.put(16778793, Character.valueOf('\u0629'));
        map.put(16778794, Character.valueOf('\u062a'));
        map.put(16778795, Character.valueOf('\u062b'));
        map.put(16778796, Character.valueOf('\u062c'));
        map.put(16778797, Character.valueOf('\u062d'));
        map.put(16778798, Character.valueOf('\u062e'));
        map.put(16778799, Character.valueOf('\u062f'));
        map.put(16778800, Character.valueOf('\u0630'));
        map.put(16778801, Character.valueOf('\u0631'));
        map.put(16778802, Character.valueOf('\u0632'));
        map.put(16778803, Character.valueOf('\u0633'));
        map.put(16778804, Character.valueOf('\u0634'));
        map.put(16778805, Character.valueOf('\u0635'));
        map.put(16778806, Character.valueOf('\u0636'));
        map.put(16778807, Character.valueOf('\u0637'));
        map.put(16778808, Character.valueOf('\u0638'));
        map.put(16778809, Character.valueOf('\u0639'));
        map.put(16778810, Character.valueOf('\u063a'));
        map.put(16778817, Character.valueOf('\u0641'));
        map.put(16778818, Character.valueOf('\u0642'));
        map.put(16778819, Character.valueOf('\u0643'));
        map.put(16778820, Character.valueOf('\u0644'));
        map.put(16778821, Character.valueOf('\u0645'));
        map.put(16778822, Character.valueOf('\u0646'));
        map.put(16778823, Character.valueOf('\u0647'));
        map.put(16778824, Character.valueOf('\u0648'));
        map.put(16778825, Character.valueOf('\u0649'));
        map.put(16778826, Character.valueOf('\u064a'));
        map.put(16778830, Character.valueOf('\u064e'));
        map.put(16778831, Character.valueOf('\u064f'));
        map.put(16778832, Character.valueOf('\u0650'));
        map.put(16778834, Character.valueOf('\u0652'));
        map.put(0x1000660, Character.valueOf('\u0660'));
        map.put(0x1000661, Character.valueOf('\u0661'));
        map.put(16778850, Character.valueOf('\u0662'));
        map.put(16778851, Character.valueOf('\u0663'));
        map.put(16778852, Character.valueOf('\u0664'));
        map.put(16778853, Character.valueOf('\u0665'));
        map.put(0x1000666, Character.valueOf('\u0666'));
        map.put(16778855, Character.valueOf('\u0667'));
        map.put(16778856, Character.valueOf('\u0668'));
        map.put(16778857, Character.valueOf('\u0669'));
        map.put(16778864, Character.valueOf('\u0670'));
        map.put(16778878, Character.valueOf('\u067e'));
        map.put(16778886, Character.valueOf('\u0686'));
        map.put(16778904, Character.valueOf('\u0698'));
        map.put(16778916, Character.valueOf('\u06a4'));
        map.put(16778921, Character.valueOf('\u06a9'));
        map.put(16778927, Character.valueOf('\u06af'));
        map.put(16778942, Character.valueOf('\u06be'));
        map.put(16778956, Character.valueOf('\u06cc'));
        map.put(16778962, Character.valueOf('\u06d2'));
        map.put(16778964, Character.valueOf('\u06d4'));
        map.put(16778992, Character.valueOf('\u06f0'));
        map.put(16778993, Character.valueOf('\u06f1'));
        map.put(16778994, Character.valueOf('\u06f2'));
        map.put(16778995, Character.valueOf('\u06f3'));
        map.put(16778996, Character.valueOf('\u06f4'));
        map.put(16778997, Character.valueOf('\u06f5'));
        map.put(16778998, Character.valueOf('\u06f6'));
        map.put(16778999, Character.valueOf('\u06f7'));
        map.put(16779000, Character.valueOf('\u06f8'));
        map.put(16779001, Character.valueOf('\u06f9'));
    }

    static void addThaiCharacters(Map<Integer, Character> map) {
        map.put(0x1000E01, Character.valueOf('\u0e01'));
        map.put(16780802, Character.valueOf('\u0e02'));
        map.put(16780803, Character.valueOf('\u0e03'));
        map.put(16780804, Character.valueOf('\u0e04'));
        map.put(16780805, Character.valueOf('\u0e05'));
        map.put(16780807, Character.valueOf('\u0e07'));
        map.put(16780808, Character.valueOf('\u0e08'));
        map.put(16780810, Character.valueOf('\u0e0a'));
        map.put(16780812, Character.valueOf('\u0e0c'));
        map.put(16780820, Character.valueOf('\u0e14'));
        map.put(16780821, Character.valueOf('\u0e15'));
        map.put(16780822, Character.valueOf('\u0e16'));
        map.put(16780823, Character.valueOf('\u0e17'));
        map.put(16780825, Character.valueOf('\u0e19'));
        map.put(16780826, Character.valueOf('\u0e1a'));
        map.put(16780827, Character.valueOf('\u0e1b'));
        map.put(16780828, Character.valueOf('\u0e1c'));
        map.put(16780829, Character.valueOf('\u0e1d'));
        map.put(0x1000E1E, Character.valueOf('\u0e1e'));
        map.put(16780831, Character.valueOf('\u0e1f'));
        map.put(16780832, Character.valueOf('\u0e20'));
        map.put(16780833, Character.valueOf('\u0e21'));
        map.put(16780834, Character.valueOf('\u0e22'));
        map.put(16780835, Character.valueOf('\u0e23'));
        map.put(16780837, Character.valueOf('\u0e25'));
        map.put(16780839, Character.valueOf('\u0e27'));
        map.put(16780842, Character.valueOf('\u0e2a'));
        map.put(16780843, Character.valueOf('\u0e2b'));
        map.put(16780845, Character.valueOf('\u0e2d'));
        map.put(16780848, Character.valueOf('\u0e30'));
        map.put(16780849, Character.valueOf('\u0e31'));
        map.put(16780850, Character.valueOf('\u0e32'));
        map.put(16780851, Character.valueOf('\u0e33'));
        map.put(16780852, Character.valueOf('\u0e34'));
        map.put(16780853, Character.valueOf('\u0e35'));
        map.put(16780854, Character.valueOf('\u0e36'));
        map.put(16780855, Character.valueOf('\u0e37'));
        map.put(16780856, Character.valueOf('\u0e38'));
        map.put(16780857, Character.valueOf('\u0e39'));
        map.put(16780863, Character.valueOf('\u0e3f'));
        map.put(16780864, Character.valueOf('\u0e40'));
        map.put(16780865, Character.valueOf('\u0e41'));
        map.put(16780867, Character.valueOf('\u0e43'));
        map.put(16780868, Character.valueOf('\u0e44'));
        map.put(16780869, Character.valueOf('\u0e45'));
        map.put(16780870, Character.valueOf('\u0e46'));
        map.put(16780871, Character.valueOf('\u0e47'));
        map.put(16780872, Character.valueOf('\u0e48'));
        map.put(16780873, Character.valueOf('\u0e49'));
        map.put(16780880, Character.valueOf('\u0e50'));
        map.put(16780881, Character.valueOf('\u0e51'));
        map.put(16780882, Character.valueOf('\u0e52'));
        map.put(16780883, Character.valueOf('\u0e53'));
        map.put(16780884, Character.valueOf('\u0e54'));
        map.put(16780885, Character.valueOf('\u0e55'));
        map.put(16780886, Character.valueOf('\u0e56'));
        map.put(16780887, Character.valueOf('\u0e57'));
        map.put(16780888, Character.valueOf('\u0e58'));
        map.put(16780889, Character.valueOf('\u0e59'));
    }

    static void addGeorgianCharacters(Map<Integer, Character> map) {
        map.put(0x10010D0, Character.valueOf('\u10d0'));
        map.put(0x10010D1, Character.valueOf('\u10d1'));
        map.put(16781522, Character.valueOf('\u10d2'));
        map.put(16781523, Character.valueOf('\u10d3'));
        map.put(16781524, Character.valueOf('\u10d4'));
        map.put(16781525, Character.valueOf('\u10d5'));
        map.put(16781526, Character.valueOf('\u10d6'));
        map.put(16781527, Character.valueOf('\u10d7'));
        map.put(16781528, Character.valueOf('\u10d8'));
        map.put(16781529, Character.valueOf('\u10d9'));
        map.put(16781530, Character.valueOf('\u10da'));
        map.put(16781531, Character.valueOf('\u10db'));
        map.put(16781532, Character.valueOf('\u10dc'));
        map.put(0x10010DD, Character.valueOf('\u10dd'));
        map.put(16781534, Character.valueOf('\u10de'));
        map.put(16781535, Character.valueOf('\u10df'));
        map.put(0x10010E0, Character.valueOf('\u10e0'));
        map.put(0x10010E1, Character.valueOf('\u10e1'));
        map.put(16781538, Character.valueOf('\u10e2'));
        map.put(16781539, Character.valueOf('\u10e3'));
        map.put(16781540, Character.valueOf('\u10e4'));
        map.put(16781541, Character.valueOf('\u10e5'));
        map.put(16781542, Character.valueOf('\u10e6'));
        map.put(16781543, Character.valueOf('\u10e7'));
        map.put(16781544, Character.valueOf('\u10e8'));
        map.put(16781545, Character.valueOf('\u10e9'));
        map.put(16781546, Character.valueOf('\u10ea'));
        map.put(16781547, Character.valueOf('\u10eb'));
        map.put(16781548, Character.valueOf('\u10ec'));
        map.put(16781549, Character.valueOf('\u10ed'));
        map.put(0x10010EE, Character.valueOf('\u10ee'));
        map.put(16781551, Character.valueOf('\u10ef'));
        map.put(0x10010F0, Character.valueOf('\u10f0'));
    }

    static void addSymbolCharacters(Map<Integer, Character> map) {
        map.put(16785427, Character.valueOf('\u2013'));
        map.put(16785429, Character.valueOf('\u2015'));
        map.put(16785436, Character.valueOf('\u201c'));
        map.put(16785437, Character.valueOf('\u201d'));
        map.put(16785438, Character.valueOf('\u201e'));
        map.put(16785579, Character.valueOf('\u20ab'));
        map.put(16785686, Character.valueOf('\u2116'));
        map.put(16785808, Character.valueOf('\u2190'));
        map.put(16785809, Character.valueOf('\u2191'));
        map.put(16785810, Character.valueOf('\u2192'));
        map.put(16785811, Character.valueOf('\u2193'));
    }

    static void addJapaneseCharacters(Map<Integer, Character> map) {
        map.put(16789659, Character.valueOf('\u309b'));
        map.put(16789660, Character.valueOf('\u309c'));
        map.put(16789666, Character.valueOf('\u30a2'));
        map.put(16789668, Character.valueOf('\u30a4'));
        map.put(16789670, Character.valueOf('\u30a6'));
        map.put(16789672, Character.valueOf('\u30a8'));
        map.put(16789674, Character.valueOf('\u30aa'));
        map.put(16789675, Character.valueOf('\u30ab'));
        map.put(16789677, Character.valueOf('\u30ad'));
        map.put(16789679, Character.valueOf('\u30af'));
        map.put(16789681, Character.valueOf('\u30b1'));
        map.put(16789683, Character.valueOf('\u30b3'));
        map.put(16789685, Character.valueOf('\u30b5'));
        map.put(16789687, Character.valueOf('\u30b7'));
        map.put(16789689, Character.valueOf('\u30b9'));
        map.put(16789691, Character.valueOf('\u30bb'));
        map.put(16789693, Character.valueOf('\u30bd'));
        map.put(16789695, Character.valueOf('\u30bf'));
        map.put(16789697, Character.valueOf('\u30c1'));
        map.put(16789700, Character.valueOf('\u30c4'));
        map.put(16789702, Character.valueOf('\u30c6'));
        map.put(16789704, Character.valueOf('\u30c8'));
        map.put(16789706, Character.valueOf('\u30ca'));
        map.put(16789707, Character.valueOf('\u30cb'));
        map.put(16789708, Character.valueOf('\u30cc'));
        map.put(16789709, Character.valueOf('\u30cd'));
        map.put(16789710, Character.valueOf('\u30ce'));
        map.put(16789711, Character.valueOf('\u30cf'));
        map.put(16789714, Character.valueOf('\u30d2'));
        map.put(16789717, Character.valueOf('\u30d5'));
        map.put(16789720, Character.valueOf('\u30d8'));
        map.put(16789723, Character.valueOf('\u30db'));
        map.put(16789726, Character.valueOf('\u30de'));
        map.put(16789727, Character.valueOf('\u30df'));
        map.put(16789728, Character.valueOf('\u30e0'));
        map.put(16789729, Character.valueOf('\u30e1'));
        map.put(16789730, Character.valueOf('\u30e2'));
        map.put(16789732, Character.valueOf('\u30e4'));
        map.put(16789734, Character.valueOf('\u30e6'));
        map.put(16789736, Character.valueOf('\u30e8'));
        map.put(16789737, Character.valueOf('\u30e9'));
        map.put(16789738, Character.valueOf('\u30ea'));
        map.put(16789739, Character.valueOf('\u30eb'));
        map.put(16789740, Character.valueOf('\u30ec'));
        map.put(16789741, Character.valueOf('\u30ed'));
        map.put(16789743, Character.valueOf('\u30ef'));
        map.put(16789747, Character.valueOf('\u30f3'));
        map.put(16789756, Character.valueOf('\u30fc'));
    }

    static {
        regularKeyCodesMap.put(8, 8);
        regularKeyCodesMap.put(9, 9);
        regularKeyCodesMap.put(10, 10);
        regularKeyCodesMap.put(27, 27);
        regularKeyCodesMap.put(8364, 516);
        regularKeyCodesMap.put(32, 32);
        regularKeyCodesMap.put(33, 517);
        regularKeyCodesMap.put(34, 152);
        regularKeyCodesMap.put(35, 520);
        regularKeyCodesMap.put(36, 515);
        regularKeyCodesMap.put(38, 150);
        regularKeyCodesMap.put(39, 222);
        regularKeyCodesMap.put(40, 519);
        regularKeyCodesMap.put(41, 522);
        regularKeyCodesMap.put(42, 151);
        regularKeyCodesMap.put(43, 521);
        regularKeyCodesMap.put(44, 44);
        regularKeyCodesMap.put(45, 45);
        regularKeyCodesMap.put(46, 46);
        regularKeyCodesMap.put(47, 47);
        regularKeyCodesMap.put(48, 48);
        regularKeyCodesMap.put(49, 49);
        regularKeyCodesMap.put(50, 50);
        regularKeyCodesMap.put(51, 51);
        regularKeyCodesMap.put(52, 52);
        regularKeyCodesMap.put(53, 53);
        regularKeyCodesMap.put(54, 54);
        regularKeyCodesMap.put(55, 55);
        regularKeyCodesMap.put(56, 56);
        regularKeyCodesMap.put(57, 57);
        regularKeyCodesMap.put(58, 513);
        regularKeyCodesMap.put(59, 59);
        regularKeyCodesMap.put(60, 153);
        regularKeyCodesMap.put(61, 61);
        regularKeyCodesMap.put(62, 160);
        regularKeyCodesMap.put(64, 512);
        regularKeyCodesMap.put(65, 65);
        regularKeyCodesMap.put(66, 66);
        regularKeyCodesMap.put(67, 67);
        regularKeyCodesMap.put(68, 68);
        regularKeyCodesMap.put(69, 69);
        regularKeyCodesMap.put(70, 70);
        regularKeyCodesMap.put(71, 71);
        regularKeyCodesMap.put(72, 72);
        regularKeyCodesMap.put(73, 73);
        regularKeyCodesMap.put(74, 74);
        regularKeyCodesMap.put(75, 75);
        regularKeyCodesMap.put(76, 76);
        regularKeyCodesMap.put(77, 77);
        regularKeyCodesMap.put(78, 78);
        regularKeyCodesMap.put(79, 79);
        regularKeyCodesMap.put(80, 80);
        regularKeyCodesMap.put(81, 81);
        regularKeyCodesMap.put(82, 82);
        regularKeyCodesMap.put(83, 83);
        regularKeyCodesMap.put(84, 84);
        regularKeyCodesMap.put(85, 85);
        regularKeyCodesMap.put(86, 86);
        regularKeyCodesMap.put(87, 87);
        regularKeyCodesMap.put(88, 88);
        regularKeyCodesMap.put(89, 89);
        regularKeyCodesMap.put(90, 90);
        regularKeyCodesMap.put(91, 91);
        regularKeyCodesMap.put(92, 92);
        regularKeyCodesMap.put(93, 93);
        regularKeyCodesMap.put(94, 514);
        regularKeyCodesMap.put(95, 523);
        regularKeyCodesMap.put(96, 192);
        regularKeyCodesMap.put(97, 65);
        regularKeyCodesMap.put(98, 66);
        regularKeyCodesMap.put(99, 67);
        regularKeyCodesMap.put(100, 68);
        regularKeyCodesMap.put(101, 69);
        regularKeyCodesMap.put(102, 70);
        regularKeyCodesMap.put(103, 71);
        regularKeyCodesMap.put(104, 72);
        regularKeyCodesMap.put(105, 73);
        regularKeyCodesMap.put(106, 74);
        regularKeyCodesMap.put(107, 75);
        regularKeyCodesMap.put(108, 76);
        regularKeyCodesMap.put(109, 77);
        regularKeyCodesMap.put(110, 78);
        regularKeyCodesMap.put(111, 79);
        regularKeyCodesMap.put(112, 80);
        regularKeyCodesMap.put(113, 81);
        regularKeyCodesMap.put(114, 82);
        regularKeyCodesMap.put(115, 83);
        regularKeyCodesMap.put(116, 84);
        regularKeyCodesMap.put(117, 85);
        regularKeyCodesMap.put(118, 86);
        regularKeyCodesMap.put(119, 87);
        regularKeyCodesMap.put(120, 88);
        regularKeyCodesMap.put(121, 89);
        regularKeyCodesMap.put(122, 90);
        regularKeyCodesMap.put(123, 161);
        regularKeyCodesMap.put(125, 162);
        regularKeyCodesMap.put(127, 127);
        regularKeyCodesMap.put(161, 518);
    }
}

