"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../../../utils/commons");
var color_library_wrappers_1 = require("../../../../partition_chart/layout/utils/color_library_wrappers");
function buildLineStyles(baseColor, themeLineStyle, geometryStateStyle) {
    var strokeOpacity = function (opacity) { return opacity * themeLineStyle.opacity * geometryStateStyle.opacity; };
    var strokeColor = color_library_wrappers_1.stringToRGB(commons_1.getColorFromVariant(baseColor, themeLineStyle.stroke), strokeOpacity);
    return {
        color: strokeColor,
        width: themeLineStyle.strokeWidth,
        dash: themeLineStyle.dash,
    };
}
exports.buildLineStyles = buildLineStyles;
//# sourceMappingURL=line.js.map