"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AGGREGATE_KEY = 'value';
exports.STATISTICS_KEY = 'statistics';
exports.DEPTH_KEY = 'depth';
exports.CHILDREN_KEY = 'children';
exports.INPUT_KEY = 'inputIndex';
exports.PARENT_KEY = 'parent';
exports.SORT_INDEX_KEY = 'sortIndex';
exports.entryKey = function (_a) {
    var _b = __read(_a, 1), key = _b[0];
    return key;
};
exports.entryValue = function (_a) {
    var _b = __read(_a, 2), value = _b[1];
    return value;
};
function depthAccessor(n) {
    return exports.entryValue(n)[exports.DEPTH_KEY];
}
exports.depthAccessor = depthAccessor;
function aggregateAccessor(n) {
    return exports.entryValue(n)[exports.AGGREGATE_KEY];
}
exports.aggregateAccessor = aggregateAccessor;
function parentAccessor(n) {
    return exports.entryValue(n)[exports.PARENT_KEY];
}
exports.parentAccessor = parentAccessor;
function childrenAccessor(n) {
    return exports.entryValue(n)[exports.CHILDREN_KEY];
}
exports.childrenAccessor = childrenAccessor;
function sortIndexAccessor(n) {
    return exports.entryValue(n)[exports.SORT_INDEX_KEY];
}
exports.sortIndexAccessor = sortIndexAccessor;
var ascending = function (a, b) { return a - b; };
var descending = function (a, b) { return b - a; };
function groupByRollup(keyAccessors, valueAccessor, _a, factTable) {
    var reducer = _a.reducer, identity = _a.identity;
    var statistics = {
        globalAggregate: NaN,
    };
    var reductionMap = factTable.reduce(function (p, n, index) {
        var keyCount = keyAccessors.length;
        var pointer = p;
        keyAccessors.forEach(function (keyAccessor, i) {
            var _a, _b;
            var key = keyAccessor(n, index);
            var keyExists = pointer.has(key);
            var last = i === keyCount - 1;
            var node = keyExists && pointer.get(key);
            var inputIndices = node ? node[exports.INPUT_KEY] : [];
            var childrenMap = node ? node[exports.CHILDREN_KEY] : new Map();
            var aggregate = node ? node[exports.AGGREGATE_KEY] : identity();
            var reductionValue = reducer(aggregate, valueAccessor(n));
            pointer.set(key, __assign((_a = {}, _a[exports.AGGREGATE_KEY] = reductionValue, _a[exports.STATISTICS_KEY] = statistics, _a[exports.INPUT_KEY] = __spread(inputIndices, [index]), _a[exports.DEPTH_KEY] = i, _a), (!last && (_b = {}, _b[exports.CHILDREN_KEY] = childrenMap, _b))));
            if (childrenMap) {
                pointer = childrenMap;
            }
        });
        return p;
    }, new Map());
    if (reductionMap.get(null) !== void 0) {
        statistics.globalAggregate = reductionMap.get(null)[exports.AGGREGATE_KEY];
    }
    return reductionMap;
}
exports.groupByRollup = groupByRollup;
function getRootArrayNode() {
    var _a, _b;
    var children = [];
    var bootstrap = (_a = {}, _a[exports.AGGREGATE_KEY] = NaN, _a[exports.DEPTH_KEY] = NaN, _a[exports.CHILDREN_KEY] = children, _a[exports.INPUT_KEY] = [], _a);
    Object.assign(bootstrap, (_b = {}, _b[exports.PARENT_KEY] = bootstrap, _b));
    var result = bootstrap;
    return result;
}
function mapsToArrays(root, sorter) {
    var groupByMap = function (node, parent) {
        return Array.from(node, function (_a) {
            var _b, _c;
            var _d = __read(_a, 2), key = _d[0], value = _d[1];
            var valueElement = value[exports.CHILDREN_KEY];
            var resultNode = (_b = {},
                _b[exports.AGGREGATE_KEY] = NaN,
                _b[exports.STATISTICS_KEY] = { globalAggregate: NaN },
                _b[exports.CHILDREN_KEY] = [],
                _b[exports.DEPTH_KEY] = NaN,
                _b[exports.SORT_INDEX_KEY] = NaN,
                _b[exports.PARENT_KEY] = parent,
                _b[exports.INPUT_KEY] = [],
                _b);
            var newValue = Object.assign(resultNode, value, valueElement && (_c = {}, _c[exports.CHILDREN_KEY] = groupByMap(valueElement, resultNode), _c));
            return [key, newValue];
        })
            .sort(sorter)
            .map(function (n, i) {
            exports.entryValue(n).sortIndex = i;
            return n;
        });
    };
    return groupByMap(root, getRootArrayNode());
}
exports.mapsToArrays = mapsToArrays;
function mapEntryValue(entry) {
    return exports.entryValue(entry)[exports.AGGREGATE_KEY];
}
exports.mapEntryValue = mapEntryValue;
function aggregateComparator(accessor, sorter) {
    return function (a, b) { return sorter(accessor(a), accessor(b)); };
}
exports.aggregateComparator = aggregateComparator;
exports.childOrders = {
    ascending: ascending,
    descending: descending,
};
exports.aggregators = {
    one: {
        identity: function () { return 0; },
        reducer: function () { return 1; },
    },
    count: {
        identity: function () { return 0; },
        reducer: function (r) { return r + 1; },
    },
    sum: {
        identity: function () { return 0; },
        reducer: function (r, n) { return r + n; },
    },
    min: {
        identity: function () { return Infinity; },
        reducer: function (r, n) { return Math.min(r, n); },
    },
    max: {
        identity: function () { return -Infinity; },
        reducer: function (r, n) { return Math.max(r, n); },
    },
    min0: {
        identity: function () { return 0; },
        reducer: function (r, n) { return Math.min(r, n); },
    },
    max0: {
        identity: function () { return 0; },
        reducer: function (r, n) { return Math.max(r, n); },
    },
};
//# sourceMappingURL=group_by_rollup.js.map