/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.CssColors;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.RGB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\u001a*\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u000b*\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0005\u001a*\u0010\u0013\u001a\u00020\u0006*\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\t2\b\b\u0002\u0010\u0015\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\tH\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0006*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"funcSyntax", "Lkotlin/text/Regex;", "extractArgs", "Lkotlin/Pair;", "", "", "", "color", "validatePercents", "", "parseHex", "Lcom/github/ajalt/colormath/Color;", "hex", "parseHsl", "Lcom/github/ajalt/colormath/HSL;", "parseRgb", "Lcom/github/ajalt/colormath/RGB;", "fromCss", "Lcom/github/ajalt/colormath/Color$Companion;", "parse", "divBy255", "requirePercent", "isAngle", "withoutUnit", "count", "", "colormath"})
public final class CssParseKt {
    private static final Regex funcSyntax;

    @NotNull
    public static final Color fromCss(@NotNull Color.Companion $this$fromCss, @NotNull String color) {
        Intrinsics.checkNotNullParameter($this$fromCss, "$this$fromCss");
        Intrinsics.checkNotNullParameter(color, "color");
        String string = color;
        boolean bl = false;
        String trimmed = ((Object)StringsKt.trim((CharSequence)string)).toString();
        try {
            Color color2;
            RGB keywordColor = CssColors.INSTANCE.getColorsByName().get(trimmed);
            if (keywordColor != null) {
                color2 = keywordColor;
            } else if (StringsKt.startsWith$default(trimmed, "#", false, 2, null)) {
                color2 = CssParseKt.parseHex(trimmed);
            } else if (StringsKt.startsWith$default(trimmed, "rgb", false, 2, null)) {
                color2 = CssParseKt.parseRgb(trimmed);
            } else if (StringsKt.startsWith$default(trimmed, "hsl", false, 2, null)) {
                color2 = CssParseKt.parseHsl(trimmed);
            } else {
                throw (Throwable)new IllegalArgumentException("Invalid color: " + color);
            }
            return color2;
        }
        catch (NumberFormatException e) {
            String origMsg = e.getMessage();
            String msg = origMsg == null ? "Invalid color: " + color : (StringsKt.startsWith$default(origMsg, "For input string", false, 2, null) ? "Invalid number: " + StringsKt.drop(origMsg, "For input string: ".length()) : origMsg);
            throw (Throwable)new IllegalArgumentException(msg);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final HSL parseHsl(String color) {
        void vals;
        Pair<List<String>, Float> pair2 = CssParseKt.extractArgs(color, false);
        List<String> list = pair2.component1();
        float alpha = ((Number)pair2.component2()).floatValue();
        return new HSL(CssParseKt.parse$default((String)vals.get(0), false, false, true, 3, null), CssParseKt.parse$default((String)vals.get(1), false, true, false, 5, null), CssParseKt.parse$default((String)vals.get(2), false, true, false, 5, null), alpha);
    }

    /*
     * WARNING - void declaration
     */
    private static final RGB parseRgb(String color) {
        void vals;
        Pair<List<String>, Float> pair2 = CssParseKt.extractArgs(color, true);
        List<String> list = pair2.component1();
        float alpha = ((Number)pair2.component2()).floatValue();
        return new RGB(CssParseKt.parse$default((String)vals.get(0), true, false, false, 6, null), CssParseKt.parse$default((String)vals.get(1), true, false, false, 6, null), CssParseKt.parse$default((String)vals.get(2), true, false, false, 6, null), alpha);
    }

    /*
     * WARNING - void declaration
     */
    private static final Color parseHex(String hex) {
        Color color;
        switch (hex.length()) {
            case 4: 
            case 5: {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                CharSequence $this$map$iv = hex;
                boolean $i$f$map = false;
                CharSequence charSequence = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length());
                boolean $i$f$mapTo = false;
                void var6_6 = $this$mapTo$iv$iv;
                for (int i = 0; i < var6_6.length(); ++i) {
                    void it;
                    char item$iv$iv;
                    char c = item$iv$iv = var6_6.charAt(i);
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string = "" + (char)it + (char)it;
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                String string = StringsKt.drop(CollectionsKt.joinToString$default(collection, "", null, null, 0, null, null, 62, null), 1);
                color = new RGB(string);
                break;
            }
            default: {
                color = new RGB(hex);
            }
        }
        return color;
    }

    /*
     * Unable to fully structure code
     */
    private static final Pair<List<String>, Float> extractArgs(String color, boolean validatePercents) {
        v0 = CssParseKt.funcSyntax.matchEntire(color);
        if (v0 == null || (v0 = v0.getGroupValues()) == null) {
            throw (Throwable)new IllegalArgumentException("Invalid format: " + color);
        }
        groups = v0;
        vals = CollectionsKt.listOf(new String[]{(String)groups.get(1), (String)groups.get(3), (String)groups.get(5)});
        alphaVal = (String)groups.get(7);
        seps = CollectionsKt.listOf(new String[]{(String)groups.get(2), (String)groups.get(4), (String)groups.get(6)});
        $this$count$iv = seps;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v1 = 0;
        } else {
            count$iv = 0;
            var10_14 = $this$count$iv.iterator();
            while (var10_14.hasNext()) {
                element$iv = var10_14.next();
                it = (String)element$iv;
                $i$a$-count-CssParseKt$extractArgs$commaCount$1 = false;
                if (!StringsKt.contains$default((CharSequence)it, ',', false, 2, null)) continue;
                it = ++count$iv;
                $i$a$-count-CssParseKt$extractArgs$commaCount$1 = false;
                if (it >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v1 = commaCount = count$iv;
        }
        if (commaCount == 0 || commaCount == 3) ** GOTO lbl-1000
        if (commaCount == 2) {
            $this$count$iv = alphaVal;
            $i$f$count = false;
            ** if (!($this$count$iv.length() == 0)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v2 = true;
            ** GOTO lbl35
        }
lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
lbl35:
        // 2 sources

        $this$count$iv = v2;
        $i$f$count = false;
        count$iv = 0;
        if (!$this$count$iv) {
            $i$a$-require-CssParseKt$extractArgs$1 = false;
            count$iv = "Invalid format, separator mismatch: " + color;
            throw (Throwable)new IllegalArgumentException(count$iv.toString());
        }
        if (validatePercents) {
            $this$count$iv = vals;
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v3 = 0;
            } else {
                count$iv = 0;
                for (T element$iv : $this$count$iv) {
                    it = (String)element$iv;
                    $i$a$-count-CssParseKt$extractArgs$percentsCount$1 = false;
                    if (!StringsKt.endsWith$default((CharSequence)it, '%', false, 2, null)) continue;
                    var13_23 = ++count$iv;
                    var14_25 = false;
                    if (var13_23 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v3 = count$iv;
            }
            var8_9 = percentsCount = v3;
            if (1 <= var8_9 && 2 >= var8_9) {
                throw (Throwable)new IllegalArgumentException("Invalid format, percent and numbers can't be mixed: " + color);
            }
        }
        var8_11 = alphaVal;
        var9_12 = false;
        alpha = var8_11.length() == 0 != false ? 1.0f : CssParseKt.parse$default(alphaVal, false, false, false, 7, null);
        return TuplesKt.to(vals, Float.valueOf(alpha));
    }

    private static final float parse(String $this$parse, boolean divBy255, boolean requirePercent, boolean isAngle) {
        float f;
        Function1<Float, Float> $fun$normAngle$1 = new Function1<Float, Float>($this$parse, isAngle){
            final /* synthetic */ String $this_parse;
            final /* synthetic */ boolean $isAngle;

            public final float invoke(float deg) {
                boolean bl = this.$isAngle;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Invalid use of angle: " + this.$this_parse;
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                float fl = deg % (float)360;
                return fl < 0.0f ? fl + (float)360 : fl;
            }
            {
                this.$this_parse = string;
                this.$isAngle = bl;
                super(1);
            }
        };
        boolean bl = isAngle || !StringsKt.startsWith$default((CharSequence)$this$parse, '-', false, 2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid negative number: " + $this$parse;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = !requirePercent || StringsKt.endsWith$default((CharSequence)$this$parse, '%', false, 2, null);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Invalid percentage: " + $this$parse;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = !isAngle || !StringsKt.endsWith$default((CharSequence)$this$parse, '%', false, 2, null);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Invalid angle: " + $this$parse;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (StringsKt.endsWith$default($this$parse, "deg", false, 2, null)) {
            f = $fun$normAngle$1.invoke(CssParseKt.withoutUnit($this$parse, 3));
        } else if (StringsKt.endsWith$default($this$parse, "grad", false, 2, null)) {
            f = $fun$normAngle$1.invoke(CssParseKt.withoutUnit($this$parse, 4) * (float)9 / (float)10);
        } else if (StringsKt.endsWith$default($this$parse, "rad", false, 2, null)) {
            f = $fun$normAngle$1.invoke((float)((double)(CssParseKt.withoutUnit($this$parse, 3) * (float)180) / Math.PI));
        } else if (StringsKt.endsWith$default($this$parse, "turn", false, 2, null)) {
            f = $fun$normAngle$1.invoke(CssParseKt.withoutUnit($this$parse, 4) * (float)360);
        } else if (StringsKt.endsWith$default((CharSequence)$this$parse, '%', false, 2, null)) {
            f = CssParseKt.withoutUnit($this$parse, 1) / (float)100;
        } else if (isAngle) {
            String string = $this$parse;
            bl2 = false;
            f = $fun$normAngle$1.invoke(Float.parseFloat(string));
        } else if (divBy255) {
            String string = $this$parse;
            bl2 = false;
            f = Float.parseFloat(string) / (float)255;
        } else {
            String string = $this$parse;
            bl2 = false;
            f = Float.parseFloat(string);
        }
        return f;
    }

    static /* synthetic */ float parse$default(String string, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        return CssParseKt.parse(string, bl, bl2, bl3);
    }

    /*
     * Unable to fully structure code
     */
    private static final float withoutUnit(String $this$withoutUnit, int count) {
        num = StringsKt.dropLast($this$withoutUnit, count);
        v0 = StringsKt.lastOrNull(num);
        if (v0 == null) ** GOTO lbl-1000
        var3_3 = v0;
        var4_6 = false;
        var5_7 = false;
        it = var3_3.charValue();
        $i$a$-let-CssParseKt$withoutUnit$1 = false;
        var8_11 = it;
        if ('0' <= var8_11 && '9' >= var8_11) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        var3_4 = v1;
        var4_6 = false;
        var5_7 = false;
        if (!var3_4) {
            $i$a$-require-CssParseKt$withoutUnit$2 = false;
            var5_8 = "Invalid number: " + $this$withoutUnit;
            throw (Throwable)new IllegalArgumentException(var5_8.toString());
        }
        var3_5 = num;
        var4_6 = false;
        return Float.parseFloat(var3_5);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String group = "([^,)\\s]+)";
        String sep = "(\\s*,\\s*|\\s+)";
        String slashSep = "(\\s*,\\s*|\\s*\\/\\s*)";
        funcSyntax = new Regex("(?:rgb|hsl)a?\\(\\s*" + group + sep + group + sep + group + "(?:" + slashSep + group + ")?\\s*\\)");
    }
}

