/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.mordant.internal.AnsiRenderKt$WhenMappings;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.terminal.AnsiLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\bH\u0000\u001a,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\u00a8\u0006\u001a"}, d2={"downsample", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "style", "level", "Lcom/github/ajalt/mordant/terminal/AnsiLevel;", "hyperlinks", "", "makeHyperlinkTag", "", "hyperlink", "hyperlinkId", "makeTag", "old", "new", "renderLinesAnsi", "lines", "Lcom/github/ajalt/mordant/rendering/Lines;", "invokeStyle", "text", "toAnsi", "", "", "Lcom/github/ajalt/colormath/Color;", "select", "reset", "offset", "mordant"})
public final class AnsiRenderKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderLinesAnsi(@NotNull Lines lines, @NotNull AnsiLevel level, boolean hyperlinks) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter((Object)level, "level");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        boolean bl6 = false;
        for (List line : (Iterable)lines.getLines()) {
            void i;
            if (i > 0) {
                $this$buildString.append("\n");
            }
            TextStyle activeStyle = TextStyleKt.getDEFAULT_STYLE();
            for (Span span : line) {
                TextStyle newStyle = AnsiRenderKt.downsample(span.getStyle(), level, hyperlinks);
                $this$buildString.append(AnsiRenderKt.makeTag(activeStyle, newStyle));
                activeStyle = newStyle;
                $this$buildString.append(span.getText());
            }
            $this$buildString.append(AnsiRenderKt.makeTag(activeStyle, TextStyleKt.getDEFAULT_STYLE()));
            ++i;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String invokeStyle(@NotNull TextStyle $this$invokeStyle, @NotNull String text) {
        void openStyle;
        void style;
        Intrinsics.checkNotNullParameter($this$invokeStyle, "$this$invokeStyle");
        Intrinsics.checkNotNullParameter(text, "text");
        Object object = text;
        boolean bl = false;
        if (object.length() == 0) {
            return "";
        }
        object = new Ref.ObjectRef();
        ((Ref.ObjectRef)object).element = $this$invokeStyle;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = $this$invokeStyle;
        String inner2 = ParsingKt.getANSI_RE().replace((CharSequence)text, (Function1<? super MatchResult, ? extends CharSequence>)new Function1<MatchResult, CharSequence>($this$invokeStyle, text, (Ref.ObjectRef)style, (Ref.ObjectRef)openStyle){
            final /* synthetic */ TextStyle $this_invokeStyle;
            final /* synthetic */ String $text;
            final /* synthetic */ Ref.ObjectRef $style;
            final /* synthetic */ Ref.ObjectRef $openStyle;

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult match) {
                Intrinsics.checkNotNullParameter(match, "match");
                if (match.getRange().getLast() == StringsKt.getLastIndex(this.$text)) {
                    return "";
                }
                TextStyle textStyle = ParsingKt.updateStyle((TextStyle)this.$style.element, this.$this_invokeStyle, match.getValue());
                if (match.getRange().getFirst() == 0) {
                    this.$openStyle.element = textStyle;
                    this.$style.element = textStyle;
                    return "";
                }
                String tag = AnsiRenderKt.access$makeTag((TextStyle)this.$style.element, textStyle);
                this.$style.element = textStyle;
                return tag;
            }
            {
                this.$this_invokeStyle = textStyle;
                this.$text = string;
                this.$style = objectRef;
                this.$openStyle = objectRef2;
                super(1);
            }
        });
        return AnsiRenderKt.makeTag(TextStyleKt.getDEFAULT_STYLE(), (TextStyle)openStyle.element) + inner2 + AnsiRenderKt.makeTag((TextStyle)style.element, TextStyleKt.getDEFAULT_STYLE());
    }

    private static final TextStyle downsample(TextStyle style, AnsiLevel level, boolean hyperlinks) {
        TextStyle textStyle;
        if (style == TextStyleKt.getDEFAULT_STYLE()) {
            textStyle = style;
        } else {
            switch (AnsiRenderKt$WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    textStyle = TextStyleKt.getDEFAULT_STYLE();
                    break;
                }
                case 2: {
                    Color color = style.getColor();
                    Color color2 = style.getBgColor();
                    String string = style.getHyperlink();
                    boolean bl = false;
                    boolean bl2 = false;
                    String string2 = string;
                    Color color3 = color2 != null ? color2.toAnsi16() : null;
                    Color color4 = color != null ? color.toAnsi16() : null;
                    TextStyle textStyle2 = style;
                    boolean bl3 = false;
                    boolean bl4 = hyperlinks;
                    String string3 = bl4 ? string : null;
                    string = style.getHyperlinkId();
                    bl = false;
                    bl2 = false;
                    String it = string;
                    String string4 = string3;
                    boolean bl5 = false;
                    boolean bl6 = hyperlinks;
                    textStyle = TextStyleKt.copy(textStyle2, color4, color3, string4, bl6 ? string : null);
                    break;
                }
                case 3: {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    TextStyle textStyle3;
                    Object it;
                    boolean bl;
                    boolean bl7;
                    Object object5;
                    TextStyle textStyle4 = style;
                    Color color = style.getColor();
                    if (color != null) {
                        object5 = color;
                        bl7 = false;
                        bl = false;
                        it = object5;
                        textStyle3 = textStyle4;
                        boolean bl8 = false;
                        object4 = it instanceof Ansi16 ? it : (Color)it.toAnsi256();
                        textStyle4 = textStyle3;
                        object3 = object4;
                    } else {
                        object3 = null;
                    }
                    Color color5 = style.getBgColor();
                    if (color5 != null) {
                        object5 = color5;
                        bl7 = false;
                        bl = false;
                        it = object5;
                        object4 = object3;
                        textStyle3 = textStyle4;
                        boolean bl9 = false;
                        object2 = it instanceof Ansi16 ? it : (Color)it.toAnsi256();
                        textStyle4 = textStyle3;
                        object3 = object4;
                        object = object2;
                    } else {
                        object = null;
                    }
                    object5 = style.getHyperlink();
                    bl7 = false;
                    bl = false;
                    it = object5;
                    object2 = object;
                    object4 = object3;
                    textStyle3 = textStyle4;
                    boolean bl10 = false;
                    boolean bl11 = hyperlinks;
                    Object object6 = bl11 ? object5 : null;
                    object5 = style.getHyperlinkId();
                    bl7 = false;
                    bl = false;
                    it = object5;
                    Object object7 = object6;
                    boolean bl12 = false;
                    boolean bl13 = hyperlinks;
                    textStyle = TextStyleKt.copy(textStyle3, (Color)object4, (Color)object2, (String)object7, (String)(bl13 ? object5 : null));
                    break;
                }
                case 4: {
                    if (hyperlinks || style.getHyperlink() == null) {
                        textStyle = style;
                        break;
                    }
                    textStyle = TextStyleKt.copy(style, style.getColor(), style.getBgColor(), null, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return textStyle;
    }

    private static final String makeTag(TextStyle old, TextStyle textStyle) {
        boolean bl;
        Iterable iterable;
        if (Intrinsics.areEqual(old, textStyle)) {
            return "";
        }
        boolean bl2 = false;
        List codes = new ArrayList();
        if (Intrinsics.areEqual(old.getColor(), textStyle.getColor()) ^ true) {
            Collection collection = codes;
            iterable = AnsiRenderKt.toAnsi(textStyle.getColor(), 38, 39, 0);
            bl = false;
            CollectionsKt.addAll(collection, iterable);
        }
        if (Intrinsics.areEqual(old.getBgColor(), textStyle.getBgColor()) ^ true) {
            Collection collection = codes;
            iterable = AnsiRenderKt.toAnsi(textStyle.getBgColor(), 48, 49, 10);
            bl = false;
            CollectionsKt.addAll(collection, iterable);
        }
        Function4<Boolean, Boolean, Integer, Integer, Unit> $fun$style$1 = new Function4<Boolean, Boolean, Integer, Integer, Unit>(codes){
            final /* synthetic */ List $codes;

            public final void invoke(boolean old, boolean bl, int open, int close) {
                if (old != bl) {
                    Collection collection = this.$codes;
                    Integer n = bl ? open : close;
                    boolean bl2 = false;
                    collection.add(n);
                }
            }
            {
                this.$codes = list;
                super(4);
            }
        };
        $fun$style$1.invoke(old.getBold(), textStyle.getBold(), 1, 22);
        $fun$style$1.invoke(old.getItalic(), textStyle.getItalic(), 3, 23);
        $fun$style$1.invoke(old.getUnderline(), textStyle.getUnderline(), 4, 24);
        $fun$style$1.invoke(old.getDim(), textStyle.getDim(), 2, 22);
        $fun$style$1.invoke(old.getInverse(), textStyle.getInverse(), 7, 27);
        $fun$style$1.invoke(old.getStrikethrough(), textStyle.getStrikethrough(), 9, 29);
        String csi = codes.isEmpty() ? "" : CollectionsKt.joinToString$default(codes, ";", "\u001b[", "m", 0, null, null, 56, null);
        return Intrinsics.areEqual(old.getHyperlink(), textStyle.getHyperlink()) ^ true ? csi + AnsiRenderKt.makeHyperlinkTag(textStyle.getHyperlink(), textStyle.getHyperlinkId()) : csi;
    }

    private static final String makeHyperlinkTag(String hyperlink, String hyperlinkId) {
        String string;
        block5: {
            block4: {
                if (hyperlink == null) {
                    return "\u001b]8;;\u001b\\";
                }
                string = hyperlinkId;
                if (string == null) break block4;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                string = "id=" + it;
                if (string != null) break block5;
            }
            string = "";
        }
        String id = string;
        return "\u001b]8;" + id + ';' + hyperlink + "\u001b\\";
    }

    private static final List<Integer> toAnsi(Color $this$toAnsi, int select, int reset, int offset) {
        List<Integer> list;
        Object it;
        Object object;
        Color color = $this$toAnsi;
        if (!(color instanceof TextStyle)) {
            color = null;
        }
        if ((object = (TextStyle)((Object)color)) == null || (object = object.getColor()) == null) {
            object = it = $this$toAnsi;
        }
        if (it == null) {
            list = CollectionsKt.listOf(reset);
        } else if (it instanceof Ansi16) {
            list = CollectionsKt.listOf(((Ansi16)it).getCode() + offset);
        } else if (it instanceof Ansi256) {
            list = CollectionsKt.listOf(select, 5, ((Ansi256)it).getCode());
        } else {
            RGB rGB = it.toRGB();
            boolean bl = false;
            boolean bl2 = false;
            RGB $this$run = rGB;
            boolean bl3 = false;
            list = CollectionsKt.listOf(select, 2, $this$run.getR(), $this$run.getG(), $this$run.getB());
        }
        return list;
    }

    public static final /* synthetic */ String access$makeTag(TextStyle old, TextStyle textStyle) {
        return AnsiRenderKt.makeTag(old, textStyle);
    }
}

