/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.text.ParseException;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.data.gpx.GpxTimezone;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmDecimalFormatSymbolsProvider;
import org.openstreetmap.josm.tools.Pair;

public final class GpxTimeOffset {
    public static final GpxTimeOffset ZERO = new GpxTimeOffset(0L);
    private final long milliseconds;

    private GpxTimeOffset(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public static GpxTimeOffset milliseconds(long milliseconds) {
        return new GpxTimeOffset(milliseconds);
    }

    public static GpxTimeOffset seconds(long seconds) {
        return new GpxTimeOffset(1000L * seconds);
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public long getSeconds() {
        return this.milliseconds / 1000L;
    }

    public String formatOffset() {
        if (this.milliseconds % 1000L == 0L) {
            return Long.toString(this.milliseconds / 1000L);
        }
        if (this.milliseconds % 100L == 0L) {
            return String.format(Locale.ENGLISH, "%.1f", (double)this.milliseconds / 1000.0);
        }
        return String.format(Locale.ENGLISH, "%.3f", (double)this.milliseconds / 1000.0);
    }

    public static GpxTimeOffset parseOffset(String offset) throws ParseException {
        String error = I18n.tr("Error while parsing offset.\nExpected format: {0}", "number");
        if (!offset.isEmpty()) {
            try {
                if (offset.startsWith("+")) {
                    offset = offset.substring(1);
                }
                return GpxTimeOffset.milliseconds(Math.round(JosmDecimalFormatSymbolsProvider.parseDouble(offset) * 1000.0));
            }
            catch (NumberFormatException nfe) {
                throw (ParseException)new ParseException(error, 0).initCause(nfe);
            }
        }
        return ZERO;
    }

    public int getDayOffset() {
        return (int)Math.round((double)this.getMilliseconds() / (double)TimeUnit.DAYS.toMillis(1L));
    }

    public GpxTimeOffset withoutDayOffset() {
        return GpxTimeOffset.milliseconds(this.getMilliseconds() - TimeUnit.DAYS.toMillis(this.getDayOffset()));
    }

    public Pair<GpxTimezone, GpxTimeOffset> splitOutTimezone() {
        double tz = (double)this.withoutDayOffset().getSeconds() / (double)TimeUnit.HOURS.toSeconds(1L);
        double timezone = (double)Math.round(tz * 2.0) / 2.0;
        long delta = Math.round((double)this.getMilliseconds() - timezone * (double)TimeUnit.HOURS.toMillis(1L));
        return Pair.create(new GpxTimezone(timezone), GpxTimeOffset.milliseconds(delta));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GpxTimeOffset)) {
            return false;
        }
        GpxTimeOffset offset = (GpxTimeOffset)o;
        return this.milliseconds == offset.milliseconds;
    }

    public int hashCode() {
        return Objects.hash(this.milliseconds);
    }
}

