/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.IOFunction;

public interface SolrCache<K, V>
extends SolrInfoBean,
SolrMetricProducer {
    public static final String HIT_RATIO_PARAM = "hitratio";
    public static final String HITS_PARAM = "hits";
    public static final String INSERTS_PARAM = "inserts";
    public static final String EVICTIONS_PARAM = "evictions";
    public static final String LOOKUPS_PARAM = "lookups";
    public static final String SIZE_PARAM = "size";
    public static final String MAX_SIZE_PARAM = "maxSize";
    public static final String RAM_BYTES_USED_PARAM = "ramBytesUsed";
    public static final String MAX_RAM_MB_PARAM = "maxRamMB";
    public static final String MAX_IDLE_TIME_PARAM = "maxIdleTime";
    public static final String INITIAL_SIZE_PARAM = "initialSize";
    public static final String CLEANUP_THREAD_PARAM = "cleanupThread";
    public static final String SHOW_ITEMS_PARAM = "showItems";
    public static final String ASYNC_PARAM = "async";

    public Object init(Map var1, Object var2, CacheRegenerator var3);

    public String name();

    public int size();

    public V put(K var1, V var2);

    public V get(K var1);

    public V remove(K var1);

    public V computeIfAbsent(K var1, IOFunction<? super K, ? extends V> var2) throws IOException;

    public void clear();

    public void setState(State var1);

    public State getState();

    public void warm(SolrIndexSearcher var1, SolrCache<K, V> var2);

    @Override
    default public void close() throws IOException {
        SolrMetricProducer.super.close();
    }

    public int getMaxSize();

    public void setMaxSize(int var1);

    public int getMaxRamMB();

    public void setMaxRamMB(int var1);

    default public boolean isRecursionSupported() {
        return false;
    }

    public static enum State {
        CREATED,
        STATICWARMING,
        AUTOWARMING,
        LIVE;

    }
}

