/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.GotoStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.HashMap;
import java.util.HashSet;

public class ExceptionHandlerCurrectTransformer
implements Transformer {
    @Override
    public void transform(IrMethod irMethod) {
        if (irMethod.traps.size() == 0) {
            return;
        }
        Local ex = null;
        HashSet<LabelStmt> handlers = new HashSet<LabelStmt>();
        HashMap<LabelStmt, LabelStmt> newLocations = new HashMap<LabelStmt, LabelStmt>();
        for (Trap t : irMethod.traps) {
            int i = 0;
            while (i < t.handlers.length) {
                LabelStmt handler = t.handlers[i];
                Stmt st = handler.getNext();
                while (st.st == Stmt.ST.LABEL) {
                    st = st.getNext();
                }
                LabelStmt x = (LabelStmt)st.getPre();
                if (this.needInsertMoveExceptionRef(st)) {
                    LabelStmt newHandler = (LabelStmt)newLocations.get(x);
                    if (newHandler == null) {
                        if (ex == null) {
                            ex = Exprs.nLocal("unRefEx");
                        }
                        newHandler = Stmts.nLabel();
                        GotoStmt g = Stmts.nGoto(x);
                        irMethod.stmts.add(newHandler);
                        irMethod.stmts.add(Stmts.nIdentity(ex, Exprs.nExceptionRef("Ljava/lang/Throwable;")));
                        irMethod.stmts.add(g);
                        newLocations.put(x, newHandler);
                    }
                    t.handlers[i] = newHandler;
                } else if (x != handler) {
                    t.handlers[i] = x;
                }
                handlers.add(t.handlers[i]);
                ++i;
            }
        }
        newLocations.clear();
        if (ex != null) {
            irMethod.locals.add(ex);
        }
    }

    private boolean needInsertMoveExceptionRef(Stmt st) {
        return st.st != Stmt.ST.IDENTITY || st.getOp2().vt != Value.VT.EXCEPTION_REF;
    }
}

