"""Generated message classes for marketplacesolutions version v1alpha1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'marketplacesolutions'


class AzureIP(_messages.Message):
  r"""An AzureIP.

  Enums:
    TypeValueValuesEnum: Type of the IP.
    VersionValueValuesEnum: IP protocol version.

  Fields:
    address: The ip address for this ip.
    primary: The category of this ip, can be `primary` or `secondary`.
    type: Type of the IP.
    version: IP protocol version.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of the IP.

    Values:
      IPTYPE_UNSPECIFIED: The type of this ip is unknown.
      PRIVATE: The ip is a private ip address.
      PUBLIC: The ip is a public ip address.
    """
    IPTYPE_UNSPECIFIED = 0
    PRIVATE = 1
    PUBLIC = 2

  class VersionValueValuesEnum(_messages.Enum):
    r"""IP protocol version.

    Values:
      IPVERSION_UNSPECIFIED: The version of this ip is unknown.
      IPV4: The ip is a IPv4 address.
      IPV6: The ip is a IPv6 address.
    """
    IPVERSION_UNSPECIFIED = 0
    IPV4 = 1
    IPV6 = 2

  address = _messages.StringField(1)
  primary = _messages.BooleanField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)
  version = _messages.EnumField('VersionValueValuesEnum', 4)


class AzureInstance(_messages.Message):
  r"""An Azure server.

  Enums:
    StatusValueValuesEnum: The status of the server.

  Fields:
    machineType: The server type.
    name: Output only. The resource name of this AzureInstance. Resource names
      are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/azureInstances/{instance}`
    networks: List of networks associated with this server.
    osImage: The OS image currently installed on the server.
    status: The status of the server.
    uid: Output only. An unique identifier generated for the AzureInstance
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""The status of the server.

    Values:
      STATUS_UNSPECIFIED: The status of the server is unknown.
      CREATING: The server is CREATING.
      STARTING: The server is STARTING.
      RUNNING: The server is RUNNING.
      STOPPING: The server is STOPPING.
      STOPPED: The server is STOPPED.
      DEALLOCATING: The server is DEALLOCATING.
      DEALLOCATED: The server is DEALLOCATED.
    """
    STATUS_UNSPECIFIED = 0
    CREATING = 1
    STARTING = 2
    RUNNING = 3
    STOPPING = 4
    STOPPED = 5
    DEALLOCATING = 6
    DEALLOCATED = 7

  machineType = _messages.StringField(1)
  name = _messages.StringField(2)
  networks = _messages.MessageField('AzureNetwork', 3, repeated=True)
  osImage = _messages.StringField(4)
  status = _messages.EnumField('StatusValueValuesEnum', 5)
  uid = _messages.StringField(6)


class AzureNetwork(_messages.Message):
  r"""A AzureNetwork.

  Fields:
    ips: List of AzureIPs attached to this network.
    macAddress: A physical interface for this AzureNetwork.
    name: Output only. The resource name of this AzureNetwork. Resource names
      are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/azureNetworks/{network}`
    uid: Output only. An unique identifier for this AzureNetwork, generated by
      the backend.
  """

  ips = _messages.MessageField('AzureIP', 1, repeated=True)
  macAddress = _messages.StringField(2)
  name = _messages.StringField(3)
  uid = _messages.StringField(4)


class BareMetalInstance(_messages.Message):
  r"""A Bare Metal Server.

  Enums:
    StateValueValuesEnum: The status of the server.

  Messages:
    LabelsValue: Labels as key value pairs.

  Fields:
    ipAddress: IP address of the server
    labels: Labels as key value pairs.
    machineType: The server type.
    name: Output only. The resource name of this BareMetalInstance. Format:
      `projects/{project}/locations/{location}/bareMetalInstances/{instance}`
    osImage: The OS image currently installed on the server.
    state: The status of the server.
    uid: Output only. An unique identifier generated for the BareMetalInstance
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The status of the server.

    Values:
      STATE_UNSPECIFIED: The server is in an unknown state.
      PROVISIONING: The server is being provisioned.
      RUNNING: The server is running.
      DELETED: The server has been deleted.
      UPDATING: The server is being updated.
      STARTING: The server is starting.
      STOPPING: The server is stopping.
      SHUTDOWN: The server is shutdown.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    DELETED = 3
    UPDATING = 4
    STARTING = 5
    STOPPING = 6
    SHUTDOWN = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  ipAddress = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  machineType = _messages.StringField(3)
  name = _messages.StringField(4)
  osImage = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  uid = _messages.StringField(7)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class ConvergeIP(_messages.Message):
  r"""A ConvergeIP.

  Enums:
    TypeValueValuesEnum: Type of the IP.
    VersionValueValuesEnum: IP protocol version.

  Fields:
    address: The ip address for this ip.
    type: Type of the IP.
    version: IP protocol version.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of the IP.

    Values:
      IPTYPE_UNSPECIFIED: The type of this ip is unknown.
      FIXED: The ip address is fixed.
      DYNAMIC: The ip address is dynamic.
    """
    IPTYPE_UNSPECIFIED = 0
    FIXED = 1
    DYNAMIC = 2

  class VersionValueValuesEnum(_messages.Enum):
    r"""IP protocol version.

    Values:
      IPVERSION_UNSPECIFIED: The version of this ip is unknown.
      IPV4: The ip is an IPv4 address.
      IPV6: The ip is an IPv6 address.
    """
    IPVERSION_UNSPECIFIED = 0
    IPV4 = 1
    IPV6 = 2

  address = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)
  version = _messages.EnumField('VersionValueValuesEnum', 3)


class ConvergeIPAddressRanges(_messages.Message):
  r"""A ConvergeIPAddress Range

  Fields:
    endingIpAddress: The ending IP address of the network in IPv4 format.
    startingIpAddress: The starting IP address of the network in IPv4 format.
  """

  endingIpAddress = _messages.StringField(1)
  startingIpAddress = _messages.StringField(2)


class ConvergeImage(_messages.Message):
  r"""This is the description of a ConvergeImage.

  Enums:
    ImageTypeValueValuesEnum: The image type of this ConvergeImage.
    StateValueValuesEnum: The status of the server.

  Fields:
    imageType: The image type of this ConvergeImage.
    name: Output only. The resource name of this ConvergeImage. Resource names
      are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/convergeImages/{image}`
    operatingSystem: The operating system type of this ConvergeImage.
    state: The status of the server.
    uid: Output only. An unique identifier for this ConvergeImage, generated
      by the backend.
    virtualMachines: List of virtual machines associated with image
    volumes: List of volumes for the image
  """

  class ImageTypeValueValuesEnum(_messages.Enum):
    r"""The image type of this ConvergeImage.

    Values:
      IMAGE_TYPE_UNSPECIFIED: The type of image is not specified
      STOCK: The image is a stock image.
      IMPORT: The image is an imported image.
      SNAPSHOT: The image is a snapshot image.
      CAPTURE: The image is a captured image.
    """
    IMAGE_TYPE_UNSPECIFIED = 0
    STOCK = 1
    IMPORT = 2
    SNAPSHOT = 3
    CAPTURE = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""The status of the server.

    Values:
      STATE_UNSPECIFIED: The state is not specified.
      QUEUED: The image identifier has been reserved for an image, no image
        data has been uploaded yet.
      SAVING: Denotes that an image's raw data is currently being uploaded.
      UPLOADING: Denotes that an import data-put call has been made.
      IMPORTING: Denotes that an import call has been made but that the image
        is not yet ready for use.
      ACTIVE: Denotes an image that is fully available.
      DEACTIVATED: Denotes that access to image data is not allowed to any
        non-admin user.
      KILLED: Denotes that an error occurred during the uploading of an
        image's data, and that the image is not readable.
      DELETED: Image is no longer available to use. An image in this state
        will be removed automatically at a later date.
      PENDING_DELETE: This is similar to deleted, however, image data has not
        been removed. An image in this state is not recoverable.
    """
    STATE_UNSPECIFIED = 0
    QUEUED = 1
    SAVING = 2
    UPLOADING = 3
    IMPORTING = 4
    ACTIVE = 5
    DEACTIVATED = 6
    KILLED = 7
    DELETED = 8
    PENDING_DELETE = 9

  imageType = _messages.EnumField('ImageTypeValueValuesEnum', 1)
  name = _messages.StringField(2)
  operatingSystem = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  uid = _messages.StringField(5)
  virtualMachines = _messages.StringField(6, repeated=True)
  volumes = _messages.MessageField('ConvergeVolume', 7, repeated=True)


class ConvergeInstance(_messages.Message):
  r"""A Converge server.

  Enums:
    StatusValueValuesEnum: The status of the server.

  Fields:
    addresses: List of addresses associated with this server, corresponds to
      `addresses` field from Converge's API.
    createTime: Output only. Instance creation time
    machineType: The server type.
    name: Output only. The resource name of this ConvergeInstance. Resource
      names are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/convergeInstances/{instance}`
    networks: List of networks associated with this server, corresponds to
      `networks` field from Converge's API.
    osImage: The OS image currently installed on the server.
    status: The status of the server.
    uid: Output only. An unique identifier generated for the ConvergeInstance.
    volumes: List of volumes associated with this server, retrieved by calling
      ListVolumes API.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""The status of the server.

    Values:
      STATUS_UNSPECIFIED: The status of the server is unknown.
      ACTIVE: The server is ACTIVE.
      SHUTOFF: The server has been SHUTOFF.
      INACTIVE: The server is INACTIVE.
      TIMEOUT: The server is TIMEOUT.
      BUILD: The server is BUILDing.
      REBOOT: The server is REBOOTing.
      WARNING: The server is in WARNING status.
      ERROR: The server has ERROR.
      RESIZE: The server is resizing.
      VERIFY_RESIZE: The server is verifying resize.
    """
    STATUS_UNSPECIFIED = 0
    ACTIVE = 1
    SHUTOFF = 2
    INACTIVE = 3
    TIMEOUT = 4
    BUILD = 5
    REBOOT = 6
    WARNING = 7
    ERROR = 8
    RESIZE = 9
    VERIFY_RESIZE = 10

  addresses = _messages.MessageField('ConvergeNetwork', 1, repeated=True)
  createTime = _messages.StringField(2)
  machineType = _messages.StringField(3)
  name = _messages.StringField(4)
  networks = _messages.MessageField('ConvergeNetwork', 5, repeated=True)
  osImage = _messages.StringField(6)
  status = _messages.EnumField('StatusValueValuesEnum', 7)
  uid = _messages.StringField(8)
  volumes = _messages.MessageField('ConvergeVolume', 9, repeated=True)


class ConvergeNetwork(_messages.Message):
  r"""A ConvergeNetwork.

  Enums:
    TypeValueValuesEnum: Type of the vlan.

  Fields:
    cidr: The cidr of the network.
    dnsServers: List of DNS servers for network
    gateway: The gateway of the network.
    ipAddressRanges: List of IP address ranges for the network
    ips: List of ConvergeIPs attached to this network.
    jumboFramesEnabled: Whether jumbo frames are enabled.
    macAddress: A physical interface for this ConvergeNetwork.
    name: Output only. The resource name of this ConvergeNetwork. Resource
      names are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/convergeNetworks/{network}`
    type: Type of the vlan.
    uid: Output only. An unique identifier for this ConvergeNetwork, generated
      by the backend.
    vlanId: The vlan id of the network.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of the vlan.

    Values:
      TYPE_UNSPECIFIED: Value is not specified.
      VLAN: The type of the network is VLAN.
    """
    TYPE_UNSPECIFIED = 0
    VLAN = 1

  cidr = _messages.StringField(1)
  dnsServers = _messages.StringField(2, repeated=True)
  gateway = _messages.StringField(3)
  ipAddressRanges = _messages.MessageField('ConvergeIPAddressRanges', 4, repeated=True)
  ips = _messages.MessageField('ConvergeIP', 5, repeated=True)
  jumboFramesEnabled = _messages.BooleanField(6)
  macAddress = _messages.StringField(7)
  name = _messages.StringField(8)
  type = _messages.EnumField('TypeValueValuesEnum', 9)
  uid = _messages.StringField(10)
  vlanId = _messages.IntegerField(11, variant=_messages.Variant.UINT64)


class ConvergeSSHKey(_messages.Message):
  r"""A ConvergeSSHKey.

  Fields:
    createTime: Output only. SSH Key creation time
    name: Output only. The resource name of this ConvergeSSHKey. Resource
      names are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      'projects/{project}/locations/{location}/convergeSshKey/{ssh_key}'
    sshKey: SSH Key value.
    uid: Output only. An unique identifier for this SSHKey, generated by the
      backend.
  """

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  sshKey = _messages.StringField(3)
  uid = _messages.StringField(4)


class ConvergeVolume(_messages.Message):
  r"""A ConvergeVolume.

  Enums:
    StateValueValuesEnum: The state of the volume.

  Fields:
    bootVolume: An option indicates whether the volume is the server's boot
      volume.
    bootable: An option indicates whether the volume is bootable.
    groupId: The group id this volume attached to.
    name: Output only. The resource name of this ConvergeVolume. Resource
      names are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/convergeVolumes/{volume}`
    shareable: An option indicates whether the volume is shareable.
    size: The size of the volume.
    state: The state of the volume.
    type: The disk type of the volume. //
    uid: Output only. An unique identifier for this ConvergeVolume, generated
      by the backend.
    volumeId: The volume id this volume attached to.
    wwn: The world wide name for the volume.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the volume.

    Values:
      STATE_UNSPECIFIED: The state of this volume is unknown.
      CREATING: The volume is being created.
      AVAILABLE: The volume is ready to attach to an instance.
      RESERVED: The volume is reserved for attaching or shelved.
      ATTACHING: The volume is attaching to an instance.
      DETACHING: The volume is detaching from an instance.
      IN_USE: The volume is attached to an instance.
      MAINTENANCE: The volume is locked and being migrated.
      DELETING: The volume is being deleted.
      AWAITING_TRANSFER: The volume is awaiting for transfer.
      ERROR: A volume creation error occurred.
      ERROR_DELETING: A volume deletion error occurred.
      BACKING_UP: The volume is being backed up.
      RESTORING_BACKUP: A backup is being restored to the volume.
      ERROR_BACKING_UP: A backup error occurred.
      ERROR_RESTORING: A backup restoration error occurred.
      ERROR_EXTENDING: An error occurred while attempting to extend a volume.
      DOWNLOADING: The volume is downloading an image.
      UPLOADING: The volume is being uploaded to an image.
      RETYPING: The volume is changing type to another volume type.
      EXTENDING: The volume is being extended.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    AVAILABLE = 2
    RESERVED = 3
    ATTACHING = 4
    DETACHING = 5
    IN_USE = 6
    MAINTENANCE = 7
    DELETING = 8
    AWAITING_TRANSFER = 9
    ERROR = 10
    ERROR_DELETING = 11
    BACKING_UP = 12
    RESTORING_BACKUP = 13
    ERROR_BACKING_UP = 14
    ERROR_RESTORING = 15
    ERROR_EXTENDING = 16
    DOWNLOADING = 17
    UPLOADING = 18
    RETYPING = 19
    EXTENDING = 20

  bootVolume = _messages.BooleanField(1)
  bootable = _messages.BooleanField(2)
  groupId = _messages.StringField(3)
  name = _messages.StringField(4)
  shareable = _messages.BooleanField(5)
  size = _messages.IntegerField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  type = _messages.StringField(8)
  uid = _messages.StringField(9)
  volumeId = _messages.StringField(10)
  wwn = _messages.StringField(11)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Fake(_messages.Message):
  r"""Message describing Fake object

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Labels as key value pairs
    name: name of resource
    updateTime: Output only. [Output only] Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class ListAzureInstancesResponse(_messages.Message):
  r"""Response message for the list of Azure servers.

  Fields:
    azureInstances: The list of Azure servers.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  azureInstances = _messages.MessageField('AzureInstance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListBareMetalInstancesResponse(_messages.Message):
  r"""Response message for the list of Bare Metal Servers.

  Fields:
    bareMetalInstances: The list of bare metal servers.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  bareMetalInstances = _messages.MessageField('BareMetalInstance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListConvergeImagesResponse(_messages.Message):
  r"""Response message containing the list of Converge images.

  Fields:
    convergeImages: The list of images.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  convergeImages = _messages.MessageField('ConvergeImage', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListConvergeInstancesResponse(_messages.Message):
  r"""Response message for the list of Converge servers.

  Fields:
    convergeInstances: The list of Converge servers.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  convergeInstances = _messages.MessageField('ConvergeInstance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListConvergeNetworksResponse(_messages.Message):
  r"""Response message containing the list of Converge networks.

  Fields:
    convergeNetworks: The list of networks.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  convergeNetworks = _messages.MessageField('ConvergeNetwork', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListConvergeSSHKeysResponse(_messages.Message):
  r"""Response message containing the list of Converge SSH Keys.

  Fields:
    convergeSshKeys: The list of SSH Keys.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  convergeSshKeys = _messages.MessageField('ConvergeSSHKey', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListConvergeVolumesResponse(_messages.Message):
  r"""Response message containing the list of Converge volumes.

  Fields:
    convergeVolumes: The list of volumes.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  convergeVolumes = _messages.MessageField('ConvergeVolume', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListFakesResponse(_messages.Message):
  r"""Message for response to listing Fakes

  Fields:
    fakes: The list of Fake
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  fakes = _messages.MessageField('Fake', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListNetappVolumesResponse(_messages.Message):
  r"""Response message containing the list of Netapp volumes.

  Fields:
    netappVolumes: The list of volumes.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  netappVolumes = _messages.MessageField('NetappVolume', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class MarketplacesolutionsProjectsLocationsAzureInstancesGetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsAzureInstancesGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsAzureInstancesListRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsAzureInstancesListRequest object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, the server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent of the resource.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MarketplacesolutionsProjectsLocationsBareMetalInstancesCreateRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsBareMetalInstancesCreateRequest
  object.

  Fields:
    bareMetalInstance: A BareMetalInstance resource to be passed as the
      request body.
    parent: Required. The parent project and location.
  """

  bareMetalInstance = _messages.MessageField('BareMetalInstance', 1)
  parent = _messages.StringField(2, required=True)


class MarketplacesolutionsProjectsLocationsBareMetalInstancesGetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsBareMetalInstancesGetRequest
  object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsBareMetalInstancesListRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsBareMetalInstancesListRequest
  object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, the server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent of the resource.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MarketplacesolutionsProjectsLocationsBareMetalInstancesResetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsBareMetalInstancesResetRequest
  object.

  Fields:
    name: Required. Name of the resource.
    resetBareMetalInstanceRequest: A ResetBareMetalInstanceRequest resource to
      be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  resetBareMetalInstanceRequest = _messages.MessageField('ResetBareMetalInstanceRequest', 2)


class MarketplacesolutionsProjectsLocationsConvergeImagesGetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsConvergeImagesGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsConvergeImagesListRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsConvergeImagesListRequest object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListConvergeImagesRequest.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MarketplacesolutionsProjectsLocationsConvergeInstancesGetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsConvergeInstancesGetRequest
  object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsConvergeInstancesListRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsConvergeInstancesListRequest
  object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, the server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent of the resource.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MarketplacesolutionsProjectsLocationsConvergeNetworksGetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsConvergeNetworksGetRequest
  object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsConvergeNetworksListRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsConvergeNetworksListRequest
  object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListConvergeNetworksRequest.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MarketplacesolutionsProjectsLocationsConvergeSshKeysGetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsConvergeSshKeysGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsConvergeSshKeysListRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsConvergeSshKeysListRequest
  object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListConvergeSSHKeysRequest.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MarketplacesolutionsProjectsLocationsConvergeVolumesGetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsConvergeVolumesGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsConvergeVolumesListRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsConvergeVolumesListRequest
  object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListConvergeVolumesRequest.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MarketplacesolutionsProjectsLocationsFakesCreateRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsFakesCreateRequest object.

  Fields:
    fake: A Fake resource to be passed as the request body.
    fakeId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and fake_id from the method_signature of
      Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  fake = _messages.MessageField('Fake', 1)
  fakeId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class MarketplacesolutionsProjectsLocationsFakesDeleteRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsFakesDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class MarketplacesolutionsProjectsLocationsFakesGetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsFakesGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsFakesListRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsFakesListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListFakesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class MarketplacesolutionsProjectsLocationsFakesPatchRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsFakesPatchRequest object.

  Fields:
    fake: A Fake resource to be passed as the request body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Fake resource by the update. The fields specified in
      the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  fake = _messages.MessageField('Fake', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class MarketplacesolutionsProjectsLocationsGetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsListRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class MarketplacesolutionsProjectsLocationsNetappVolumesCreateRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsNetappVolumesCreateRequest
  object.

  Fields:
    netappVolume: A NetappVolume resource to be passed as the request body.
    parent: Required. The parent project and location.
  """

  netappVolume = _messages.MessageField('NetappVolume', 1)
  parent = _messages.StringField(2, required=True)


class MarketplacesolutionsProjectsLocationsNetappVolumesDeleteRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsNetappVolumesDeleteRequest
  object.

  Fields:
    name: Required. The name of the Volume to delete.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsNetappVolumesGetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsNetappVolumesGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsNetappVolumesListRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsNetappVolumesListRequest object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListNetappVolumesRequest.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MarketplacesolutionsProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class MarketplacesolutionsProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class MarketplacesolutionsProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A MarketplacesolutionsProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetappVolume(_messages.Message):
  r"""A Netapp Volume.

  Enums:
    StateValueValuesEnum: State of the volume.
    StorageTypeValueValuesEnum: The storage type for this volume.

  Messages:
    LabelsValue: Labels as key value pairs.

  Fields:
    aggregate: The storage container name where the volume is created.
    availableSizeGib: The available space for this volume, in GiB.
    bootVolume: Whether this volume contains a boot lun.
    labels: Labels as key value pairs.
    name: Output only. Name of the resource. Format:
      `projects/{project}/locations/{location}/netappVolumes/{volume}`
    requestedSizeGib: The requested size of this storage volume, in GiB.
    state: State of the volume.
    storageType: The storage type for this volume.
    uid: Output only. Unique identifier of the resource.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the volume.

    Values:
      STATE_UNSPECIFIED: The state of this volume is unknown.
      CREATING: The volume is being created.
      READY: The volume is ready for use.
      DELETING: The volumes is being deleted.
      UPDATING: The volume is being updated.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    DELETING = 3
    UPDATING = 4

  class StorageTypeValueValuesEnum(_messages.Enum):
    r"""The storage type for this volume.

    Values:
      STORAGE_TYPE_UNSPECIFIED: The storage type for this volume is unknown.
      SSD: The storage type for this volume is SSD.
      HDD: This storage type for this volume is HDD.
    """
    STORAGE_TYPE_UNSPECIFIED = 0
    SSD = 1
    HDD = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  aggregate = _messages.StringField(1)
  availableSizeGib = _messages.IntegerField(2)
  bootVolume = _messages.BooleanField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  requestedSizeGib = _messages.IntegerField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  storageType = _messages.EnumField('StorageTypeValueValuesEnum', 8)
  uid = _messages.StringField(9)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class ResetBareMetalInstanceRequest(_messages.Message):
  r"""Message requesting to reset a Bare Metal Server."""


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
