/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.util.jcommander.Command;
import org.jf.util.jcommander.ExtendedParameter;
import org.jf.util.jcommander.ExtendedParameters;

@Parameters(commandDescription="Lists the dex files in an apk/oat file.")
@ExtendedParameters(commandName="dex", commandAliases={"d"})
public class ListDexCommand
extends Command {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information")
    private boolean help;
    @Parameter(description="An apk or oat file.")
    @ExtendedParameter(argumentNames={"file"})
    private List<String> inputList = Lists.newArrayList();

    public ListDexCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    public void run() {
        List entries;
        if (this.help || this.inputList == null || this.inputList.isEmpty()) {
            this.usage();
            return;
        }
        if (this.inputList.size() > 1) {
            System.err.println("Too many files specified");
            this.usage();
            return;
        }
        String input = this.inputList.get(0);
        File file = new File(input);
        if (!file.exists()) {
            System.err.println(String.format("Could not find the file: %s", input));
            System.exit(-1);
        }
        try {
            MultiDexContainer container = DexFileFactory.loadDexContainer((File)file, (Opcodes)Opcodes.getDefault());
            entries = container.getDexEntryNames();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (String entry : entries) {
            System.out.println(entry);
        }
    }
}

