/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable.instruction;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import org.jf.dexlib2.util.Preconditions;
import org.jf.util.ImmutableUtils;

public class ImmutableArrayPayload
extends ImmutableInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    protected final int elementWidth;
    @Nonnull
    protected final ImmutableList<Number> arrayElements;

    public ImmutableArrayPayload(int elementWidth, @Nullable List<Number> arrayElements) {
        super(OPCODE);
        this.elementWidth = Preconditions.checkArrayPayloadElementWidth(elementWidth);
        this.arrayElements = Preconditions.checkArrayPayloadElements(elementWidth, arrayElements == null ? ImmutableList.of() : ImmutableList.copyOf(arrayElements));
    }

    public ImmutableArrayPayload(int elementWidth, @Nullable ImmutableList<Number> arrayElements) {
        super(OPCODE);
        this.elementWidth = Preconditions.checkArrayPayloadElementWidth(elementWidth);
        this.arrayElements = Preconditions.checkArrayPayloadElements(elementWidth, ImmutableUtils.nullToEmptyList(arrayElements));
    }

    @Nonnull
    public static ImmutableArrayPayload of(ArrayPayload instruction) {
        if (instruction instanceof ImmutableArrayPayload) {
            return (ImmutableArrayPayload)instruction;
        }
        return new ImmutableArrayPayload(instruction.getElementWidth(), instruction.getArrayElements());
    }

    @Override
    public int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    @Nonnull
    public List<Number> getArrayElements() {
        return this.arrayElements;
    }

    @Override
    public int getCodeUnits() {
        return 4 + (this.elementWidth * this.arrayElements.size() + 1) / 2;
    }

    @Override
    public Format getFormat() {
        return ImmutableArrayPayload.OPCODE.format;
    }
}

