/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.reference.CallSiteReference;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodHandleReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.MethodHandleEncodedValue;
import org.jf.dexlib2.iface.value.MethodTypeEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.jf.dexlib2.util.FieldUtil;
import org.jf.dexlib2.writer.DexWriter;
import org.jf.dexlib2.writer.builder.BuilderAnnotation;
import org.jf.dexlib2.writer.builder.BuilderAnnotationElement;
import org.jf.dexlib2.writer.builder.BuilderAnnotationPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSet;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSetPool;
import org.jf.dexlib2.writer.builder.BuilderCallSitePool;
import org.jf.dexlib2.writer.builder.BuilderCallSiteReference;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.jf.dexlib2.writer.builder.BuilderClassPool;
import org.jf.dexlib2.writer.builder.BuilderEncodedArrayPool;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderFieldPool;
import org.jf.dexlib2.writer.builder.BuilderFieldReference;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderMethodHandlePool;
import org.jf.dexlib2.writer.builder.BuilderMethodHandleReference;
import org.jf.dexlib2.writer.builder.BuilderMethodParameter;
import org.jf.dexlib2.writer.builder.BuilderMethodPool;
import org.jf.dexlib2.writer.builder.BuilderMethodProtoReference;
import org.jf.dexlib2.writer.builder.BuilderMethodReference;
import org.jf.dexlib2.writer.builder.BuilderProtoPool;
import org.jf.dexlib2.writer.builder.BuilderReference;
import org.jf.dexlib2.writer.builder.BuilderStringPool;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypeListPool;
import org.jf.dexlib2.writer.builder.BuilderTypePool;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.dexlib2.writer.util.StaticInitializerUtil;
import org.jf.util.ExceptionWithContext;

public class DexBuilder
extends DexWriter<BuilderStringReference, BuilderStringReference, BuilderTypeReference, BuilderTypeReference, BuilderMethodProtoReference, BuilderFieldReference, BuilderMethodReference, BuilderClassDef, BuilderCallSiteReference, BuilderMethodHandleReference, BuilderAnnotation, BuilderAnnotationSet, BuilderTypeList, BuilderField, BuilderMethod, BuilderEncodedValues.BuilderArrayEncodedValue, BuilderEncodedValues.BuilderEncodedValue, BuilderAnnotationElement, BuilderStringPool, BuilderTypePool, BuilderProtoPool, BuilderFieldPool, BuilderMethodPool, BuilderClassPool, BuilderCallSitePool, BuilderMethodHandlePool, BuilderTypeListPool, BuilderAnnotationPool, BuilderAnnotationSetPool, BuilderEncodedArrayPool> {
    public DexBuilder(@Nonnull Opcodes opcodes) {
        super(opcodes);
    }

    @Override
    @Nonnull
    protected DexWriter.SectionProvider getSectionProvider() {
        return new DexBuilderSectionProvider();
    }

    @Nonnull
    public BuilderField internField(@Nonnull String definingClass, @Nonnull String name, @Nonnull String type, int accessFlags, @Nullable EncodedValue initialValue, @Nonnull Set<? extends Annotation> annotations) {
        return new BuilderField(((BuilderFieldPool)this.fieldSection).internField(definingClass, name, type), accessFlags, this.internNullableEncodedValue(initialValue), ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(annotations));
    }

    @Nonnull
    public BuilderMethod internMethod(@Nonnull String definingClass, @Nonnull String name, @Nullable List<? extends MethodParameter> parameters, @Nonnull String returnType, int accessFlags, @Nonnull Set<? extends Annotation> annotations, @Nullable MethodImplementation methodImplementation) {
        if (parameters == null) {
            parameters = ImmutableList.of();
        }
        return new BuilderMethod(((BuilderMethodPool)this.methodSection).internMethod(definingClass, name, (List<? extends CharSequence>)parameters, returnType), this.internMethodParameters((List<? extends MethodParameter>)parameters), accessFlags, ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(annotations), methodImplementation);
    }

    @Nonnull
    public BuilderClassDef internClassDef(@Nonnull String type, int accessFlags, @Nullable String superclass, @Nullable List<String> interfaces, @Nullable String sourceFile, @Nonnull Set<? extends Annotation> annotations, @Nullable Iterable<? extends BuilderField> fields, @Nullable Iterable<? extends BuilderMethod> methods) {
        if (interfaces == null) {
            interfaces = ImmutableList.of();
        } else {
            HashSet interfaces_copy = Sets.newHashSet((Iterable)interfaces);
            Iterator interfaceIterator = interfaces.iterator();
            while (interfaceIterator.hasNext()) {
                String iface = (String)interfaceIterator.next();
                if (!interfaces_copy.contains(iface)) {
                    interfaceIterator.remove();
                    continue;
                }
                interfaces_copy.remove(iface);
            }
        }
        ImmutableSortedSet staticFields = null;
        ImmutableSortedSet instanceFields = null;
        BuilderEncodedValues.BuilderArrayEncodedValue internedStaticInitializers = null;
        if (fields != null) {
            staticFields = ImmutableSortedSet.copyOf((Iterable)Iterables.filter(fields, FieldUtil.FIELD_IS_STATIC));
            instanceFields = ImmutableSortedSet.copyOf((Iterable)Iterables.filter(fields, FieldUtil.FIELD_IS_INSTANCE));
            ArrayEncodedValue staticInitializers = StaticInitializerUtil.getStaticInitializers((SortedSet<? extends Field>)staticFields);
            if (staticInitializers != null) {
                internedStaticInitializers = ((BuilderEncodedArrayPool)this.encodedArraySection).internArrayEncodedValue(staticInitializers);
            }
        }
        return ((BuilderClassPool)this.classSection).internClass(new BuilderClassDef(((BuilderTypePool)this.typeSection).internType(type), accessFlags, ((BuilderTypePool)this.typeSection).internNullableType(superclass), ((BuilderTypeListPool)this.typeListSection).internTypeList((List<? extends CharSequence>)interfaces), ((BuilderStringPool)this.stringSection).internNullableString(sourceFile), ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(annotations), (SortedSet<BuilderField>)staticFields, (SortedSet<BuilderField>)instanceFields, methods, internedStaticInitializers));
    }

    public BuilderCallSiteReference internCallSite(@Nonnull CallSiteReference callSiteReference) {
        return ((BuilderCallSitePool)this.callSiteSection).internCallSite(callSiteReference);
    }

    public BuilderMethodHandleReference internMethodHandle(@Nonnull MethodHandleReference methodHandleReference) {
        return ((BuilderMethodHandlePool)this.methodHandleSection).internMethodHandle(methodHandleReference);
    }

    @Nonnull
    public BuilderStringReference internStringReference(@Nonnull String string) {
        return ((BuilderStringPool)this.stringSection).internString(string);
    }

    @Nullable
    public BuilderStringReference internNullableStringReference(@Nullable String string) {
        if (string != null) {
            return this.internStringReference(string);
        }
        return null;
    }

    @Nonnull
    public BuilderTypeReference internTypeReference(@Nonnull String type) {
        return ((BuilderTypePool)this.typeSection).internType(type);
    }

    @Nullable
    public BuilderTypeReference internNullableTypeReference(@Nullable String type) {
        if (type != null) {
            return this.internTypeReference(type);
        }
        return null;
    }

    @Nonnull
    public BuilderFieldReference internFieldReference(@Nonnull FieldReference field) {
        return ((BuilderFieldPool)this.fieldSection).internField(field);
    }

    @Nonnull
    public BuilderMethodReference internMethodReference(@Nonnull MethodReference method) {
        return ((BuilderMethodPool)this.methodSection).internMethod(method);
    }

    @Nonnull
    public BuilderMethodProtoReference internMethodProtoReference(@Nonnull MethodProtoReference methodProto) {
        return ((BuilderProtoPool)this.protoSection).internMethodProto(methodProto);
    }

    @Nonnull
    public BuilderReference internReference(@Nonnull Reference reference) {
        if (reference instanceof StringReference) {
            return this.internStringReference(((StringReference)reference).getString());
        }
        if (reference instanceof TypeReference) {
            return this.internTypeReference(((TypeReference)reference).getType());
        }
        if (reference instanceof MethodReference) {
            return this.internMethodReference((MethodReference)reference);
        }
        if (reference instanceof FieldReference) {
            return this.internFieldReference((FieldReference)reference);
        }
        if (reference instanceof MethodProtoReference) {
            return this.internMethodProtoReference((MethodProtoReference)reference);
        }
        if (reference instanceof CallSiteReference) {
            return this.internCallSite((CallSiteReference)reference);
        }
        if (reference instanceof MethodHandleReference) {
            return this.internMethodHandle((MethodHandleReference)reference);
        }
        throw new IllegalArgumentException("Could not determine type of reference");
    }

    @Nonnull
    private List<BuilderMethodParameter> internMethodParameters(@Nullable List<? extends MethodParameter> methodParameters) {
        if (methodParameters == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterator)Iterators.transform(methodParameters.iterator(), (Function)new Function<MethodParameter, BuilderMethodParameter>(){

            @Nullable
            public BuilderMethodParameter apply(MethodParameter input) {
                return DexBuilder.this.internMethodParameter(input);
            }
        }));
    }

    @Nonnull
    private BuilderMethodParameter internMethodParameter(@Nonnull MethodParameter methodParameter) {
        return new BuilderMethodParameter(((BuilderTypePool)this.typeSection).internType(methodParameter.getType()), ((BuilderStringPool)this.stringSection).internNullableString(methodParameter.getName()), ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(methodParameter.getAnnotations()));
    }

    @Override
    protected void writeEncodedValue(@Nonnull DexWriter.InternalEncodedValueWriter writer, @Nonnull BuilderEncodedValues.BuilderEncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case 29: {
                BuilderEncodedValues.BuilderAnnotationEncodedValue annotationEncodedValue = (BuilderEncodedValues.BuilderAnnotationEncodedValue)encodedValue;
                writer.writeAnnotation(annotationEncodedValue.typeReference, annotationEncodedValue.elements);
                break;
            }
            case 28: {
                BuilderEncodedValues.BuilderArrayEncodedValue arrayEncodedValue = (BuilderEncodedValues.BuilderArrayEncodedValue)encodedValue;
                writer.writeArray(arrayEncodedValue.elements);
                break;
            }
            case 31: {
                writer.writeBoolean(((BooleanEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 0: {
                writer.writeByte(((ByteEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 3: {
                writer.writeChar(((CharEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 17: {
                writer.writeDouble(((DoubleEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 27: {
                writer.writeEnum(((BuilderEncodedValues.BuilderEnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                writer.writeField(((BuilderEncodedValues.BuilderFieldEncodedValue)encodedValue).fieldReference);
                break;
            }
            case 16: {
                writer.writeFloat(((FloatEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 4: {
                writer.writeInt(((IntEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 6: {
                writer.writeLong(((LongEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 26: {
                writer.writeMethod(((BuilderEncodedValues.BuilderMethodEncodedValue)encodedValue).methodReference);
                break;
            }
            case 30: {
                writer.writeNull();
                break;
            }
            case 2: {
                writer.writeShort(((ShortEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 23: {
                writer.writeString(((BuilderEncodedValues.BuilderStringEncodedValue)encodedValue).stringReference);
                break;
            }
            case 24: {
                writer.writeType(((BuilderEncodedValues.BuilderTypeEncodedValue)encodedValue).typeReference);
                break;
            }
            case 21: {
                writer.writeMethodType(((BuilderEncodedValues.BuilderMethodTypeEncodedValue)encodedValue).methodProtoReference);
                break;
            }
            case 22: {
                writer.writeMethodHandle(((BuilderEncodedValues.BuilderMethodHandleEncodedValue)encodedValue).methodHandleReference);
                break;
            }
            default: {
                throw new ExceptionWithContext("Unrecognized value type: %d", encodedValue.getValueType());
            }
        }
    }

    @Nonnull
    Set<? extends BuilderAnnotationElement> internAnnotationElements(@Nonnull Set<? extends AnnotationElement> elements) {
        return ImmutableSet.copyOf((Iterator)Iterators.transform(elements.iterator(), (Function)new Function<AnnotationElement, BuilderAnnotationElement>(){

            @Nullable
            public BuilderAnnotationElement apply(AnnotationElement input) {
                return DexBuilder.this.internAnnotationElement(input);
            }
        }));
    }

    @Nonnull
    private BuilderAnnotationElement internAnnotationElement(@Nonnull AnnotationElement annotationElement) {
        return new BuilderAnnotationElement(((BuilderStringPool)this.stringSection).internString(annotationElement.getName()), this.internEncodedValue(annotationElement.getValue()));
    }

    @Nullable
    BuilderEncodedValues.BuilderEncodedValue internNullableEncodedValue(@Nullable EncodedValue encodedValue) {
        if (encodedValue == null) {
            return null;
        }
        return this.internEncodedValue(encodedValue);
    }

    @Nonnull
    BuilderEncodedValues.BuilderEncodedValue internEncodedValue(@Nonnull EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 29: {
                return this.internAnnotationEncodedValue((AnnotationEncodedValue)encodedValue);
            }
            case 28: {
                return this.internArrayEncodedValue((ArrayEncodedValue)encodedValue);
            }
            case 31: {
                boolean value = ((BooleanEncodedValue)encodedValue).getValue();
                return value ? BuilderEncodedValues.BuilderBooleanEncodedValue.TRUE_VALUE : BuilderEncodedValues.BuilderBooleanEncodedValue.FALSE_VALUE;
            }
            case 0: {
                return new BuilderEncodedValues.BuilderByteEncodedValue(((ByteEncodedValue)encodedValue).getValue());
            }
            case 3: {
                return new BuilderEncodedValues.BuilderCharEncodedValue(((CharEncodedValue)encodedValue).getValue());
            }
            case 17: {
                return new BuilderEncodedValues.BuilderDoubleEncodedValue(((DoubleEncodedValue)encodedValue).getValue());
            }
            case 27: {
                return this.internEnumEncodedValue((EnumEncodedValue)encodedValue);
            }
            case 25: {
                return this.internFieldEncodedValue((FieldEncodedValue)encodedValue);
            }
            case 16: {
                return new BuilderEncodedValues.BuilderFloatEncodedValue(((FloatEncodedValue)encodedValue).getValue());
            }
            case 4: {
                return new BuilderEncodedValues.BuilderIntEncodedValue(((IntEncodedValue)encodedValue).getValue());
            }
            case 6: {
                return new BuilderEncodedValues.BuilderLongEncodedValue(((LongEncodedValue)encodedValue).getValue());
            }
            case 26: {
                return this.internMethodEncodedValue((MethodEncodedValue)encodedValue);
            }
            case 30: {
                return BuilderEncodedValues.BuilderNullEncodedValue.INSTANCE;
            }
            case 2: {
                return new BuilderEncodedValues.BuilderShortEncodedValue(((ShortEncodedValue)encodedValue).getValue());
            }
            case 23: {
                return this.internStringEncodedValue((StringEncodedValue)encodedValue);
            }
            case 24: {
                return this.internTypeEncodedValue((TypeEncodedValue)encodedValue);
            }
            case 21: {
                return this.internMethodTypeEncodedValue((MethodTypeEncodedValue)encodedValue);
            }
            case 22: {
                return this.internMethodHandleEncodedValue((MethodHandleEncodedValue)encodedValue);
            }
        }
        throw new ExceptionWithContext("Unexpected encoded value type: %d", encodedValue.getValueType());
    }

    @Nonnull
    private BuilderEncodedValues.BuilderAnnotationEncodedValue internAnnotationEncodedValue(@Nonnull AnnotationEncodedValue value) {
        return new BuilderEncodedValues.BuilderAnnotationEncodedValue(((BuilderTypePool)this.typeSection).internType(value.getType()), this.internAnnotationElements(value.getElements()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderArrayEncodedValue internArrayEncodedValue(@Nonnull ArrayEncodedValue value) {
        return new BuilderEncodedValues.BuilderArrayEncodedValue((List<? extends BuilderEncodedValues.BuilderEncodedValue>)ImmutableList.copyOf((Iterator)Iterators.transform(value.getValue().iterator(), (Function)new Function<EncodedValue, BuilderEncodedValues.BuilderEncodedValue>(){

            @Nullable
            public BuilderEncodedValues.BuilderEncodedValue apply(EncodedValue input) {
                return DexBuilder.this.internEncodedValue(input);
            }
        })));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderEnumEncodedValue internEnumEncodedValue(@Nonnull EnumEncodedValue value) {
        return new BuilderEncodedValues.BuilderEnumEncodedValue(((BuilderFieldPool)this.fieldSection).internField(value.getValue()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderFieldEncodedValue internFieldEncodedValue(@Nonnull FieldEncodedValue value) {
        return new BuilderEncodedValues.BuilderFieldEncodedValue(((BuilderFieldPool)this.fieldSection).internField(value.getValue()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderMethodEncodedValue internMethodEncodedValue(@Nonnull MethodEncodedValue value) {
        return new BuilderEncodedValues.BuilderMethodEncodedValue(((BuilderMethodPool)this.methodSection).internMethod(value.getValue()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderStringEncodedValue internStringEncodedValue(@Nonnull StringEncodedValue string) {
        return new BuilderEncodedValues.BuilderStringEncodedValue(((BuilderStringPool)this.stringSection).internString(string.getValue()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderTypeEncodedValue internTypeEncodedValue(@Nonnull TypeEncodedValue type) {
        return new BuilderEncodedValues.BuilderTypeEncodedValue(((BuilderTypePool)this.typeSection).internType(type.getValue()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderMethodTypeEncodedValue internMethodTypeEncodedValue(@Nonnull MethodTypeEncodedValue methodType) {
        return new BuilderEncodedValues.BuilderMethodTypeEncodedValue(((BuilderProtoPool)this.protoSection).internMethodProto(methodType.getValue()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderMethodHandleEncodedValue internMethodHandleEncodedValue(@Nonnull MethodHandleEncodedValue methodHandle) {
        return new BuilderEncodedValues.BuilderMethodHandleEncodedValue(((BuilderMethodHandlePool)this.methodHandleSection).internMethodHandle(methodHandle.getValue()));
    }

    protected class DexBuilderSectionProvider
    extends DexWriter.SectionProvider {
        protected DexBuilderSectionProvider() {
            super(DexBuilder.this);
        }

        @Nonnull
        public BuilderStringPool getStringSection() {
            return new BuilderStringPool();
        }

        @Nonnull
        public BuilderTypePool getTypeSection() {
            return new BuilderTypePool(DexBuilder.this);
        }

        @Nonnull
        public BuilderProtoPool getProtoSection() {
            return new BuilderProtoPool(DexBuilder.this);
        }

        @Nonnull
        public BuilderFieldPool getFieldSection() {
            return new BuilderFieldPool(DexBuilder.this);
        }

        @Nonnull
        public BuilderMethodPool getMethodSection() {
            return new BuilderMethodPool(DexBuilder.this);
        }

        @Nonnull
        public BuilderClassPool getClassSection() {
            return new BuilderClassPool(DexBuilder.this);
        }

        @Nonnull
        public BuilderCallSitePool getCallSiteSection() {
            return new BuilderCallSitePool(DexBuilder.this);
        }

        @Nonnull
        public BuilderMethodHandlePool getMethodHandleSection() {
            return new BuilderMethodHandlePool(DexBuilder.this);
        }

        @Nonnull
        public BuilderTypeListPool getTypeListSection() {
            return new BuilderTypeListPool(DexBuilder.this);
        }

        @Nonnull
        public BuilderAnnotationPool getAnnotationSection() {
            return new BuilderAnnotationPool(DexBuilder.this);
        }

        @Nonnull
        public BuilderAnnotationSetPool getAnnotationSetSection() {
            return new BuilderAnnotationSetPool(DexBuilder.this);
        }

        @Nonnull
        public BuilderEncodedArrayPool getEncodedArraySection() {
            return new BuilderEncodedArrayPool(DexBuilder.this);
        }
    }
}

