/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import com.android.dex.Code;
import com.android.dx.io.OpcodeInfo;
import com.android.dx.io.Opcodes;
import com.android.dx.io.instructions.CodeInput;
import com.android.dx.io.instructions.DecodedInstruction;
import com.android.dx.io.instructions.FillArrayDataPayloadDecodedInstruction;
import com.android.dx.io.instructions.PackedSwitchPayloadDecodedInstruction;
import com.android.dx.io.instructions.ShortArrayCodeInput;
import com.android.dx.io.instructions.SparseSwitchPayloadDecodedInstruction;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.ArithOp;
import jadx.core.dex.instructions.ConstClassNode;
import jadx.core.dex.instructions.ConstStringNode;
import jadx.core.dex.instructions.FillArrayNode;
import jadx.core.dex.instructions.FilledNewArrayNode;
import jadx.core.dex.instructions.GotoNode;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.IfOp;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.NewArrayNode;
import jadx.core.dex.instructions.SwitchNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.DecodeException;
import java.io.EOFException;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsnDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(InsnDecoder.class);
    private final MethodNode method;
    private final DexNode dex;
    private DecodedInstruction[] insnArr;

    public InsnDecoder(MethodNode mthNode) {
        this.method = mthNode;
        this.dex = this.method.dex();
    }

    public void decodeInsns(Code mthCode) throws DecodeException {
        short[] encodedInstructions = mthCode.getInstructions();
        int size = encodedInstructions.length;
        DecodedInstruction[] decoded = new DecodedInstruction[size];
        ShortArrayCodeInput in = new ShortArrayCodeInput(encodedInstructions);
        try {
            while (in.hasMore()) {
                decoded[in.cursor()] = this.decodeRawInsn(in);
            }
        }
        catch (Exception e) {
            throw new DecodeException(this.method, e.getMessage(), (Throwable)e);
        }
        this.insnArr = decoded;
    }

    private DecodedInstruction decodeRawInsn(ShortArrayCodeInput in) throws EOFException {
        OpcodeInfo.Info opcodeInfo;
        int opcodeUnit = in.read();
        int opcode = Opcodes.extractOpcodeFromUnit((int)opcodeUnit);
        try {
            opcodeInfo = OpcodeInfo.get((int)opcode);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Ignore decode error: '{}', replace with NOP instruction", (Object)e.getMessage());
            opcodeInfo = OpcodeInfo.NOP;
        }
        return opcodeInfo.getFormat().decode(opcodeUnit, (CodeInput)in);
    }

    public InsnNode[] process() throws DecodeException {
        InsnNode[] instructions = new InsnNode[this.insnArr.length];
        for (int i = 0; i < this.insnArr.length; ++i) {
            DecodedInstruction rawInsn = this.insnArr[i];
            if (rawInsn != null) {
                InsnNode insn = this.decode(rawInsn, i);
                insn.setOffset(i);
                instructions[i] = insn;
                continue;
            }
            instructions[i] = null;
        }
        this.insnArr = null;
        return instructions;
    }

    @NotNull
    private InsnNode decode(DecodedInstruction insn, int offset) throws DecodeException {
        switch (insn.getOpcode()) {
            case 0: 
            case 256: 
            case 512: 
            case 768: {
                return new InsnNode(InsnType.NOP, 0);
            }
            case 10: 
            case 11: 
            case 12: {
                return new InsnNode(InsnType.NOP, 0);
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                LiteralArg narrowLitArg = InsnArg.lit(insn, ArgType.NARROW);
                return this.insn(InsnType.CONST, InsnArg.reg(insn, 0, narrowLitArg.getType()), narrowLitArg);
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                LiteralArg wideLitArg = InsnArg.lit(insn, ArgType.WIDE);
                return this.insn(InsnType.CONST, InsnArg.reg(insn, 0, wideLitArg.getType()), wideLitArg);
            }
            case 26: 
            case 27: {
                ConstStringNode constStrInsn = new ConstStringNode(this.dex.getString(insn.getIndex()));
                constStrInsn.setResult(InsnArg.reg(insn, 0, ArgType.STRING));
                return constStrInsn;
            }
            case 28: {
                ArgType clsType = this.dex.getType(insn.getIndex());
                ConstClassNode constClsInsn = new ConstClassNode(clsType);
                constClsInsn.setResult(InsnArg.reg(insn, 0, ArgType.generic("java.lang.Class", clsType)));
                return constClsInsn;
            }
            case 1: 
            case 2: 
            case 3: {
                return this.insn(InsnType.MOVE, InsnArg.reg(insn, 0, ArgType.NARROW), InsnArg.reg(insn, 1, ArgType.NARROW));
            }
            case 4: 
            case 5: 
            case 6: {
                return this.insn(InsnType.MOVE, InsnArg.reg(insn, 0, ArgType.WIDE), InsnArg.reg(insn, 1, ArgType.WIDE));
            }
            case 7: 
            case 8: 
            case 9: {
                return this.insn(InsnType.MOVE, InsnArg.reg(insn, 0, ArgType.UNKNOWN_OBJECT), InsnArg.reg(insn, 1, ArgType.UNKNOWN_OBJECT));
            }
            case 144: 
            case 176: {
                return this.arith(insn, ArithOp.ADD, ArgType.INT);
            }
            case 171: 
            case 203: {
                return this.arith(insn, ArithOp.ADD, ArgType.DOUBLE);
            }
            case 166: 
            case 198: {
                return this.arith(insn, ArithOp.ADD, ArgType.FLOAT);
            }
            case 155: 
            case 187: {
                return this.arith(insn, ArithOp.ADD, ArgType.LONG);
            }
            case 208: 
            case 216: {
                return this.arithLit(insn, ArithOp.ADD, ArgType.INT);
            }
            case 145: 
            case 177: {
                return this.arith(insn, ArithOp.SUB, ArgType.INT);
            }
            case 209: 
            case 217: {
                return new ArithNode(ArithOp.SUB, InsnArg.reg(insn, 0, ArgType.INT), InsnArg.lit(insn, ArgType.INT), InsnArg.reg(insn, 1, ArgType.INT));
            }
            case 156: 
            case 188: {
                return this.arith(insn, ArithOp.SUB, ArgType.LONG);
            }
            case 167: 
            case 199: {
                return this.arith(insn, ArithOp.SUB, ArgType.FLOAT);
            }
            case 172: 
            case 204: {
                return this.arith(insn, ArithOp.SUB, ArgType.DOUBLE);
            }
            case 146: 
            case 178: {
                return this.arith(insn, ArithOp.MUL, ArgType.INT);
            }
            case 173: 
            case 205: {
                return this.arith(insn, ArithOp.MUL, ArgType.DOUBLE);
            }
            case 168: 
            case 200: {
                return this.arith(insn, ArithOp.MUL, ArgType.FLOAT);
            }
            case 157: 
            case 189: {
                return this.arith(insn, ArithOp.MUL, ArgType.LONG);
            }
            case 210: 
            case 218: {
                return this.arithLit(insn, ArithOp.MUL, ArgType.INT);
            }
            case 147: 
            case 179: {
                return this.arith(insn, ArithOp.DIV, ArgType.INT);
            }
            case 148: 
            case 180: {
                return this.arith(insn, ArithOp.REM, ArgType.INT);
            }
            case 159: 
            case 191: {
                return this.arith(insn, ArithOp.REM, ArgType.LONG);
            }
            case 170: 
            case 202: {
                return this.arith(insn, ArithOp.REM, ArgType.FLOAT);
            }
            case 175: 
            case 207: {
                return this.arith(insn, ArithOp.REM, ArgType.DOUBLE);
            }
            case 174: 
            case 206: {
                return this.arith(insn, ArithOp.DIV, ArgType.DOUBLE);
            }
            case 169: 
            case 201: {
                return this.arith(insn, ArithOp.DIV, ArgType.FLOAT);
            }
            case 158: 
            case 190: {
                return this.arith(insn, ArithOp.DIV, ArgType.LONG);
            }
            case 211: 
            case 219: {
                return this.arithLit(insn, ArithOp.DIV, ArgType.INT);
            }
            case 212: 
            case 220: {
                return this.arithLit(insn, ArithOp.REM, ArgType.INT);
            }
            case 149: 
            case 181: {
                return this.arith(insn, ArithOp.AND, ArgType.INT);
            }
            case 213: 
            case 221: {
                return this.arithLit(insn, ArithOp.AND, ArgType.INT);
            }
            case 215: 
            case 223: {
                return this.arithLit(insn, ArithOp.XOR, ArgType.INT);
            }
            case 160: 
            case 192: {
                return this.arith(insn, ArithOp.AND, ArgType.LONG);
            }
            case 150: 
            case 182: {
                return this.arith(insn, ArithOp.OR, ArgType.INT);
            }
            case 214: 
            case 222: {
                return this.arithLit(insn, ArithOp.OR, ArgType.INT);
            }
            case 151: 
            case 183: {
                return this.arith(insn, ArithOp.XOR, ArgType.INT);
            }
            case 161: 
            case 193: {
                return this.arith(insn, ArithOp.OR, ArgType.LONG);
            }
            case 162: 
            case 194: {
                return this.arith(insn, ArithOp.XOR, ArgType.LONG);
            }
            case 154: 
            case 186: {
                return this.arith(insn, ArithOp.USHR, ArgType.INT);
            }
            case 165: 
            case 197: {
                return this.arith(insn, ArithOp.USHR, ArgType.LONG);
            }
            case 152: 
            case 184: {
                return this.arith(insn, ArithOp.SHL, ArgType.INT);
            }
            case 163: 
            case 195: {
                return this.arith(insn, ArithOp.SHL, ArgType.LONG);
            }
            case 153: 
            case 185: {
                return this.arith(insn, ArithOp.SHR, ArgType.INT);
            }
            case 164: 
            case 196: {
                return this.arith(insn, ArithOp.SHR, ArgType.LONG);
            }
            case 224: {
                return this.arithLit(insn, ArithOp.SHL, ArgType.INT);
            }
            case 225: {
                return this.arithLit(insn, ArithOp.SHR, ArgType.INT);
            }
            case 226: {
                return this.arithLit(insn, ArithOp.USHR, ArgType.INT);
            }
            case 123: {
                return this.neg(insn, ArgType.INT);
            }
            case 125: {
                return this.neg(insn, ArgType.LONG);
            }
            case 127: {
                return this.neg(insn, ArgType.FLOAT);
            }
            case 128: {
                return this.neg(insn, ArgType.DOUBLE);
            }
            case 124: {
                return this.not(insn, ArgType.INT);
            }
            case 126: {
                return this.not(insn, ArgType.LONG);
            }
            case 141: {
                return this.cast(insn, ArgType.INT, ArgType.BYTE);
            }
            case 142: {
                return this.cast(insn, ArgType.INT, ArgType.CHAR);
            }
            case 143: {
                return this.cast(insn, ArgType.INT, ArgType.SHORT);
            }
            case 130: {
                return this.cast(insn, ArgType.INT, ArgType.FLOAT);
            }
            case 131: {
                return this.cast(insn, ArgType.INT, ArgType.DOUBLE);
            }
            case 129: {
                return this.cast(insn, ArgType.INT, ArgType.LONG);
            }
            case 135: {
                return this.cast(insn, ArgType.FLOAT, ArgType.INT);
            }
            case 137: {
                return this.cast(insn, ArgType.FLOAT, ArgType.DOUBLE);
            }
            case 136: {
                return this.cast(insn, ArgType.FLOAT, ArgType.LONG);
            }
            case 138: {
                return this.cast(insn, ArgType.DOUBLE, ArgType.INT);
            }
            case 140: {
                return this.cast(insn, ArgType.DOUBLE, ArgType.FLOAT);
            }
            case 139: {
                return this.cast(insn, ArgType.DOUBLE, ArgType.LONG);
            }
            case 132: {
                return this.cast(insn, ArgType.LONG, ArgType.INT);
            }
            case 133: {
                return this.cast(insn, ArgType.LONG, ArgType.FLOAT);
            }
            case 134: {
                return this.cast(insn, ArgType.LONG, ArgType.DOUBLE);
            }
            case 50: 
            case 56: {
                return new IfNode(insn, IfOp.EQ);
            }
            case 51: 
            case 57: {
                return new IfNode(insn, IfOp.NE);
            }
            case 54: 
            case 60: {
                return new IfNode(insn, IfOp.GT);
            }
            case 53: 
            case 59: {
                return new IfNode(insn, IfOp.GE);
            }
            case 52: 
            case 58: {
                return new IfNode(insn, IfOp.LT);
            }
            case 55: 
            case 61: {
                return new IfNode(insn, IfOp.LE);
            }
            case 49: {
                return this.cmp(insn, InsnType.CMP_L, ArgType.LONG);
            }
            case 45: {
                return this.cmp(insn, InsnType.CMP_L, ArgType.FLOAT);
            }
            case 47: {
                return this.cmp(insn, InsnType.CMP_L, ArgType.DOUBLE);
            }
            case 46: {
                return this.cmp(insn, InsnType.CMP_G, ArgType.FLOAT);
            }
            case 48: {
                return this.cmp(insn, InsnType.CMP_G, ArgType.DOUBLE);
            }
            case 40: 
            case 41: 
            case 42: {
                return new GotoNode(insn.getTarget());
            }
            case 39: {
                return this.insn(InsnType.THROW, null, InsnArg.reg(insn, 0, ArgType.THROWABLE));
            }
            case 13: {
                return this.insn(InsnType.MOVE_EXCEPTION, InsnArg.reg(insn, 0, ArgType.UNKNOWN_OBJECT_NO_ARRAY));
            }
            case 14: {
                return new InsnNode(InsnType.RETURN, 0);
            }
            case 15: 
            case 16: 
            case 17: {
                return this.insn(InsnType.RETURN, null, InsnArg.reg(insn, 0, this.method.getReturnType()));
            }
            case 32: {
                IndexInsnNode instInsn = new IndexInsnNode(InsnType.INSTANCE_OF, this.dex.getType(insn.getIndex()), 1);
                instInsn.setResult(InsnArg.reg(insn, 0, ArgType.BOOLEAN));
                instInsn.addArg(InsnArg.reg(insn, 1, ArgType.UNKNOWN_OBJECT));
                return instInsn;
            }
            case 31: {
                ArgType castType = this.dex.getType(insn.getIndex());
                IndexInsnNode checkCastInsn = new IndexInsnNode(InsnType.CHECK_CAST, castType, 1);
                checkCastInsn.setResult(InsnArg.reg(insn, 0, castType));
                checkCastInsn.addArg(InsnArg.reg(insn, 0, ArgType.UNKNOWN_OBJECT));
                return checkCastInsn;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                FieldInfo igetFld = FieldInfo.fromDex(this.dex, insn.getIndex());
                IndexInsnNode igetInsn = new IndexInsnNode(InsnType.IGET, igetFld, 1);
                igetInsn.setResult(InsnArg.reg(insn, 0, this.tryResolveFieldType(igetFld)));
                igetInsn.addArg(InsnArg.reg(insn, 1, igetFld.getDeclClass().getType()));
                return igetInsn;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                FieldInfo iputFld = FieldInfo.fromDex(this.dex, insn.getIndex());
                IndexInsnNode iputInsn = new IndexInsnNode(InsnType.IPUT, iputFld, 2);
                iputInsn.addArg(InsnArg.reg(insn, 0, this.tryResolveFieldType(iputFld)));
                iputInsn.addArg(InsnArg.reg(insn, 1, iputFld.getDeclClass().getType()));
                return iputInsn;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                FieldInfo sgetFld = FieldInfo.fromDex(this.dex, insn.getIndex());
                IndexInsnNode sgetInsn = new IndexInsnNode(InsnType.SGET, sgetFld, 0);
                sgetInsn.setResult(InsnArg.reg(insn, 0, this.tryResolveFieldType(sgetFld)));
                return sgetInsn;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                FieldInfo sputFld = FieldInfo.fromDex(this.dex, insn.getIndex());
                IndexInsnNode sputInsn = new IndexInsnNode(InsnType.SPUT, sputFld, 1);
                sputInsn.addArg(InsnArg.reg(insn, 0, this.tryResolveFieldType(sputFld)));
                return sputInsn;
            }
            case 33: {
                InsnNode arrLenInsn = new InsnNode(InsnType.ARRAY_LENGTH, 1);
                arrLenInsn.setResult(InsnArg.reg(insn, 0, ArgType.INT));
                arrLenInsn.addArg(InsnArg.reg(insn, 1, ArgType.array(ArgType.UNKNOWN)));
                return arrLenInsn;
            }
            case 68: {
                return this.arrayGet(insn, ArgType.INT_FLOAT);
            }
            case 71: {
                return this.arrayGet(insn, ArgType.BOOLEAN);
            }
            case 72: {
                return this.arrayGet(insn, ArgType.BYTE);
            }
            case 73: {
                return this.arrayGet(insn, ArgType.CHAR);
            }
            case 74: {
                return this.arrayGet(insn, ArgType.SHORT);
            }
            case 69: {
                return this.arrayGet(insn, ArgType.WIDE);
            }
            case 70: {
                return this.arrayGet(insn, ArgType.UNKNOWN_OBJECT);
            }
            case 75: {
                return this.arrayPut(insn, ArgType.INT_FLOAT);
            }
            case 78: {
                return this.arrayPut(insn, ArgType.BOOLEAN);
            }
            case 79: {
                return this.arrayPut(insn, ArgType.BYTE);
            }
            case 80: {
                return this.arrayPut(insn, ArgType.CHAR);
            }
            case 81: {
                return this.arrayPut(insn, ArgType.SHORT);
            }
            case 76: {
                return this.arrayPut(insn, ArgType.WIDE);
            }
            case 77: {
                return this.arrayPut(insn, ArgType.UNKNOWN_OBJECT);
            }
            case 113: {
                return this.invoke(insn, offset, InvokeType.STATIC, false);
            }
            case 119: {
                return this.invoke(insn, offset, InvokeType.STATIC, true);
            }
            case 112: {
                return this.invoke(insn, offset, InvokeType.DIRECT, false);
            }
            case 114: {
                return this.invoke(insn, offset, InvokeType.INTERFACE, false);
            }
            case 111: {
                return this.invoke(insn, offset, InvokeType.SUPER, false);
            }
            case 110: {
                return this.invoke(insn, offset, InvokeType.VIRTUAL, false);
            }
            case 118: {
                return this.invoke(insn, offset, InvokeType.DIRECT, true);
            }
            case 120: {
                return this.invoke(insn, offset, InvokeType.INTERFACE, true);
            }
            case 117: {
                return this.invoke(insn, offset, InvokeType.SUPER, true);
            }
            case 116: {
                return this.invoke(insn, offset, InvokeType.VIRTUAL, true);
            }
            case 34: {
                ArgType clsType = this.dex.getType(insn.getIndex());
                IndexInsnNode newInstInsn = new IndexInsnNode(InsnType.NEW_INSTANCE, clsType, 0);
                newInstInsn.setResult(InsnArg.reg(insn, 0, clsType));
                return newInstInsn;
            }
            case 35: {
                ArgType arrType = this.dex.getType(insn.getIndex());
                return new NewArrayNode(arrType, InsnArg.reg(insn, 0, arrType), InsnArg.typeImmutableReg(insn, 1, ArgType.INT));
            }
            case 38: {
                return this.fillArray(insn);
            }
            case 36: {
                return this.filledNewArray(insn, offset, false);
            }
            case 37: {
                return this.filledNewArray(insn, offset, true);
            }
            case 43: {
                return this.decodeSwitch(insn, offset, true);
            }
            case 44: {
                return this.decodeSwitch(insn, offset, false);
            }
            case 29: {
                return this.insn(InsnType.MONITOR_ENTER, null, InsnArg.reg(insn, 0, ArgType.UNKNOWN_OBJECT));
            }
            case 30: {
                return this.insn(InsnType.MONITOR_EXIT, null, InsnArg.reg(insn, 0, ArgType.UNKNOWN_OBJECT));
            }
        }
        throw new DecodeException("Unknown instruction: '" + OpcodeInfo.getName((int)insn.getOpcode()) + '\'');
    }

    private ArgType tryResolveFieldType(FieldInfo igetFld) {
        FieldNode fieldNode = this.dex.resolveField(igetFld);
        if (fieldNode != null) {
            return fieldNode.getType();
        }
        return igetFld.getType();
    }

    private InsnNode decodeSwitch(DecodedInstruction insn, int offset, boolean packed) {
        Object[] keys;
        int[] targets;
        int payloadOffset = insn.getTarget();
        DecodedInstruction payload = InsnDecoder.getInsnByOffsetSkipNop(this.insnArr, payloadOffset);
        if (packed) {
            PackedSwitchPayloadDecodedInstruction ps = (PackedSwitchPayloadDecodedInstruction)payload;
            targets = ps.getTargets();
            keys = new Object[targets.length];
            int k = ps.getFirstKey();
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = k++;
            }
        } else {
            SparseSwitchPayloadDecodedInstruction ss = (SparseSwitchPayloadDecodedInstruction)payload;
            targets = ss.getTargets();
            keys = new Object[targets.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = ss.getKeys()[i];
            }
        }
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = targets[i] - payloadOffset + offset;
        }
        int nextOffset = InsnDecoder.getNextInsnOffset(this.insnArr, offset);
        return new SwitchNode(InsnArg.reg(insn, 0, ArgType.NARROW), keys, targets, nextOffset);
    }

    private InsnNode fillArray(DecodedInstruction insn) {
        DecodedInstruction payload = InsnDecoder.getInsnByOffsetSkipNop(this.insnArr, insn.getTarget());
        return new FillArrayNode(insn.getA(), (FillArrayDataPayloadDecodedInstruction)payload);
    }

    private InsnNode filledNewArray(DecodedInstruction insn, int offset, boolean isRange) {
        int resReg = this.getMoveResultRegister(this.insnArr, offset);
        ArgType arrType = this.dex.getType(insn.getIndex());
        ArgType elType = arrType.getArrayElement();
        boolean typeImmutable = elType.isPrimitive();
        int regsCount = insn.getRegisterCount();
        InsnArg[] regs = new InsnArg[regsCount];
        if (isRange) {
            int r = insn.getA();
            for (int i = 0; i < regsCount; ++i) {
                regs[i] = InsnArg.reg(r, elType, typeImmutable);
                ++r;
            }
        } else {
            for (int i = 0; i < regsCount; ++i) {
                int regNum = InsnUtils.getArg(insn, i);
                regs[i] = InsnArg.reg(regNum, elType, typeImmutable);
            }
        }
        FilledNewArrayNode node = new FilledNewArrayNode(elType, regs.length);
        node.setResult(resReg == -1 ? null : InsnArg.reg(resReg, arrType));
        for (InsnArg arg : regs) {
            node.addArg(arg);
        }
        return node;
    }

    private InsnNode cmp(DecodedInstruction insn, InsnType itype, ArgType argType) {
        InsnNode inode = new InsnNode(itype, 2);
        inode.setResult(InsnArg.reg(insn, 0, ArgType.INT));
        inode.addArg(InsnArg.reg(insn, 1, argType));
        inode.addArg(InsnArg.reg(insn, 2, argType));
        return inode;
    }

    private InsnNode cast(DecodedInstruction insn, ArgType from, ArgType to) {
        IndexInsnNode inode = new IndexInsnNode(InsnType.CAST, to, 1);
        inode.setResult(InsnArg.reg(insn, 0, to));
        inode.addArg(InsnArg.reg(insn, 1, from));
        return inode;
    }

    private InsnNode invoke(DecodedInstruction insn, int offset, InvokeType type, boolean isRange) {
        int resReg = this.getMoveResultRegister(this.insnArr, offset);
        MethodInfo mth = MethodInfo.fromDex(this.dex, insn.getIndex());
        return new InvokeNode(mth, insn, type, isRange, resReg);
    }

    private InsnNode arrayGet(DecodedInstruction insn, ArgType argType) {
        InsnNode inode = new InsnNode(InsnType.AGET, 2);
        inode.setResult(InsnArg.typeImmutableIfKnownReg(insn, 0, argType));
        inode.addArg(InsnArg.typeImmutableIfKnownReg(insn, 1, ArgType.array(argType)));
        inode.addArg(InsnArg.reg(insn, 2, ArgType.NARROW_INTEGRAL));
        return inode;
    }

    private InsnNode arrayPut(DecodedInstruction insn, ArgType argType) {
        InsnNode inode = new InsnNode(InsnType.APUT, 3);
        inode.addArg(InsnArg.typeImmutableIfKnownReg(insn, 1, ArgType.array(argType)));
        inode.addArg(InsnArg.reg(insn, 2, ArgType.NARROW_INTEGRAL));
        inode.addArg(InsnArg.typeImmutableIfKnownReg(insn, 0, argType));
        return inode;
    }

    private InsnNode arith(DecodedInstruction insn, ArithOp op, ArgType type) {
        return new ArithNode(insn, op, this.fixTypeForBitOps(op, type), false);
    }

    private InsnNode arithLit(DecodedInstruction insn, ArithOp op, ArgType type) {
        return new ArithNode(insn, op, this.fixTypeForBitOps(op, type), true);
    }

    private ArgType fixTypeForBitOps(ArithOp op, ArgType type) {
        if (type == ArgType.INT && (op == ArithOp.AND || op == ArithOp.OR || op == ArithOp.XOR)) {
            return ArgType.NARROW_NUMBERS_NO_FLOAT;
        }
        return type;
    }

    private InsnNode neg(DecodedInstruction insn, ArgType type) {
        InsnNode inode = new InsnNode(InsnType.NEG, 1);
        inode.setResult(InsnArg.reg(insn, 0, type));
        inode.addArg(InsnArg.reg(insn, 1, type));
        return inode;
    }

    private InsnNode not(DecodedInstruction insn, ArgType type) {
        InsnNode inode = new InsnNode(InsnType.NOT, 1);
        inode.setResult(InsnArg.reg(insn, 0, type));
        inode.addArg(InsnArg.reg(insn, 1, type));
        return inode;
    }

    private InsnNode insn(InsnType type, RegisterArg res) {
        InsnNode node = new InsnNode(type, 0);
        node.setResult(res);
        return node;
    }

    private InsnNode insn(InsnType type, RegisterArg res, InsnArg arg) {
        InsnNode node = new InsnNode(type, 1);
        node.setResult(res);
        node.addArg(arg);
        return node;
    }

    private int getMoveResultRegister(DecodedInstruction[] insnArr, int offset) {
        DecodedInstruction next;
        int opc;
        int nextOffset = InsnDecoder.getNextInsnOffsetSkipNop(insnArr, offset);
        if (nextOffset >= 0 && ((opc = (next = insnArr[nextOffset]).getOpcode()) == 10 || opc == 11 || opc == 12)) {
            return next.getA();
        }
        return -1;
    }

    private static DecodedInstruction getInsnByOffsetSkipNop(DecodedInstruction[] insnArr, int offset) {
        DecodedInstruction payload = insnArr[offset];
        if (payload.getOpcode() == 0) {
            return insnArr[InsnDecoder.getNextInsnOffsetSkipNop(insnArr, offset)];
        }
        return payload;
    }

    public static int getNextInsnOffset(DecodedInstruction[] insnArr, int offset) {
        return InsnDecoder.getNextInsnOffset(insnArr, offset, null);
    }

    public static int getNextInsnOffsetSkipNop(DecodedInstruction[] insnArr, int offset) {
        return InsnDecoder.getNextInsnOffset(insnArr, offset, i -> i.getOpcode() == 0);
    }

    public static int getNextInsnOffset(InsnNode[] insnArr, int offset) {
        return InsnDecoder.getNextInsnOffset(insnArr, offset, null);
    }

    public static <T> int getNextInsnOffset(T[] insnArr, int offset, Predicate<T> skip) {
        T insn;
        int i;
        for (i = offset + 1; i < insnArr.length && ((insn = insnArr[i]) == null || skip != null && skip.test(insn)); ++i) {
        }
        if (i >= insnArr.length) {
            return -1;
        }
        return i;
    }
}

