/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.debuginfo;

import jadx.core.dex.attributes.nodes.LocalVarsDebugInfoAttr;
import jadx.core.dex.attributes.nodes.RegDebugInfoAttr;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.blocksmaker.BlockSplitter;
import jadx.core.dex.visitors.debuginfo.DebugInfoParser;
import jadx.core.dex.visitors.debuginfo.LocalVar;
import jadx.core.dex.visitors.ssa.SSATransform;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="Debug Info Parser", desc="Parse debug information (variable names and types, instruction lines)", runBefore={BlockSplitter.class, SSATransform.class})
public class DebugInfoParseVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(DebugInfoParseVisitor.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        try {
            int debugOffset = mth.getDebugInfoOffset();
            if (debugOffset > 0 && mth.dex().checkOffset(debugOffset)) {
                this.processDebugInfo(mth, debugOffset);
            }
        }
        catch (Exception e) {
            mth.addComment("JADX WARNING: Error to parse debug info: " + ErrorsCounter.formatMsg(mth, e.getMessage()) + '\n' + Utils.getStackTrace(e));
        }
    }

    private void processDebugInfo(MethodNode mth, int debugOffset) {
        InsnNode[] insnArr = mth.getInstructions();
        DebugInfoParser debugInfoParser = new DebugInfoParser(mth, debugOffset, insnArr);
        List<LocalVar> localVars = debugInfoParser.process();
        this.attachDebugInfo(mth, localVars, insnArr);
        this.setMethodSourceLine(mth, insnArr);
    }

    private void attachDebugInfo(MethodNode mth, List<LocalVar> localVars, InsnNode[] insnArr) {
        if (localVars.isEmpty()) {
            return;
        }
        localVars.forEach(var -> {
            int start = var.getStartAddr();
            int end = var.getEndAddr();
            RegDebugInfoAttr debugInfoAttr = new RegDebugInfoAttr((LocalVar)var);
            if (start < 0) {
                RegisterArg thisArg = mth.getThisArg();
                if (thisArg != null) {
                    this.attachDebugInfo(thisArg, (LocalVar)var, debugInfoAttr);
                }
                for (RegisterArg arg : mth.getArgRegs()) {
                    this.attachDebugInfo(arg, (LocalVar)var, debugInfoAttr);
                }
                start = 0;
            }
            for (int i = start; i <= end; ++i) {
                InsnNode insn = insnArr[i];
                if (insn == null) continue;
                this.attachDebugInfo(insn.getResult(), (LocalVar)var, debugInfoAttr);
                for (InsnArg arg : insn.getArguments()) {
                    this.attachDebugInfo(arg, (LocalVar)var, debugInfoAttr);
                }
            }
        });
        mth.addAttr(new LocalVarsDebugInfoAttr(localVars));
    }

    private void attachDebugInfo(InsnArg arg, LocalVar var, RegDebugInfoAttr debugInfoAttr) {
        if (arg instanceof RegisterArg) {
            RegisterArg reg = (RegisterArg)arg;
            if (var.getRegNum() == reg.getRegNum()) {
                reg.addAttr(debugInfoAttr);
            }
        }
    }

    private void setMethodSourceLine(MethodNode mth, InsnNode[] insnArr) {
        for (InsnNode insn : insnArr) {
            int line;
            if (insn == null || (line = insn.getSourceLine()) == 0) continue;
            mth.setSourceLine(line - 1);
            return;
        }
    }

    private static /* synthetic */ void lambda$attachDebugInfo$0(LocalVar v) {
        LOG.debug("  {}", (Object)v);
    }
}

