/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.files;

import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);
    public static final int READ_BUFFER_SIZE = 8192;
    private static final int MAX_FILENAME_LENGTH = 128;
    private static final Object MKDIR_SYNC = new Object();
    private static final Path TEMP_ROOT_DIR = FileUtils.createTempRootDir();

    private FileUtils() {
    }

    public static void addFileToJar(JarOutputStream jar, File source, String entryName) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
            JarEntry entry = new JarEntry(entryName);
            entry.setTime(source.lastModified());
            jar.putNextEntry(entry);
            FileUtils.copyStream(in, jar);
            jar.closeEntry();
        }
    }

    public static void makeDirsForFile(Path path) {
        if (path != null) {
            FileUtils.makeDirs(path.getParent().toFile());
        }
    }

    public static void makeDirsForFile(File file) {
        if (file != null) {
            FileUtils.makeDirs(file.getParentFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeDirs(@Nullable File dir) {
        if (dir != null) {
            Object object = MKDIR_SYNC;
            synchronized (object) {
                if (!dir.mkdirs() && !dir.isDirectory()) {
                    throw new JadxRuntimeException("Can't create directory " + dir);
                }
            }
        }
    }

    public static boolean deleteDir(File dir) {
        File[] content = dir.listFiles();
        if (content != null) {
            for (File file : content) {
                FileUtils.deleteDir(file);
            }
        }
        return dir.delete();
    }

    private static Path createTempRootDir() {
        try {
            Path dir = Files.createTempDirectory("jadx-instance-", new FileAttribute[0]);
            dir.toFile().deleteOnExit();
            return dir;
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to create temp root directory", e);
        }
    }

    public static Path createTempDir(String prefix) {
        try {
            Path dir = Files.createTempDirectory(TEMP_ROOT_DIR, prefix, new FileAttribute[0]);
            dir.toFile().deleteOnExit();
            return dir;
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to create temp directory with suffix: " + prefix, e);
        }
    }

    public static Path createTempFile(String suffix) {
        try {
            Path path = Files.createTempFile(TEMP_ROOT_DIR, "jadx-tmp-", suffix, new FileAttribute[0]);
            path.toFile().deleteOnExit();
            return path;
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to create temp file with suffix: " + suffix, e);
        }
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        while ((count = input.read(buffer)) != -1) {
            output.write(buffer, 0, count);
        }
    }

    public static byte[] streamToByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            FileUtils.copyStream(input, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            LOG.error("Close exception for {}", (Object)c, (Object)e);
        }
    }

    @NotNull
    public static File prepareFile(File file) {
        File saveFile = FileUtils.cutFileName(file);
        FileUtils.makeDirsForFile(saveFile);
        return saveFile;
    }

    private static File cutFileName(File file) {
        String name = file.getName();
        if (name.length() <= 128) {
            return file;
        }
        int dotIndex = name.indexOf(46);
        int cutAt = 128 - name.length() + dotIndex - 1;
        name = cutAt <= 0 ? name.substring(0, 127) : name.substring(0, cutAt) + name.substring(dotIndex);
        return new File(file.getParentFile(), name);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789abcdef".toCharArray();
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isZipFile(File file) {
        try (FileInputStream is = new FileInputStream(file);){
            byte[] headers = new byte[4];
            int read = ((InputStream)is).read(headers, 0, 4);
            if (read != headers.length) return false;
            String headerString = FileUtils.bytesToHex(headers);
            if (!Objects.equals(headerString, "504b0304")) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Failed read zip file: {}", (Object)file.getAbsolutePath(), (Object)e);
        }
        return false;
    }

    private static List<String> getZipFileList(File file) {
        ArrayList<String> filesList = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                filesList.add(entry.getName());
            }
        }
        catch (Exception e) {
            LOG.error("Error read zip file '{}'", (Object)file.getAbsolutePath(), (Object)e);
        }
        return filesList;
    }

    public static boolean isApkFile(File file) {
        if (!FileUtils.isZipFile(file)) {
            return false;
        }
        List<String> filesList = FileUtils.getZipFileList(file);
        return filesList.contains("AndroidManifest.xml") && filesList.contains("classes.dex");
    }

    public static boolean isZipDexFile(File file) {
        if (!FileUtils.isZipFile(file) || !FileUtils.isZipFileCanBeOpen(file)) {
            return false;
        }
        List<String> filesList = FileUtils.getZipFileList(file);
        return filesList.contains("classes.dex");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isZipFileCanBeOpen(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            boolean bl = zipFile.entries().hasMoreElements();
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getPathBaseName(Path file) {
        String fileName = file.getFileName().toString();
        int extEndIndex = fileName.lastIndexOf(46);
        if (extEndIndex == -1) {
            return fileName;
        }
        return fileName.substring(0, extEndIndex);
    }

    public static File toFile(String path) {
        if (path == null) {
            return null;
        }
        return new File(path);
    }
}

