/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnr.constants.platform.Errno;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyStandardError;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.SystemCallError;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

@JRubyClass(name={"SystemCallError"}, parent="StandardError")
public class RubySystemCallError
extends RubyStandardError {
    private IRubyObject errno = this.getRuntime().getNil();
    private static final Map<String, String> defaultMessages = new HashMap<String, String>();
    private static final ObjectMarshal SYSTEM_CALL_ERROR_MARSHAL;

    protected RubySystemCallError(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass, null);
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new SystemCallError(message2, this);
    }

    public static RubyClass define(Ruby runtime2, RubyClass standardError) {
        RubyClass exceptionClass = runtime2.defineClass("SystemCallError", standardError, RubySystemCallError::new);
        exceptionClass.setMarshal(SYSTEM_CALL_ERROR_MARSHAL);
        exceptionClass.defineAnnotatedMethods(RubySystemCallError.class);
        return exceptionClass;
    }

    @Override
    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        boolean isErrnoClass;
        Ruby runtime2 = this.getRuntime();
        RubyClass sCallErorrClass = runtime2.getSystemCallError();
        RubyClass klass = this.getMetaClass().getRealClass();
        IRubyObject msg = runtime2.getNil();
        IRubyObject err = runtime2.getNil();
        boolean bl = isErrnoClass = !klass.equals(sCallErorrClass);
        if (!isErrnoClass) {
            Arity.checkArgumentCount(runtime2, args2, 1, 2);
            msg = args2[0];
            if (args2.length == 2) {
                err = args2[1];
            }
            if (args2.length == 1 && msg instanceof RubyFixnum) {
                err = msg;
                msg = runtime2.getNil();
            }
        } else {
            Arity.checkArgumentCount(runtime2, args2, 0, 1);
            if (args2.length == 1) {
                msg = args2[0];
            }
            err = klass.getConstant("Errno");
        }
        String val = null;
        if (!err.isNil()) {
            this.errno = err.convertToInteger();
            int errnoVal = RubyNumeric.num2int(this.errno);
            if (Errno.valueOf(errnoVal) != Errno.__UNKNOWN_CONSTANT__) {
                isErrnoClass = true;
                if (this.metaClass == runtime2.getSystemCallError() || this.metaClass == runtime2.getErrno()) {
                    this.setMetaClass(runtime2.getErrno(errnoVal));
                }
                klass = this.getMetaClass().getRealClass();
                if (!Platform.IS_WINDOWS) {
                    val = Errno.valueOf(errnoVal).description();
                }
            }
        }
        if (val == null && (val = defaultMessages.get(klass.getName())) == null) {
            val = "Unknown error (" + klass.getName() + ")";
        }
        if (!this.errno.isNil() && !isErrnoClass) {
            val = val + " " + this.errno.toString();
        }
        if (!msg.isNil()) {
            val = val + " - " + msg.convertToString();
        }
        this.message = runtime2.newString(val);
        return this;
    }

    @JRubyMethod
    public IRubyObject errno() {
        return this.errno;
    }

    static {
        defaultMessages.put("Errno::EPERM", "Operation not permitted");
        defaultMessages.put("Errno::ENOENT", "No such file or directory");
        defaultMessages.put("Errno::ESRCH", "No such process");
        defaultMessages.put("Errno::EINTR", "Interrupted system call");
        defaultMessages.put("Errno::EIO", "Input/output error");
        defaultMessages.put("Errno::ENXIO", "Device not configured");
        defaultMessages.put("Errno::E2BIG", "Argument list too long");
        defaultMessages.put("Errno::ENOEXEC", "Exec format error");
        defaultMessages.put("Errno::EBADF", "Bad file descriptor");
        defaultMessages.put("Errno::ECHILD", "No child processes");
        defaultMessages.put("Errno::EDEADLK", "Resource deadlock avoided");
        defaultMessages.put("Errno::ENOMEM", "Cannot allocate memory");
        defaultMessages.put("Errno::EACCES", "Permission denied");
        defaultMessages.put("Errno::EFAULT", "Bad address");
        defaultMessages.put("Errno::ENOTBLK", "Block device required");
        defaultMessages.put("Errno::EBUSY", "Resource busy");
        defaultMessages.put("Errno::EEXIST", "File exists");
        defaultMessages.put("Errno::EXDEV", "Cross-device link");
        defaultMessages.put("Errno::ENODEV", "Operation not supported by device");
        defaultMessages.put("Errno::ENOTDIR", "Not a directory");
        defaultMessages.put("Errno::EISDIR", "Is a directory");
        defaultMessages.put("Errno::EINVAL", "Invalid argument");
        defaultMessages.put("Errno::ENFILE", "Too many open files in system");
        defaultMessages.put("Errno::EMFILE", "Too many open files");
        defaultMessages.put("Errno::ENOTTY", "Inappropriate ioctl for device");
        defaultMessages.put("Errno::ETXTBSY", "Text file busy");
        defaultMessages.put("Errno::EFBIG", "File too large");
        defaultMessages.put("Errno::ENOSPC", "No space left on device");
        defaultMessages.put("Errno::ESPIPE", "Illegal seek");
        defaultMessages.put("Errno::EROFS", "Read-only file system");
        defaultMessages.put("Errno::EMLINK", "Too many links");
        defaultMessages.put("Errno::EPIPE", "Broken pipe");
        defaultMessages.put("Errno::EDOM", "Numerical argument out of domain");
        defaultMessages.put("Errno::ERANGE", "Result too large");
        defaultMessages.put("Errno::EAGAIN", "Resource temporarily unavailable");
        defaultMessages.put("Errno::EWOULDBLOCK", "Resource temporarily unavailable");
        defaultMessages.put("Errno::EINPROGRESS", "Operation now in progress");
        defaultMessages.put("Errno::EALREADY", "Operation already in progress");
        defaultMessages.put("Errno::ENOTSOCK", "Socket operation on non-socket");
        defaultMessages.put("Errno::EDESTADDRREQ", "Destination address required");
        defaultMessages.put("Errno::EMSGSIZE", "Message too long");
        defaultMessages.put("Errno::EPROTOTYPE", "Protocol wrong type for socket");
        defaultMessages.put("Errno::ENOPROTOOPT", "Protocol not available");
        defaultMessages.put("Errno::EPROTONOSUPPORT", "Protocol not supported");
        defaultMessages.put("Errno::ESOCKTNOSUPPORT", "Socket type not supported");
        defaultMessages.put("Errno::EPFNOSUPPORT", "Protocol family not supported");
        defaultMessages.put("Errno::EAFNOSUPPORT", "Address family not supported by protocol family");
        defaultMessages.put("Errno::EADDRINUSE", "Address already in use");
        defaultMessages.put("Errno::EADDRNOTAVAIL", "Can't assign requested address");
        defaultMessages.put("Errno::ENETDOWN", "Network is down");
        defaultMessages.put("Errno::ENETUNREACH", "Network is unreachable");
        defaultMessages.put("Errno::ENETRESET", "Network dropped connection on reset");
        defaultMessages.put("Errno::ECONNABORTED", "Software caused connection abort");
        defaultMessages.put("Errno::ECONNRESET", "Connection reset by peer");
        defaultMessages.put("Errno::ENOBUFS", "No buffer space available");
        defaultMessages.put("Errno::EISCONN", "Socket is already connected");
        defaultMessages.put("Errno::ENOTCONN", "Socket is not connected");
        defaultMessages.put("Errno::ESHUTDOWN", "Can't send after socket shutdown");
        defaultMessages.put("Errno::ETOOMANYREFS", "Too many references: can't splice");
        defaultMessages.put("Errno::ETIMEDOUT", "Operation timed out");
        defaultMessages.put("Errno::ECONNREFUSED", "Connection refused");
        defaultMessages.put("Errno::ELOOP", "Too many levels of symbolic links");
        defaultMessages.put("Errno::ENAMETOOLONG", "File name too long");
        defaultMessages.put("Errno::EHOSTDOWN", "Host is down");
        defaultMessages.put("Errno::EHOSTUNREACH", "No route to host");
        defaultMessages.put("Errno::ENOTEMPTY", "Directory not empty");
        defaultMessages.put("Errno::EUSERS", "Too many users");
        defaultMessages.put("Errno::EDQUOT", "Disc quota exceeded");
        defaultMessages.put("Errno::ESTALE", "Stale NFS file handle");
        defaultMessages.put("Errno::EREMOTE", "Too many levels of remote in path");
        defaultMessages.put("Errno::ENOLCK", "No locks available");
        defaultMessages.put("Errno::ENOSYS", "Function not implemented");
        defaultMessages.put("Errno::EOVERFLOW", "Value too large to be stored in data type");
        defaultMessages.put("Errno::EIDRM", "Identifier removed");
        defaultMessages.put("Errno::ENOMSG", "No message of desired type");
        defaultMessages.put("Errno::EILSEQ", "Illegal byte sequence");
        defaultMessages.put("Errno::EBADMSG", "Bad message");
        defaultMessages.put("Errno::EMULTIHOP", "EMULTIHOP (Reserved)");
        defaultMessages.put("Errno::ENODATA", "No message available on STREAM");
        defaultMessages.put("Errno::ENOLINK", "ENOLINK (Reserved)");
        defaultMessages.put("Errno::ENOSR", "No STREAM resources");
        defaultMessages.put("Errno::ENOSTR", "Not a STREAM");
        defaultMessages.put("Errno::EPROTO", "Protocol error");
        defaultMessages.put("Errno::ETIME", "STREAM ioctl timeout");
        defaultMessages.put("Errno::EOPNOTSUPP", "Operation not supported");
        defaultMessages.put("Errno::EOPNOTSUPP_DARWIN", "Operation not supported");
        SYSTEM_CALL_ERROR_MARSHAL = new ObjectMarshal(){

            public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
                RubySystemCallError exc = (RubySystemCallError)obj;
                marshalStream.registerLinkTarget(exc);
                List<Variable<Object>> attrs = exc.getVariableList();
                attrs.add(new VariableEntry<IRubyObject>("mesg", exc.message == null ? runtime2.getNil() : exc.message));
                attrs.add(new VariableEntry<IRubyObject>("errno", exc.errno));
                attrs.add(new VariableEntry<IRubyObject>("bt", exc.getBacktrace()));
                marshalStream.dumpVariables(attrs);
            }

            public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream input) throws IOException {
                RubySystemCallError exc = (RubySystemCallError)input.entry(type2.allocate());
                input.ivar(null, exc, null);
                exc.message = (IRubyObject)exc.removeInternalVariable("mesg");
                exc.errno = (IRubyObject)exc.removeInternalVariable("errno");
                exc.set_backtrace((IRubyObject)exc.removeInternalVariable("bt"));
                return exc;
            }
        };
    }
}

