/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters.geoip;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

enum Fields {
    AUTONOMOUS_SYSTEM_NUMBER("as.number", "asn"),
    AUTONOMOUS_SYSTEM_ORGANIZATION("as.organization.name", "as_org"),
    CITY_NAME("geo.city_name", "city_name"),
    COUNTRY_NAME("geo.country_name", "country_name"),
    CONTINENT_CODE("geo.continent_code", "continent_code"),
    CONTINENT_NAME("geo.continent_name", "continent_name"),
    COUNTRY_CODE2("geo.country_iso_code", "country_code2"),
    COUNTRY_CODE3("", "country_code3"),
    DOMAIN("domain"),
    IP("ip"),
    ISP("mmdb.isp", "isp"),
    POSTAL_CODE("geo.postal_code", "postal_code"),
    DMA_CODE("mmdb.dma_code", "dma_code"),
    REGION_NAME("geo.region_name", "region_name"),
    REGION_CODE("geo.region_code", "region_code"),
    REGION_ISO_CODE("geo.region_iso_code", "region_iso_code"),
    TIMEZONE("geo.timezone", "timezone"),
    LOCATION("geo.location", "location"),
    LATITUDE("geo.location.lat", "latitude"),
    LONGITUDE("geo.location.lon", "longitude"),
    ORGANIZATION("mmdb.organization", "organization");

    private final String fieldName;
    private final String ecsFieldName;
    private final String fieldReferenceLegacy;
    private final String fieldReferenceECSv1;
    private static final Map<String, Fields> MAPPING;
    static final EnumSet<Fields> ALL_FIELDS;
    static final EnumSet<Fields> DEFAULT_CITY_FIELDS;
    static final EnumSet<Fields> DEFAULT_ECS_CITY_FIELDS;
    static final EnumSet<Fields> DEFAULT_COUNTRY_FIELDS;
    static final EnumSet<Fields> DEFAULT_ISP_FIELDS;
    static final EnumSet<Fields> DEFAULT_ASN_LITE_FIELDS;
    static final EnumSet<Fields> DEFAULT_DOMAIN_FIELDS;

    @Deprecated
    private Fields(String fieldName) {
        this(fieldName, fieldName);
    }

    private Fields(String ecsFieldName, String legacyFieldName) {
        this.ecsFieldName = ecsFieldName;
        this.fieldName = legacyFieldName;
        this.fieldReferenceLegacy = Fields.normalizeFieldReferenceFragment(this.fieldName);
        this.fieldReferenceECSv1 = Fields.normalizeFieldReferenceFragment(ecsFieldName);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String getEcsFieldName() {
        return this.ecsFieldName;
    }

    public String getFieldReferenceLegacy() {
        return this.fieldReferenceLegacy;
    }

    public String getFieldReferenceECSv1() {
        return this.fieldReferenceECSv1;
    }

    public static Fields parseField(String value) {
        Fields fields = MAPPING.get(value.toUpperCase(Locale.ROOT));
        if (fields == null) {
            throw new IllegalArgumentException("illegal field value " + value + ". valid values are " + Arrays.toString(ALL_FIELDS.toArray()));
        }
        return fields;
    }

    private static String normalizeFieldReferenceFragment(String fieldName) {
        return Stream.of(fieldName.split("\\.")).map(f -> "[" + f + "]").collect(Collectors.joining());
    }

    static {
        HashMap<String, Fields> mapping = new HashMap<String, Fields>();
        for (Fields value : Fields.values()) {
            mapping.put(value.name().toUpperCase(Locale.ROOT), value);
        }
        MAPPING = Collections.unmodifiableMap(mapping);
        ALL_FIELDS = EnumSet.allOf(Fields.class);
        DEFAULT_CITY_FIELDS = EnumSet.of(IP, new Fields[]{CITY_NAME, CONTINENT_CODE, COUNTRY_NAME, COUNTRY_CODE2, COUNTRY_CODE3, IP, POSTAL_CODE, DMA_CODE, REGION_NAME, REGION_CODE, TIMEZONE, LOCATION, LATITUDE, LONGITUDE});
        DEFAULT_ECS_CITY_FIELDS = EnumSet.copyOf(DEFAULT_CITY_FIELDS);
        DEFAULT_ECS_CITY_FIELDS.remove((Object)REGION_CODE);
        DEFAULT_ECS_CITY_FIELDS.add(REGION_ISO_CODE);
        DEFAULT_COUNTRY_FIELDS = EnumSet.of(IP, COUNTRY_CODE2, IP, COUNTRY_NAME, CONTINENT_NAME);
        DEFAULT_ISP_FIELDS = EnumSet.of(IP, AUTONOMOUS_SYSTEM_NUMBER, AUTONOMOUS_SYSTEM_ORGANIZATION, ISP, ORGANIZATION);
        DEFAULT_ASN_LITE_FIELDS = EnumSet.of(IP, AUTONOMOUS_SYSTEM_NUMBER, AUTONOMOUS_SYSTEM_ORGANIZATION);
        DEFAULT_DOMAIN_FIELDS = EnumSet.of(DOMAIN);
    }
}

