/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.FloatingTextArea;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.util.ResourceBundleUtil;

public class TextAreaEditingTool
extends AbstractTool
implements ActionListener {
    private FloatingTextArea textArea;
    private TextHolderFigure typingTarget;

    public TextAreaEditingTool(TextHolderFigure textHolderFigure) {
        this.typingTarget = textHolderFigure;
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        this.endEdit();
        super.deactivate(drawingEditor);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.typingTarget != null) {
            this.beginEdit(this.typingTarget);
            this.updateCursor(this.getView(), mouseEvent.getPoint());
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
    }

    protected void beginEdit(TextHolderFigure textHolderFigure) {
        if (this.textArea == null) {
            this.textArea = new FloatingTextArea();
        }
        if (textHolderFigure != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textArea.createOverlay(this.getView(), textHolderFigure);
        this.textArea.setBounds(this.getFieldBounds(textHolderFigure), textHolderFigure.getText());
        this.textArea.requestFocus();
        this.typingTarget = textHolderFigure;
    }

    private Rectangle2D.Double getFieldBounds(TextHolderFigure textHolderFigure) {
        Rectangle2D.Double double_ = textHolderFigure.getDrawingArea();
        Insets2D.Double double_2 = textHolderFigure.getInsets();
        double_2.subtractTo(double_);
        double_.x -= 1.0;
        double_.y -= 2.0;
        double_.width += 18.0;
        double_.height += 4.0;
        return double_;
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            this.typingTarget.willChange();
            final TextHolderFigure textHolderFigure = this.typingTarget;
            final String string = this.typingTarget.getText();
            final String string2 = this.textArea.getText();
            this.typingTarget.willChange();
            if (string2.length() > 0) {
                this.typingTarget.setText(string2);
            } else {
                this.typingTarget.setText("");
            }
            this.typingTarget.changed();
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return resourceBundleUtil.getString("attribute.text.text");
                }

                @Override
                public void undo() {
                    super.undo();
                    textHolderFigure.willChange();
                    textHolderFigure.setText(string);
                    textHolderFigure.changed();
                }

                @Override
                public void redo() {
                    super.redo();
                    textHolderFigure.willChange();
                    textHolderFigure.setText(string2);
                    textHolderFigure.changed();
                }
            };
            this.getDrawing().fireUndoableEditHappened(abstractUndoableEdit);
            this.typingTarget.changed();
            this.typingTarget = null;
            this.textArea.endOverlay();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.endEdit();
        this.fireToolDone();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

