/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.hierarchy;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import javax.swing.SwingUtilities;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.hierarchy.IgnoreWindowTask;
import org.assertj.swing.hierarchy.WindowFilter;
import org.assertj.swing.util.AWTEvents;

public final class TransientWindowListener
implements AWTEventListener {
    private final WindowFilter filter;

    TransientWindowListener(@Nonnull WindowFilter filter) {
        this.filter = filter;
    }

    @Override
    @RunsInEDT
    public void eventDispatched(AWTEvent event) {
        AWTEvent e = Preconditions.checkNotNull(event);
        if (AWTEvents.wasWindowOpened(e) || AWTEvents.wasWindowShown(e)) {
            Window w = this.sourceOf(e);
            if (w != null) {
                this.filter(w);
            }
            return;
        }
        if (AWTEvents.wasWindowClosed(e)) {
            Window w = this.sourceOf(e);
            if (w == null) {
                return;
            }
            if (this.filter.isIgnored(w)) {
                return;
            }
            this.filter.implicitlyIgnore(w);
            SwingUtilities.invokeLater(new IgnoreWindowTask(w, this.filter));
        }
    }

    @Nullable
    private Window sourceOf(@Nonnull AWTEvent e) {
        return (Window)e.getSource();
    }

    private void filter(@Nonnull Window w) {
        if (this.filter.isImplicitlyIgnored(w)) {
            this.filter.recognize(w);
            return;
        }
        this.filterIfParentIsFiltered(w);
    }

    private void filterIfParentIsFiltered(@Nonnull Window w) {
        if (!this.filter.isIgnored(w.getParent())) {
            return;
        }
        this.filter.ignore(w);
    }
}

