/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiCompletableReference;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.search.SearchRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.injection.Injectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.references.LanguageReferenceContributorKt;
import org.intellij.plugins.intelliLang.references.LanguageSymbol;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/intelliLang/references/LanguageReferenceContributor;", "Lcom/intellij/model/psi/PsiSymbolReferenceProvider;", "()V", "getReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "element", "Lcom/intellij/model/psi/PsiExternalReferenceHost;", "hints", "Lcom/intellij/model/psi/PsiSymbolReferenceHints;", "getSearchRequests", "Lcom/intellij/model/search/SearchRequest;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/model/Symbol;", "intellij.platform.langInjection"})
public final class LanguageReferenceContributor
implements PsiSymbolReferenceProvider {
    @NotNull
    public Collection<PsiSymbolReference> getReferences(@NotNull PsiExternalReferenceHost element, @NotNull PsiSymbolReferenceHints hints) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hints, (String)"hints");
        PsiExternalReferenceHost $this$castSafelyTo$iv = element;
        boolean $i$f$castSafelyTo = false;
        PsiExternalReferenceHost psiExternalReferenceHost = $this$castSafelyTo$iv;
        if (!(psiExternalReferenceHost instanceof PsiComment)) {
            psiExternalReferenceHost = null;
        }
        PsiComment psiComment = (PsiComment)psiExternalReferenceHost;
        if (psiComment == null) {
            return CollectionsKt.emptyList();
        }
        PsiComment psiComment2 = psiComment;
        TextRange textRange = LanguageReferenceContributorKt.access$getLanguageRange(psiComment2);
        if (textRange == null) {
            return CollectionsKt.emptyList();
        }
        TextRange languageRange = textRange;
        return CollectionsKt.listOf((Object)new PsiCompletableReference(element, languageRange){
            final /* synthetic */ PsiExternalReferenceHost $element;
            final /* synthetic */ TextRange $languageRange;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Collection<LookupElement> getCompletionVariants() {
                void $this$mapTo$iv$iv;
                List<Injectable> list = InjectLanguageAction.getAllInjectables();
                Intrinsics.checkNotNullExpressionValue(list, (String)"InjectLanguageAction.getAllInjectables()");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    String string;
                    void it;
                    Injectable injectable = (Injectable)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    Intrinsics.checkNotNullExpressionValue((Object)v1.getId(), (String)"it.id");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)string2).withIcon(it.getIcon()).withTailText("(" + it.getDisplayName() + ")", true);
                    collection.add(lookupElementBuilder);
                }
                return (List)destination$iv$iv;
            }

            @NotNull
            public PsiElement getElement() {
                return (PsiElement)this.$element;
            }

            @NotNull
            public TextRange getRangeInElement() {
                return this.$languageRange;
            }

            @NotNull
            public Collection<Symbol> resolveReference() {
                String string = this.getRangeInElement().substring(this.getElement().getText());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rangeInElement.substring(this.element.text)");
                return CollectionsKt.listOf((Object)new LanguageSymbol(string));
            }
            {
                this.$element = $captured_local_variable$0;
                this.$languageRange = $captured_local_variable$1;
            }
        });
    }

    @NotNull
    public Collection<SearchRequest> getSearchRequests(@NotNull Project project, @NotNull Symbol target) {
        SearchRequest searchRequest;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Symbol $this$castSafelyTo$iv = target;
        boolean $i$f$castSafelyTo = false;
        Symbol symbol = $this$castSafelyTo$iv;
        if (!(symbol instanceof LanguageSymbol)) {
            symbol = null;
        }
        LanguageSymbol languageSymbol = (LanguageSymbol)symbol;
        if (languageSymbol != null) {
            LanguageSymbol languageSymbol2;
            LanguageSymbol it = languageSymbol2 = languageSymbol;
            boolean bl = false;
            searchRequest = SearchRequest.of((String)it.getName());
        } else {
            searchRequest = null;
        }
        return CollectionsKt.listOfNotNull(searchRequest);
    }
}

