/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.DynamicBundle;
import com.intellij.ide.ui.ProductIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.BranchConfigurationDialog;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.SelectLocationDialog;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.update.SvnRevisionPanel;

public class CreateBranchOrTagDialog
extends DialogWrapper {
    @NotNull
    private final File mySrcFile;
    @NotNull
    private final Url mySrcURL;
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Project myProject;
    private TextFieldWithBrowseButton myToURLText;
    private JTextArea myCommentText;
    private JPanel myTopPanel;
    private JRadioButton myWorkingCopyRadioButton;
    private JRadioButton myRepositoryRadioButton;
    private TextFieldWithBrowseButton myWorkingCopyField;
    private TextFieldWithBrowseButton myRepositoryField;
    private SvnRevisionPanel myRevisionPanel;
    private ComboboxWithBrowseButton myBranchTagBaseComboBox;
    @NotNull
    private final CollectionComboBoxModel<Url> myBranchTagBaseModel;
    private JTextField myBranchTextField;
    private JRadioButton myBranchOrTagRadioButton;
    private JRadioButton myAnyLocationRadioButton;
    private JButton myProjectButton;
    private JLabel myUseThisVariantToLabel;
    private JBCheckBox mySwitchOnCreate;
    @NonNls
    private static final String HELP_ID = "vcs.subversion.branch";
    private SvnBranchConfigurationNew myBranchConfiguration;
    private final VirtualFile mySrcVirtualFile;
    private final Url myWcRootUrl;
    private Target mySource;
    private Url myDestination;

    public CreateBranchOrTagDialog(@NotNull SvnVcs vcs, @NotNull File file) throws VcsException {
        if (vcs == null) {
            CreateBranchOrTagDialog.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CreateBranchOrTagDialog.$$$reportNull$$$0(1);
        }
        super(vcs.getProject(), true);
        this.$$$setupUI$$$();
        this.myBranchTagBaseModel = new CollectionComboBoxModel();
        this.mySrcFile = file;
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.setResizable(true);
        this.setTitle(SvnBundle.message("dialog.title.branch", new Object[0]));
        this.myUseThisVariantToLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)10));
        this.mySwitchOnCreate.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        this.myProjectButton.setIcon(ProductIcons.getInstance().getProjectIcon());
        this.myBranchTagBaseComboBox.setPreferredSize(new Dimension(this.myBranchTagBaseComboBox.getPreferredSize().width, this.myWorkingCopyField.getPreferredSize().height));
        Info info2 = this.myVcs.getInfo(file);
        if (info2 == null || info2.getUrl() == null) {
            throw new VcsException(SvnBundle.message("error.can.not.find.url.for.file", file.getPath()));
        }
        this.mySrcURL = info2.getUrl();
        this.myWorkingCopyField.addBrowseFolderListener(SvnBundle.message("dialog.title.select.working.copy.location", new Object[0]), SvnBundle.message("label.select.location.to.copy.from", new Object[0]), this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myWorkingCopyField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CreateBranchOrTagDialog.this.updateSwitchOnCreate();
                CreateBranchOrTagDialog.this.updateControls();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/branchConfig/CreateBranchOrTagDialog$1", "textChanged"));
            }
        });
        this.myRepositoryField.addActionListener(e -> {
            Url url = SelectLocationDialog.selectLocation(this.myProject, this.mySrcURL);
            if (url != null) {
                this.myRepositoryField.setText(url.toDecodedString());
            }
        });
        this.myRepositoryField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CreateBranchOrTagDialog.this.updateToURL();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/branchConfig/CreateBranchOrTagDialog$2", "textChanged"));
            }
        });
        this.myToURLText.addActionListener(e -> {
            try {
                Url url = SvnUtil.createUrl(this.myToURLText.getText(), false);
                String dstName = this.mySrcURL.getTail();
                Url destination = SelectLocationDialog.selectCopyDestination(this.myProject, SvnUtil.removePathTail(url), dstName);
                if (destination != null) {
                    this.myToURLText.setText(destination.toDecodedString());
                }
            }
            catch (SvnBindException ex) {
                Messages.showErrorDialog((Project)this.myProject, (String)ex.getMessage(), (String)SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
            }
        });
        RootUrlInfo root = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(VcsUtil.getFilePath((File)file));
        if (root == null) {
            throw new VcsException(SvnBundle.message("error.can.not.find.working.copy.for.file", file.getPath()));
        }
        this.mySrcVirtualFile = root.getVirtualFile();
        this.myWcRootUrl = root.getUrl();
        this.myRevisionPanel.setRoot(this.mySrcVirtualFile);
        this.myRevisionPanel.setProject(this.myProject);
        this.myRevisionPanel.setUrlProvider((ThrowableComputable<Url, SvnBindException>)((ThrowableComputable)() -> this.mySrcURL));
        this.myRevisionPanel.setRevisionText(String.valueOf(info2.getRevision()));
        this.updateBranchTagBases();
        this.init();
        ActionListener switchOnCreateListener = e -> this.updateSwitchOnCreate();
        this.myWorkingCopyRadioButton.addActionListener(switchOnCreateListener);
        this.myRepositoryRadioButton.addActionListener(switchOnCreateListener);
        ActionListener listener2 = e -> this.updateControls();
        this.myWorkingCopyRadioButton.addActionListener(listener2);
        this.myRepositoryRadioButton.addActionListener(listener2);
        this.myBranchOrTagRadioButton.addActionListener(listener2);
        this.myAnyLocationRadioButton.addActionListener(listener2);
        this.updateControls();
        this.myBranchTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                CreateBranchOrTagDialog.this.updateToURL();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/branchConfig/CreateBranchOrTagDialog$3", "textChanged"));
            }
        });
        this.updateToURL();
        this.myProjectButton.addActionListener(e -> this.myRepositoryField.setText(this.myWcRootUrl.toDecodedString()));
        this.myBranchTagBaseComboBox.getComboBox().setRenderer(BranchConfigurationDialog.DECODED_URL_RENDERER);
        this.myBranchTagBaseComboBox.getComboBox().setModel(this.myBranchTagBaseModel);
        this.myBranchTagBaseComboBox.addActionListener(e -> {
            BranchConfigurationDialog.configureBranches(this.myProject, this.mySrcVirtualFile);
            this.updateBranchTagBases();
            this.updateControls();
        });
        this.myBranchTagBaseComboBox.getComboBox().addActionListener(e -> {
            this.updateToURL();
            this.updateControls();
        });
    }

    private void updateBranchTagBases() {
        this.myBranchConfiguration = SvnBranchConfigurationManager.getInstance(this.myProject).get(this.mySrcVirtualFile);
        List<Url> branchLocations = this.myBranchConfiguration.getBranchLocations();
        this.myBranchTagBaseModel.replaceAll(branchLocations);
        this.myBranchTagBaseModel.setSelectedItem(ContainerUtil.getFirstItem(branchLocations));
    }

    private void updateToURL() {
        if (this.myBranchConfiguration == null) {
            return;
        }
        Url url = this.myWorkingCopyRadioButton.isSelected() ? this.mySrcURL : this.getRepositoryFieldUrl();
        String relativeUrl = url != null ? this.myBranchConfiguration.getRelativeUrl(url) : null;
        Url selectedBranch = (Url)this.myBranchTagBaseModel.getSelected();
        if (relativeUrl != null && selectedBranch != null) {
            try {
                this.myToURLText.setText(selectedBranch.appendPath(this.myBranchTextField.getText(), false).appendPath(relativeUrl, false).toDecodedString());
            }
            catch (SvnBindException svnBindException) {
                // empty catch block
            }
        }
    }

    private void updateSwitchOnCreate() {
        this.mySwitchOnCreate.setText(SvnBundle.message("checkbox.switch.to.newly.created.branch.or.tag", this.getSourceFile()));
    }

    private void updateControls() {
        this.myWorkingCopyField.setEnabled(this.myWorkingCopyRadioButton.isSelected());
        this.myRepositoryField.setEnabled(this.myRepositoryRadioButton.isSelected());
        this.myRevisionPanel.setEnabled(this.myRepositoryRadioButton.isSelected());
        this.myProjectButton.setEnabled(this.myRepositoryRadioButton.isSelected());
        this.myBranchTagBaseComboBox.setEnabled(this.myBranchOrTagRadioButton.isSelected());
        this.myBranchTextField.setEnabled(this.myBranchOrTagRadioButton.isSelected());
        this.myToURLText.setEnabled(this.myAnyLocationRadioButton.isSelected());
        this.myUseThisVariantToLabel.setForeground(this.myWorkingCopyRadioButton.isSelected() ? UIUtil.getActiveTextColor() : UIUtil.getInactiveTextColor());
    }

    @Nullable
    protected String getHelpId() {
        return HELP_ID;
    }

    protected void init() {
        super.init();
        this.myWorkingCopyField.setText(this.mySrcFile.toString());
        this.myRepositoryField.setText(this.mySrcURL.toDecodedString());
        this.myToURLText.setText(this.mySrcURL.toDecodedString());
        this.updateControls();
        this.myWorkingCopyRadioButton.setSelected(true);
        this.updateSwitchOnCreate();
    }

    public String getComment() {
        return this.myCommentText.getText();
    }

    public Revision getRevision() {
        if (this.myWorkingCopyRadioButton.isSelected()) {
            return Revision.WORKING;
        }
        try {
            return this.myRevisionPanel.getRevision();
        }
        catch (ConfigurationException e) {
            return Revision.UNDEFINED;
        }
    }

    @Nullable
    private Url getRepositoryFieldUrl() {
        try {
            return SvnUtil.createUrl(this.myRepositoryField.getText(), false);
        }
        catch (SvnBindException ignored) {
            return null;
        }
    }

    protected JComponent createCenterPanel() {
        return this.myTopPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBranchTextField;
    }

    protected String getDimensionServiceKey() {
        return "svn.copyDialog";
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info2 = this.validateSource();
        return info2 != null ? info2 : this.validateDestination();
    }

    @Nullable
    private ValidationInfo validateSource() {
        if (this.myRepositoryRadioButton.isSelected()) {
            Url url = this.getRepositoryFieldUrl();
            if (url == null) {
                return new ValidationInfo(SvnBundle.message("dialog.message.invalid.repository.location", new Object[0]), (JComponent)this.myRepositoryField.getTextField());
            }
            Revision revision = this.getRevision();
            if (!revision.isValid() || revision.isLocal()) {
                return new ValidationInfo(SvnBundle.message("dialog.message.invalid.revision", new Object[0]), (JComponent)this.myRevisionPanel.getRevisionTextField());
            }
            this.mySource = Target.on(url, revision);
        } else {
            this.mySource = Target.on(this.getSourceFile(), this.getRevision());
        }
        return null;
    }

    @Nullable
    private ValidationInfo validateDestination() {
        if (this.myBranchOrTagRadioButton.isSelected()) {
            Url branchLocation = (Url)this.myBranchTagBaseModel.getSelected();
            if (branchLocation == null) {
                return new ValidationInfo(SvnBundle.message("dialog.message.no.branch.base.location.selected", new Object[0]), (JComponent)this.myBranchTagBaseComboBox.getComboBox());
            }
            if (StringUtil.isEmptyOrSpaces((String)this.myBranchTextField.getText())) {
                return new ValidationInfo(SvnBundle.message("dialog.message.branch.name.is.empty", new Object[0]), (JComponent)this.myBranchTextField);
            }
            try {
                this.myDestination = branchLocation.appendPath(this.myBranchTextField.getText(), false);
            }
            catch (SvnBindException e) {
                return new ValidationInfo(SvnBundle.message("dialog.message.invalid.branch.name", new Object[0]), (JComponent)this.myBranchTextField);
            }
        }
        try {
            this.myDestination = SvnUtil.createUrl(this.myToURLText.getText(), false);
        }
        catch (SvnBindException e) {
            return new ValidationInfo(SvnBundle.message("dialog.message.invalid.branch.url", new Object[0]), (JComponent)this.myToURLText.getTextField());
        }
        return null;
    }

    public boolean isSwitchOnCreate() {
        return this.mySwitchOnCreate.isSelected();
    }

    @Nullable
    public Target getSource() {
        return this.mySource;
    }

    @NotNull
    public File getSourceFile() {
        return this.myRepositoryRadioButton.isSelected() ? this.mySrcFile : new File(this.myWorkingCopyField.getText());
    }

    @Nullable
    public Url getDestination() {
        return this.myDestination;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JButton jButton;
        SvnRevisionPanel svnRevisionPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JRadioButton jRadioButton3;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JRadioButton jRadioButton4;
        JTextArea jTextArea;
        JPanel jPanel;
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JBScrollPane jBScrollPane = new JBScrollPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jBScrollPane, gridBagConstraints);
        this.myCommentText = jTextArea = new JTextArea();
        jTextArea.setColumns(25);
        jTextArea.setLineWrap(true);
        jTextArea.setRows(4);
        jTextArea.setWrapStyleWord(true);
        jBScrollPane.setViewportView(jTextArea);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("label.copy.from"), (int)0, (int)0, null, null));
        this.myWorkingCopyRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("radio.copy.working.copy"));
        jPanel2.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myWorkingCopyField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton3, new GridConstraints(1, 0, 1, 4, 0, 3, 6, 0, null, null, null, 2));
        this.myRepositoryRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("radio.copy.repository.location"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRepositoryField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(4, 0, 1, 3, 0, 3, 6, 0, null, null, null, 2));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("label.copy.from.revision"));
        jPanel2.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myRevisionPanel = svnRevisionPanel = new SvnRevisionPanel();
        JComponent jComponent = svnRevisionPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myProjectButton = jButton = new JButton();
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.setToolTipText(ResourceBundle.getBundle("messages/SvnBundle").getString("tooltip.use.project.location"));
        jPanel2.add((Component)jButton, new GridConstraints(4, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myUseThisVariantToLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("dialog.create.branch.or.tag.from.working.copy.warning"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null, 2));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 3;
        gridBagConstraints3.fill = 1;
        jPanel.add((Component)jPanel3, gridBagConstraints3);
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("label.copy.to"), (int)0, (int)0, null, null));
        this.myToURLText = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 2, 8, 1, 6, 0, null, null, null, 2));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("label.branch.base.url"));
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myBranchTagBaseComboBox = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel3.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("label.branch.name"));
        jPanel3.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myBranchTextField = jTextField = new JTextField();
        jTextField.setColumns(25);
        jTextField.setText(DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("value.new.branch.name"));
        jPanel3.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(90, -1), null));
        this.myBranchOrTagRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("radio.copy.to.branch.or.tag"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myAnyLocationRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("radio.copy.to.any.location"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/SvnBundle", CreateBranchOrTagDialog.class).getString("label.copy.comment"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.fill = 2;
        jPanel.add((Component)titledSeparator, gridBagConstraints4);
        this.mySwitchOnCreate = jBCheckBox = new JBCheckBox();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 4;
        gridBagConstraints5.anchor = 17;
        jPanel.add((Component)jBCheckBox, gridBagConstraints5);
        jLabel3.setLabelFor((Component)comboboxWithBrowseButton);
        jLabel4.setLabelFor(jTextField);
        titledSeparator.setLabelFor((Component)jTextArea);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "vcs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/svn/branchConfig/CreateBranchOrTagDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

