/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.rollback.ChangesAfterPathComparator;
import org.jetbrains.idea.svn.rollback.ChangesChecker;
import org.jetbrains.idea.svn.rollback.Reverter;
import org.jetbrains.idea.svn.rollback.UnversionedAndNotTouchedFilesGroupCollector;

public class SvnRollbackEnvironment
extends DefaultRollbackEnvironment {
    private final SvnVcs mySvnVcs;

    public SvnRollbackEnvironment(SvnVcs svnVcs) {
        this.mySvnVcs = svnVcs;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getRollbackOperationName() {
        String string = SvnBundle.message("action.name.revert", new Object[0]);
        if (string == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void rollbackChanges(List<? extends Change> changes, List<VcsException> exceptions, @NotNull RollbackProgressListener listener2) {
        if (listener2 == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(1);
        }
        listener2.indeterminate();
        for (Map.Entry entry : SvnUtil.splitChangesIntoWc(this.mySvnVcs, changes).entrySet()) {
            List sortedChanges = ContainerUtil.sorted((Collection)((Collection)entry.getValue()), (Comparator)ChangesAfterPathComparator.getInstance());
            this.rollbackGroupForWc(sortedChanges, exceptions, listener2);
        }
    }

    private void rollbackGroupForWc(@NotNull List<? extends Change> changes, @NotNull List<? super VcsException> exceptions, @NotNull RollbackProgressListener listener2) {
        if (changes == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(2);
        }
        if (exceptions == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(3);
        }
        if (listener2 == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(4);
        }
        UnversionedAndNotTouchedFilesGroupCollector collector = new UnversionedAndNotTouchedFilesGroupCollector();
        ChangesChecker checker2 = new ChangesChecker(this.mySvnVcs, collector);
        checker2.gather(changes);
        exceptions.addAll(checker2.getExceptions());
        Reverter reverter = new Reverter(this.mySvnVcs, listener2, exceptions);
        reverter.moveRenamesToTmp(collector);
        reverter.revert(checker2.getForAdds(), true);
        reverter.revert(checker2.getForDeletes(), true);
        reverter.revert(checker2.getForEdits(), false);
        reverter.moveGroup();
        for (Couple<File> pair : collector.getToBeDeleted()) {
            if (!((File)pair.getFirst()).exists()) continue;
            FileUtil.delete((File)((File)pair.getSecond()));
        }
    }

    public void rollbackMissingFileDeletion(List<? extends FilePath> filePaths, List<? super VcsException> exceptions, @NotNull RollbackProgressListener listener2) {
        if (listener2 == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(5);
        }
        for (FilePath filePath : filePaths) {
            listener2.accept(filePath);
            try {
                this.revertFileOrDir(filePath);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
    }

    private void revertFileOrDir(@NotNull FilePath filePath) throws VcsException {
        File file;
        Info info2;
        if (filePath == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(6);
        }
        if ((info2 = this.mySvnVcs.getInfo(file = filePath.getIOFile())) != null) {
            if (info2.isFile()) {
                this.doRevert(file, false);
            } else if ("add".equals(info2.getSchedule()) || this.mySvnVcs.getWorkingCopyFormat(file).isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN)) {
                this.doRevert(file, true);
            } else {
                this.mySvnVcs.getFactory(file).createUpdateClient().doUpdate(file, Revision.HEAD, Depth.INFINITY, false, false);
            }
        } else {
            throw new VcsException(SvnBundle.message("error.could.not.get.info.for.path", file.getPath()));
        }
    }

    private void doRevert(@NotNull File path, boolean recursive) throws VcsException {
        if (path == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(7);
        }
        this.mySvnVcs.getFactory(path).createRevertClient().revert(Collections.singletonList(path), Depth.allOrFiles(recursive), null);
    }

    public static boolean isMoveRenameReplace(@NotNull Change c) {
        if (c == null) {
            SvnRollbackEnvironment.$$$reportNull$$$0(8);
        }
        if (c.getAfterRevision() == null || c.getBeforeRevision() == null) {
            return false;
        }
        return c.isIsReplaced() || c.isMoved() || c.isRenamed() || !Comparing.equal((Object)c.getBeforeRevision().getFile(), (Object)c.getAfterRevision().getFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackOperationName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rollbackChanges";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rollbackGroupForWc";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rollbackMissingFileDeletion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "revertFileOrDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doRevert";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMoveRenameReplace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

