/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.StringUtils;
import org.apache.tools.ant.BuildException;

public class IvyArtifactProperty
extends IvyPostResolveTask {
    private String name;
    private String value;
    private boolean overwrite = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value2) {
        this.value = value2;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        try {
            ResolutionCacheManager cacheMgr = this.getIvyInstance().getResolutionCacheManager();
            String resolveId = this.getResolveId();
            if (resolveId == null) {
                resolveId = ResolveOptions.getDefaultResolveId(this.getResolvedModuleId());
            }
            XmlReportParser parser = new XmlReportParser();
            for (String conf : StringUtils.splitToArray(this.getConf())) {
                File report2 = cacheMgr.getConfigurationResolveReportInCache(resolveId, conf);
                parser.parse(report2);
                for (Artifact artifact : parser.getArtifacts()) {
                    String name2 = IvyPatternHelper.substitute(this.getSettings().substitute(this.getName()), artifact, conf);
                    String value2 = IvyPatternHelper.substitute(this.getSettings().substitute(this.getValue()), artifact, conf);
                    this.setProperty(name2, value2);
                }
            }
        }
        catch (Exception ex) {
            throw new BuildException("impossible to add artifact properties: " + ex, (Throwable)ex);
        }
    }

    private void setProperty(String name2, String value2) {
        if (this.overwrite) {
            this.getProject().setProperty(name2, value2);
        } else {
            this.getProject().setNewProperty(name2, value2);
        }
    }
}

