/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.publish;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.publish.EndArtifactPublishEvent;
import org.apache.ivy.core.event.publish.StartArtifactPublishEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.publish.PublishEngineSettings;
import org.apache.ivy.core.publish.PublishOptions;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.ConfigurationUtils;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public class PublishEngine {
    private PublishEngineSettings settings;
    private EventManager eventManager;

    public PublishEngine(PublishEngineSettings settings2, EventManager eventManager) {
        this.settings = settings2;
        this.eventManager = eventManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Artifact> publish(ModuleRevisionId mrid, Collection<String> srcArtifactPattern, String resolverName, PublishOptions options2) throws IOException {
        ModuleDescriptor md;
        long start2;
        block13: {
            Message.info(":: publishing :: " + mrid.getModuleId());
            Message.verbose("\tvalidate = " + options2.isValidate());
            start2 = System.currentTimeMillis();
            options2.setSrcIvyPattern(this.settings.substitute(options2.getSrcIvyPattern()));
            if (options2.getPubBranch() == null) {
                options2.setPubbranch(mrid.getBranch());
            }
            if (options2.getPubrevision() == null) {
                options2.setPubrevision(mrid.getRevision());
            }
            ModuleRevisionId pubmrid = ModuleRevisionId.newInstance(mrid, options2.getPubBranch(), options2.getPubrevision());
            md = null;
            if (options2.getSrcIvyPattern() != null) {
                File ivyFile = this.settings.resolveFile(IvyPatternHelper.substitute(options2.getSrcIvyPattern(), DefaultArtifact.newIvyArtifact(pubmrid, new Date())));
                if (!ivyFile.exists()) {
                    throw new IllegalArgumentException("ivy file to publish not found for " + mrid + ": call deliver before (" + ivyFile + ")");
                }
                URL ivyFileURL = ivyFile.toURI().toURL();
                try {
                    md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.settings, ivyFileURL, false);
                    if (options2.isUpdate()) {
                        File tmp = File.createTempFile("ivy", ".xml");
                        tmp.deleteOnExit();
                        String[] confs = ConfigurationUtils.replaceWildcards(options2.getConfs(), md);
                        HashSet<String> confsToRemove = new HashSet<String>(Arrays.asList(md.getConfigurationsNames()));
                        confsToRemove.removeAll(Arrays.asList(confs));
                        try {
                            XmlModuleDescriptorUpdater.update(ivyFileURL, tmp, new UpdateOptions().setSettings(this.settings).setStatus(options2.getStatus() == null ? md.getStatus() : options2.getStatus()).setRevision(options2.getPubrevision()).setBranch(options2.getPubBranch()).setPubdate(options2.getPubdate() == null ? new Date() : options2.getPubdate()).setMerge(options2.isMerge()).setMergedDescriptor(md).setConfsToExclude(confsToRemove.toArray(new String[confsToRemove.size()])));
                            ivyFile = tmp;
                            md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.settings, ivyFile.toURI().toURL(), false);
                            options2.setSrcIvyPattern(ivyFile.getAbsolutePath());
                            break block13;
                        }
                        catch (SAXException e) {
                            throw new IllegalStateException("bad ivy file for " + mrid + ": " + ivyFile + ": " + e);
                        }
                    }
                    if (!options2.getPubrevision().equals(md.getModuleRevisionId().getRevision())) {
                        throw new IllegalArgumentException("cannot publish " + ivyFile + " as " + options2.getPubrevision() + ": bad revision found in ivy file (Revision: " + md.getModuleRevisionId().getRevision() + "). Use forcedeliver or update.");
                    }
                    break block13;
                }
                catch (ParseException e) {
                    throw new IllegalStateException("bad ivy file for " + mrid + ": " + ivyFile + ": " + e);
                }
            }
            ResolutionCacheManager cacheManager = this.settings.getResolutionCacheManager();
            try {
                md = cacheManager.getResolvedModuleDescriptor(mrid);
            }
            catch (ParseException e) {
                throw new IllegalStateException("bad ivy file in cache for " + mrid + ": " + e);
            }
            md.setResolvedModuleRevisionId(pubmrid);
        }
        DependencyResolver resolver2 = this.settings.getResolver(resolverName);
        if (resolver2 == null) {
            throw new IllegalArgumentException("unknown resolver " + resolverName);
        }
        Collection<Artifact> missing = this.publish(md, srcArtifactPattern, resolver2, options2);
        Message.verbose("\tpublish done (" + (System.currentTimeMillis() - start2) + "ms)");
        return missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Artifact> publish(ModuleDescriptor md, Collection<String> srcArtifactPattern, DependencyResolver resolver2, PublishOptions options2) throws IOException {
        ArrayList<Artifact> missing = new ArrayList<Artifact>();
        LinkedHashSet<Artifact> artifactsSet = new LinkedHashSet<Artifact>();
        for (String conf : ConfigurationUtils.replaceWildcards(options2.getConfs(), md)) {
            artifactsSet.addAll(Arrays.asList(md.getArtifacts(conf)));
        }
        Artifact[] extraArtifacts = options2.getExtraArtifacts();
        if (extraArtifacts != null) {
            for (Artifact extraArtifact : extraArtifacts) {
                artifactsSet.add(new MDArtifact(md, extraArtifact.getName(), extraArtifact.getType(), extraArtifact.getExt(), extraArtifact.getUrl(), extraArtifact.getQualifiedExtraAttributes()));
            }
        }
        LinkedHashMap<Artifact, File> artifactsFiles = new LinkedHashMap<Artifact, File>();
        for (Artifact artifact : artifactsSet) {
            for (String pattern2 : srcArtifactPattern) {
                File artifactFile = this.settings.resolveFile(IvyPatternHelper.substitute(this.settings.substitute(pattern2), artifact));
                if (!artifactFile.exists()) continue;
                artifactsFiles.put(artifact, artifactFile);
                break;
            }
            if (artifactsFiles.containsKey(artifact)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("missing artifact ").append(artifact).append(":\n");
            for (String pattern3 : srcArtifactPattern) {
                sb.append("\t").append(this.settings.resolveFile(IvyPatternHelper.substitute(pattern3, artifact))).append(" file does not exist\n");
            }
            if (options2.isWarnOnMissing() || options2.isHaltOnMissing()) {
                Message.warn(sb.toString());
            } else {
                Message.verbose(sb.toString());
            }
            if (options2.isHaltOnMissing()) {
                throw new IOException("missing artifact " + artifact);
            }
            missing.add(artifact);
        }
        if (options2.getSrcIvyPattern() != null) {
            Artifact artifact = MDArtifact.newIvyArtifact(md);
            File artifactFile = this.settings.resolveFile(IvyPatternHelper.substitute(options2.getSrcIvyPattern(), artifact));
            if (!artifactFile.exists()) {
                String msg = "missing ivy file for " + md.getModuleRevisionId() + ": \n" + artifactFile + " file does not exist";
                if (options2.isWarnOnMissing() || options2.isHaltOnMissing()) {
                    Message.warn(msg);
                } else {
                    Message.verbose(msg);
                }
                if (options2.isHaltOnMissing()) {
                    throw new IOException("missing ivy artifact " + artifact);
                }
                missing.add(artifact);
            } else {
                artifactsFiles.put(artifact, artifactFile);
            }
        }
        boolean successfullyPublished = false;
        try {
            resolver2.beginPublishTransaction(md.getModuleRevisionId(), options2.isOverwrite());
            for (Map.Entry entry : artifactsFiles.entrySet()) {
                this.publish((Artifact)entry.getKey(), (File)entry.getValue(), resolver2, options2.isOverwrite());
            }
            resolver2.commitPublishTransaction();
            successfullyPublished = true;
        }
        finally {
            if (!successfullyPublished) {
                resolver2.abortPublishTransaction();
            }
        }
        return missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(Artifact artifact, File src, DependencyResolver resolver2, boolean overwrite) throws IOException {
        IvyContext.getContext().checkInterrupted();
        this.eventManager.fireIvyEvent(new StartArtifactPublishEvent(resolver2, artifact, src, overwrite));
        boolean successful = false;
        try {
            if (src.exists()) {
                resolver2.publish(artifact, src, overwrite);
                successful = true;
            }
        }
        finally {
            this.eventManager.fireIvyEvent(new EndArtifactPublishEvent(resolver2, artifact, src, overwrite, successful));
        }
    }
}

