/*
 * Decompiled with CFR 0.152.
 */
package runtime.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.json.JsonArray;
import runtime.json.JsonArrayBuilderContext;
import runtime.json.JsonDslKt;
import runtime.json.JsonElement;
import runtime.json.JsonObject;
import runtime.json.JsonValue;
import runtime.json.JsonValueBuilderContext;
import runtime.json.RawJsonObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0086\u0004J\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0004J\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0014H\u0086\u0004J\u0017\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0086\u0004J)\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00100\u0016\u00a2\u0006\u0002\b\u0017H\u0086\f\u00f8\u0001\u0000J\u0017\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0018H\u0086\u0004J)\u0010\u0019\u001a\u00020\u0010*\u00020\u00112\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00100\u0016\u00a2\u0006\u0002\b\u0017H\u0086\f\u00f8\u0001\u0000J\n\u0010\u001b\u001a\u00020\u001c*\u00020\u0011J)\u0010\u001d\u001a\u00020\u0010*\u00020\u00112\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00100\u0016\u00a2\u0006\u0002\b\u0017H\u0086\f\u00f8\u0001\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Lruntime/json/JsonBuilderContext;", "", "__node", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "__factory", "Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "__mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "get__factory", "()Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "get__mapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "get__node", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "put", "", "", "value", "", "", "worker", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Lruntime/json/JsonElement;", "putArray", "Lruntime/json/JsonArrayBuilderContext;", "putContext", "Lruntime/json/JsonValueBuilderContext;", "putValue", "platform-runtime"})
public final class JsonBuilderContext {
    @NotNull
    private final ObjectNode __node;
    @NotNull
    private final JsonNodeFactory __factory;
    @NotNull
    private final ObjectMapper __mapper;

    public JsonBuilderContext(@NotNull ObjectNode __node, @NotNull JsonNodeFactory __factory, @NotNull ObjectMapper __mapper) {
        Intrinsics.checkNotNullParameter((Object)__node, (String)"__node");
        Intrinsics.checkNotNullParameter((Object)__factory, (String)"__factory");
        Intrinsics.checkNotNullParameter((Object)__mapper, (String)"__mapper");
        this.__node = __node;
        this.__factory = __factory;
        this.__mapper = __mapper;
    }

    @NotNull
    public final ObjectNode get__node() {
        return this.__node;
    }

    @NotNull
    public final JsonNodeFactory get__factory() {
        return this.__factory;
    }

    @NotNull
    public final ObjectMapper get__mapper() {
        return this.__mapper;
    }

    public final void put(@NotNull String $this$put, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        this.__node.put($this$put, value2);
    }

    public final void put(@NotNull String $this$put, int value2) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        this.__node.put($this$put, value2);
    }

    public final void put(@NotNull String $this$put, long value2) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        this.__node.put($this$put, value2);
    }

    public final void put(@NotNull String $this$put, @Nullable JsonElement value2) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        JsonElement jsonElement = value2;
        if (jsonElement == null) {
            this.__node.set($this$put, null);
        } else if (jsonElement instanceof RawJsonObject) {
            JsonDslKt.putRaw(this, $this$put, ((RawJsonObject)value2).getSerialized());
        } else if (jsonElement instanceof JsonObject) {
            this.__node.set($this$put, (JsonNode)JsonDslKt.node((JsonObject)value2));
        } else if (jsonElement instanceof JsonArray) {
            this.__node.set($this$put, (JsonNode)JsonDslKt.node((JsonArray)value2));
        } else if (jsonElement instanceof JsonValue) {
            this.__node.set($this$put, (JsonNode)JsonDslKt.node((JsonValue)value2));
        } else {
            throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"unknown JsonElement: ", (Object)value2.getClass().getSimpleName()));
        }
    }

    public final void put(@NotNull String $this$put, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        JsonNode jsonNode = this.__mapper.valueToTree(value2);
        if (jsonNode == null) {
            return;
        }
        JsonNode tree = jsonNode;
        this.__node.set($this$put, tree);
    }

    public final void put(@NotNull String $this$put, @NotNull Function1<? super JsonBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        boolean $i$f$put = false;
        ObjectNode objNode = this.get__factory().objectNode();
        Intrinsics.checkNotNullExpressionValue((Object)objNode, (String)"objNode");
        worker.invoke((Object)new JsonBuilderContext(objNode, this.get__factory(), this.get__mapper()));
        this.get__node().set($this$put, (JsonNode)objNode);
    }

    public final void putValue(@NotNull String $this$putValue, @NotNull Function1<? super JsonValueBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter((Object)$this$putValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        boolean $i$f$putValue = false;
        worker.invoke((Object)this.putContext($this$putValue));
    }

    public final void putArray(@NotNull String $this$putArray, @NotNull Function1<? super JsonArrayBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter((Object)$this$putArray, (String)"<this>");
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        boolean $i$f$putArray = false;
        ArrayNode arrayNode = this.get__factory().arrayNode();
        this.get__node().set($this$putArray, (JsonNode)arrayNode);
        Intrinsics.checkNotNullExpressionValue((Object)arrayNode, (String)"arrayNode");
        worker.invoke((Object)new JsonArrayBuilderContext(arrayNode, this.get__factory(), this.get__mapper()));
    }

    @NotNull
    public final JsonValueBuilderContext putContext(@NotNull String $this$putContext) {
        Intrinsics.checkNotNullParameter((Object)$this$putContext, (String)"<this>");
        return new JsonValueBuilderContext((Function1<? super JsonNode, Unit>)((Function1)new Function1<JsonNode, Unit>(this, $this$putContext){
            final /* synthetic */ JsonBuilderContext this$0;
            final /* synthetic */ String $this_putContext;
            {
                this.this$0 = $receiver;
                this.$this_putContext = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull JsonNode newNode) {
                Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
                this.this$0.get__node().set(this.$this_putContext, newNode);
            }
        }), this.__factory, this.__mapper);
    }
}

