/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.util.diff.Diff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiffChangeDiffIterable
extends ChangeDiffIterableBase {
    @Nullable
    private final Diff.Change myChange;

    DiffChangeDiffIterable(@Nullable Diff.Change change, int length1, int length2) {
        super(length1, length2);
        this.myChange = change;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        return new DiffChangeChangeIterable(this.myChange);
    }

    private static class DiffChangeChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        @Nullable
        private Diff.Change myChange;

        DiffChangeChangeIterable(@Nullable Diff.Change change) {
            this.myChange = change;
        }

        @Override
        public boolean valid() {
            return this.myChange != null;
        }

        @Override
        public void next() {
            this.myChange = this.myChange.link;
        }

        @Override
        public int getStart1() {
            return this.myChange.line0;
        }

        @Override
        public int getStart2() {
            return this.myChange.line1;
        }

        @Override
        public int getEnd1() {
            return this.myChange.line0 + this.myChange.deleted;
        }

        @Override
        public int getEnd2() {
            return this.myChange.line1 + this.myChange.inserted;
        }
    }
}

