/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.progress.Cancellation;
import java.util.concurrent.Callable;
import kotlinx.coroutines.CompletableDeferred;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CancellationCallable<V>
implements Callable<V> {
    @NotNull
    private final CompletableDeferred<V> myDeferred;
    @NotNull
    private final Callable<? extends V> myCallable;

    public CancellationCallable(@NotNull CompletableDeferred<V> deferred, @NotNull Callable<? extends V> callable) {
        if (deferred == null) {
            CancellationCallable.$$$reportNull$$$0(0);
        }
        if (callable == null) {
            CancellationCallable.$$$reportNull$$$0(1);
        }
        this.myDeferred = deferred;
        this.myCallable = callable;
    }

    @Override
    public V call() throws Exception {
        try {
            Object result = Cancellation.withJob(this.myDeferred, this.myCallable::call);
            this.myDeferred.complete(result);
            return (V)result;
        }
        catch (Throwable e) {
            this.myDeferred.completeExceptionally(e);
            throw e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "deferred";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "callable";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/progress/CancellationCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

