/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.AbstractTracingInstrumenter;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.LineEnumerator;
import com.intellij.rt.coverage.instrumentation.LocalVariableInserter;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import com.intellij.rt.coverage.instrumentation.data.Jump;
import com.intellij.rt.coverage.instrumentation.data.Switch;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class TracingInstrumenter
extends AbstractTracingInstrumenter {
    public TracingInstrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldCalculateSource) {
        super(projectData, classVisitor, className, shouldCalculateSource);
    }

    public MethodVisitor createTouchCounter(MethodVisitor methodVisitor, BranchDataContainer branchData, LineEnumerator enumerator, int access, String name, String desc, String className) {
        if (!enumerator.hasExecutableLines()) {
            return methodVisitor;
        }
        return new TouchCounter(methodVisitor, branchData, access, desc, className);
    }

    private static class TouchCounter
    extends LocalVariableInserter {
        public static final String CLASS_DATA_LOCAL_VARIABLE_NAME = "__$class__data$__";
        private final BranchDataContainer myBranchData;
        private final String myClassName;

        public TouchCounter(MethodVisitor methodVisitor, BranchDataContainer branchData, int access, String desc, String className) {
            super(methodVisitor, access, desc, CLASS_DATA_LOCAL_VARIABLE_NAME, "Ljava/lang/Object;");
            this.myBranchData = branchData;
            this.myClassName = className;
        }

        public void visitLineNumber(int line, Label start) {
            if (this.myBranchData.getContext().getLineData(line) != null) {
                this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
                InstrumentationUtils.pushInt(this.mv, line);
                this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "trace", "(Ljava/lang/Object;I)V", false);
            }
            super.visitLineNumber(line, start);
        }

        public void visitLabel(Label label) {
            Switch aSwitch;
            super.visitLabel(label);
            Jump jump = this.myBranchData.getJump(label);
            if (jump != null) {
                this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
                InstrumentationUtils.pushInt(this.mv, jump.getLine());
                InstrumentationUtils.pushInt(this.mv, jump.getIndex());
                this.mv.visitInsn(jump.getType() ? 4 : 3);
                this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "touchJump", "(Ljava/lang/Object;IIZ)V", false);
            }
            if ((aSwitch = this.myBranchData.getSwitch(label)) != null) {
                this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
                InstrumentationUtils.pushInt(this.mv, aSwitch.getLine());
                InstrumentationUtils.pushInt(this.mv, aSwitch.getIndex());
                this.mv.visitIntInsn(17, aSwitch.getKey());
                this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "touchSwitch", "(Ljava/lang/Object;III)V", false);
            }
        }

        public void visitCode() {
            this.mv.visitLdcInsn(this.myClassName);
            this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "loadClassData", "(Ljava/lang/String;)Ljava/lang/Object;", false);
            this.mv.visitVarInsn(58, this.getOrCreateLocalVariableIndex());
            super.visitCode();
        }
    }
}

