/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.classFilter;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.FieldVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public abstract class PrivateConstructorOfUtilClassFilter
extends ClassVisitor {
    private static final String KOTLIN_OBJECT_CONSTRUCTOR_DESCRIPTOR = "(Lkotlin/jvm/internal/DefaultConstructorMarker;)V";
    private final Instrumenter myInstrumenter;
    private boolean myIsAbstractClass;
    private boolean myAllMethodsStatic = true;
    private boolean myIsKotlinObject = false;
    private boolean myIsKotlinClass = false;
    private boolean myConstructorIsEmpty = true;
    private List<Integer> myConstructorLines;
    private String myName;
    private String mySuperName;

    public PrivateConstructorOfUtilClassFilter(ClassVisitor classVisitor, Instrumenter context) {
        super(589824, classVisitor);
        this.myInstrumenter = context;
    }

    protected abstract void removeLine(int var1);

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.myName = name;
        this.mySuperName = superName;
        this.myIsKotlinObject |= name != null && name.endsWith("$Companion");
        this.myIsAbstractClass = (access & 0x400) != 0;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        this.myIsKotlinObject |= (access & 0x19) != 0 && "INSTANCE".equals(name) && this.myName.equals(Type.getType(descriptor).getInternalName());
        return super.visitField(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (PrivateConstructorOfUtilClassFilter.isPrivateDefaultConstructor(access, name, descriptor) || PrivateConstructorOfUtilClassFilter.isKotlinObjectSyntheticConstructor(access, name, descriptor)) {
            return new EmptyConstructorVisitor(mv);
        }
        this.myAllMethodsStatic &= (access & 8) != 0;
        return mv;
    }

    public void visitEnd() {
        if ((this.myAllMethodsStatic || this.myIsKotlinObject && this.myIsKotlinClass) && this.myConstructorIsEmpty && this.myConstructorLines != null && !this.isSealedClassConstructor()) {
            for (int line : this.myConstructorLines) {
                if (this.myIsKotlinObject && this.myIsKotlinClass && this.myInstrumenter.linesCount() <= 1) continue;
                this.removeLine(line);
            }
        }
        super.visitEnd();
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.myIsKotlinClass |= "Lkotlin/Metadata;".equals(descriptor);
        return super.visitAnnotation(descriptor, visible);
    }

    private boolean isSealedClassConstructor() {
        if (this.myInstrumenter != null && KotlinUtils.isSealedClass(this.myInstrumenter)) {
            return true;
        }
        return this.myIsAbstractClass && this.myIsKotlinClass;
    }

    private static boolean isPrivateDefaultConstructor(int access, String name, String descriptor) {
        return (access & 2) != 0 && "<init>".equals(name) && "()V".equals(descriptor);
    }

    private static boolean isKotlinObjectSyntheticConstructor(int access, String name, String descriptor) {
        return (access & 0x1001) != 0 && "<init>".equals(name) && KOTLIN_OBJECT_CONSTRUCTOR_DESCRIPTOR.equals(descriptor);
    }

    private void addLine(int line) {
        if (this.myConstructorLines == null) {
            this.myConstructorLines = new ArrayList<Integer>();
        }
        this.myConstructorLines.add(line);
    }

    public static PrivateConstructorOfUtilClassFilter createWithContext(ClassVisitor cv, final Instrumenter context) {
        return new PrivateConstructorOfUtilClassFilter(cv, context){

            protected void removeLine(int line) {
                context.removeLine(line);
            }
        };
    }

    private class EmptyConstructorVisitor
    extends MethodVisitor {
        private boolean myALoadVisited;
        private boolean myInvokeSpecialVisited;

        public EmptyConstructorVisitor(MethodVisitor methodVisitor) {
            super(589824, methodVisitor);
            this.myALoadVisited = false;
            this.myInvokeSpecialVisited = false;
        }

        public void visitLineNumber(int line, Label start) {
            super.visitLineNumber(line, start);
            PrivateConstructorOfUtilClassFilter.this.addLine(line);
        }

        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            if (opcode == 25 && var == 0) {
                this.myALoadVisited = true;
                return;
            }
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            if (this.myALoadVisited && opcode == 183 && owner != null && (owner.equals(PrivateConstructorOfUtilClassFilter.this.mySuperName) || owner.equals(PrivateConstructorOfUtilClassFilter.this.myName)) && "<init>".equals(name) && "()V".equals(descriptor)) {
                this.myInvokeSpecialVisited = true;
                return;
            }
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitInsn(int opcode) {
            super.visitInsn(opcode);
            if (this.myInvokeSpecialVisited && opcode == 177) {
                return;
            }
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            super.visitFieldInsn(opcode, owner, name, descriptor);
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
            super.visitMultiANewArrayInsn(descriptor, numDimensions);
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitTypeInsn(int opcode, String type) {
            super.visitTypeInsn(opcode, type);
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitIntInsn(int opcode, int operand) {
            super.visitIntInsn(opcode, operand);
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitLdcInsn(Object value) {
            super.visitLdcInsn(value);
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitIincInsn(int var, int increment) {
            super.visitIincInsn(var, increment);
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            super.visitLookupSwitchInsn(dflt, keys, labels);
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            super.visitTableSwitchInsn(min, max, dflt, labels);
            PrivateConstructorOfUtilClassFilter.this.myConstructorIsEmpty = false;
        }
    }
}

