/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.markup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.MappingValue;
import org.languagetool.markup.TextPart;

public class AnnotatedTextBuilder {
    private final List<TextPart> parts = new ArrayList<TextPart>();
    private final Map<AnnotatedText.MetaDataKey, String> metaData = new HashMap<AnnotatedText.MetaDataKey, String>();
    private final Map<String, String> customMetaData = new HashMap<String, String>();

    public AnnotatedTextBuilder addGlobalMetaData(AnnotatedText.MetaDataKey key, String value) {
        this.metaData.put(key, value);
        return this;
    }

    public AnnotatedTextBuilder addGlobalMetaData(String key, String value) {
        this.customMetaData.put(key, value);
        return this;
    }

    public AnnotatedTextBuilder addText(String text2) {
        this.parts.add(new TextPart(text2, TextPart.Type.TEXT));
        return this;
    }

    public AnnotatedTextBuilder addMarkup(String markup) {
        this.parts.add(new TextPart(markup, TextPart.Type.MARKUP));
        return this;
    }

    public AnnotatedTextBuilder addMarkup(String markup, String interpretAs) {
        this.parts.add(new TextPart(markup, TextPart.Type.MARKUP));
        this.parts.add(new TextPart(interpretAs, TextPart.Type.FAKE_CONTENT));
        return this;
    }

    public void add(TextPart part) {
        this.parts.add(part);
    }

    public AnnotatedText build() {
        int plainTextPosition = 0;
        int totalPosition = 0;
        HashMap<Integer, MappingValue> mapping = new HashMap<Integer, MappingValue>();
        for (int i2 = 0; i2 < this.parts.size(); ++i2) {
            MappingValue mappingValue;
            TextPart part = this.parts.get(i2);
            if (part.getType() == TextPart.Type.TEXT) {
                mappingValue = new MappingValue(totalPosition += part.getPart().length());
                mapping.put(plainTextPosition += part.getPart().length(), mappingValue);
                continue;
            }
            if (part.getType() != TextPart.Type.MARKUP) continue;
            totalPosition += part.getPart().length();
            if (!this.hasFakeContent(i2, this.parts)) continue;
            plainTextPosition += this.parts.get(i2 + 1).getPart().length();
            ++i2;
            if (mapping.get(plainTextPosition) != null) continue;
            mappingValue = new MappingValue(totalPosition, part.getPart().length());
            mapping.put(plainTextPosition, mappingValue);
        }
        return new AnnotatedText(this.parts, mapping, this.metaData, this.customMetaData);
    }

    private boolean hasFakeContent(int i2, List<TextPart> parts) {
        int nextPartIndex = i2 + 1;
        return nextPartIndex < parts.size() && parts.get(nextPartIndex).getType().equals((Object)TextPart.Type.FAKE_CONTENT);
    }
}

