/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editor;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.testFramework.LightPlatformTestCase;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class EditorColorSchemeTestCase
extends LightPlatformTestCase {
    protected static EditorColorsScheme loadScheme(@NotNull String docText) throws ParserConfigurationException, IOException, SAXException {
        if (docText == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(0);
        }
        DocumentBuilder docBuilder = DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(docText));
        Document doc = docBuilder.parse(inputSource);
        Element root = new DOMBuilder().build(doc.getDocumentElement());
        EditorColorsScheme defaultScheme = EditorColorsManager.getInstance().getScheme("Default");
        EditorColorsSchemeImpl targetScheme = new EditorColorsSchemeImpl(defaultScheme);
        targetScheme.readExternal(root);
        return targetScheme;
    }

    @NotNull
    protected Pair<EditorColorsScheme, TextAttributes> doTestWriteRead(@NotNull TextAttributesKey key, @NotNull TextAttributes attributes) {
        if (key == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(1);
        }
        if (attributes == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(2);
        }
        EditorColorsScheme defaultScheme = EditorColorsManager.getInstance().getScheme("Default");
        EditorColorsScheme sourceScheme = (EditorColorsScheme)defaultScheme.clone();
        sourceScheme.setName("test");
        sourceScheme.setAttributes(key, attributes);
        Element root = new Element("scheme");
        ((AbstractColorsScheme)sourceScheme).writeExternal(root);
        EditorColorsSchemeImpl targetScheme = new EditorColorsSchemeImpl(defaultScheme);
        targetScheme.readExternal(root);
        EditorColorSchemeTestCase.assertEquals((String)"test", (String)targetScheme.getName());
        TextAttributes targetAttrs = targetScheme.getAttributes(key);
        Pair pair = Pair.create((Object)targetScheme, (Object)targetAttrs);
        if (pair == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(3);
        }
        return pair;
    }

    public static void assertXmlOutputEquals(String expected, Element root) {
        EditorColorSchemeTestCase.assertEquals((String)expected, (String)JDOMUtil.write((Element)root));
    }

    protected Element serialize(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(4);
        }
        Element root = new Element("scheme");
        ((AbstractColorsScheme)scheme).writeExternal(root);
        EditorColorSchemeTestCase.fixPlatformSpecificValues(root);
        root.removeChildren("metaInfo");
        return root;
    }

    protected Element serializeWithFixedMeta(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(5);
        }
        Element root = new Element("scheme");
        ((AbstractColorsScheme)scheme).writeExternal(root);
        EditorColorSchemeTestCase.fixPlatformSpecificValues(root);
        Element metaInfo = root.getChild("metaInfo");
        if (metaInfo != null) {
            metaInfo.getChildren().forEach(child -> {
                Attribute name = child.getAttribute("name");
                if (!child.getName().equals("property") || name == null || !RainbowHighlighter.isRainbowKey((Object)name.getValue())) {
                    child.removeContent();
                }
            });
        }
        return root;
    }

    private static void fixPlatformSpecificValues(@NotNull Element root) {
        if (root == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(6);
        }
        ArrayList fontOptions = new ArrayList(root.getChildren("option"));
        for (Element option : fontOptions) {
            String name = option.getAttributeValue("name");
            if (name == null) continue;
            if ("FONT_SCALE".equals(name) || "EDITOR_FONT_SIZE".equals(name) || "EDITOR_FONT_NAME".equals(name)) {
                root.removeContent((Content)option);
                continue;
            }
            if (!"CONSOLE_FONT_NAME".equals(name)) continue;
            option.setAttribute("value", "Test");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/editor/EditorColorSchemeTestCase";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/editor/EditorColorSchemeTestCase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doTestWriteRead";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadScheme";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doTestWriteRead";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeWithFixedMeta";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixPlatformSpecificValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

