/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fenceInjection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00050\u0004H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/fenceInjection/CodeFenceInjector;", "Lcom/intellij/lang/injection/MultiHostInjector;", "()V", "elementsToInjectIn", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "findLangForInjection", "Lcom/intellij/lang/Language;", "element", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "getLanguagesToInject", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "host", "injectAsOnePlace", "Companion", "intellij.markdown.fenceInjection"})
public class CodeFenceInjector
implements MultiHostInjector {
    private static final List<Class<MarkdownCodeFence>> toInject;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        return toInject;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        block7: {
            block6: {
                boolean bl;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
                    Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                    if (!(host instanceof MarkdownCodeFence) || !((MarkdownCodeFence)host).isValidHost()) break block6;
                    PsiElement[] psiElementArray = ((MarkdownCodeFence)host).getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"host.children");
                    PsiElement[] $this$all$iv = psiElementArray;
                    boolean $i$f$all = false;
                    int n = $this$all$iv.length;
                    for (int i = 0; i < n; ++i) {
                        PsiElement element$iv;
                        PsiElement it = element$iv = $this$all$iv[i];
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) ^ true) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                if (!bl) break block7;
            }
            return;
        }
        Language language = this.findLangForInjection((MarkdownCodeFence)host);
        if (language == null) {
            return;
        }
        Language language2 = language;
        registrar.startInjecting(language2);
        this.injectAsOnePlace((MarkdownCodeFence)host, registrar);
        registrar.doneInjecting();
    }

    @Nullable
    protected Language findLangForInjection(@NotNull MarkdownCodeFence element2) {
        Language language;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        String string = element2.getFenceLanguage();
        if (string == null) {
            return null;
        }
        String name = string;
        Language it = language = CodeFenceLanguageGuesser.guessLanguageForInjection(name);
        boolean bl = false;
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        return MarkdownSettings.Companion.getInstance(project).getAreInjectionsEnabled() ? language : null;
    }

    private final void injectAsOnePlace(MarkdownCodeFence host, MultiHostRegistrar registrar) {
        List<PsiElement> list2 = MarkdownCodeFence.Companion.obtainFenceContent(host, true);
        if (list2 == null) {
            return;
        }
        List<PsiElement> elements2 = list2;
        PsiElement first = (PsiElement)CollectionsKt.first(elements2);
        PsiElement last = (PsiElement)CollectionsKt.last(elements2);
        registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, TextRange.create((int)first.getStartOffsetInParent(), (int)(last.getStartOffsetInParent() + last.getTextLength())));
    }

    static {
        Companion = new Companion(null);
        toInject = CollectionsKt.listOf(MarkdownCodeFence.class);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/fenceInjection/CodeFenceInjector$Companion;", "", "()V", "toInject", "", "Ljava/lang/Class;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "intellij.markdown.fenceInjection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

