/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.ScrollBarPainter;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\u0004*\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewLAFThemeStyles;", "", "()V", "createStylesheet", "", "contrast", "Ljava/awt/Color;", "coefficient", "", "webRgba", "alpha", "intellij.markdown.core"})
public final class PreviewLAFThemeStyles {
    @NotNull
    public static final PreviewLAFThemeStyles INSTANCE;

    @JvmStatic
    @NotNull
    public static final String createStylesheet() {
        String string;
        EditorColorsScheme editorColorsScheme;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme $this$with = editorColorsScheme = editorColorsManager.getGlobalScheme();
        boolean bl = false;
        Color color = $this$with.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"defaultForeground");
        Color contrastedForeground = INSTANCE.contrast(color, 0.1);
        Color color2 = UIUtil.getPanelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.getPanelBackground()");
        Color panelBackground = color2;
        Color color3 = JBUI.CurrentTheme.Link.Foreground.ENABLED;
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"JBUI.CurrentTheme.Link.Foreground.ENABLED");
        Color linkActiveForeground = color3;
        JBColor jBColor = JBColor.namedColor((String)"Group.separatorColor", (Color)panelBackground);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(\"Group.separa\u2026rColor\", panelBackground)");
        JBColor separatorColor = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"Component.infoForeground", (Color)contrastedForeground);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(\"Component.in\u2026d\", contrastedForeground)");
        JBColor infoForeground = jBColor2;
        JBColor markdownFenceBackground = new JBColor(new Color(212, 222, 231, 63), new Color(212, 222, 231, 25));
        Font font = EditorUtil.getEditorFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"EditorUtil.getEditorFont()");
        int fontSize = JBCefApp.normalizeScaledSize((int)(font.getSize() + 1));
        Color color4 = $this$with.getColor(ScrollBarPainter.THUMB_OPAQUE_BACKGROUND);
        if (color4 != null) {
            Color color5;
            Color $this$run = color5 = color4;
            boolean bl2 = false;
            string = "rgba(" + $this$run.getRed() + ", " + $this$run.getBlue() + ", " + $this$run.getGreen() + ", " + (double)$this$run.getAlpha() / 255.0 + ")";
        } else {
            string = null;
        }
        String scrollbarColor = string;
        Color color6 = $this$with.getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"defaultBackground");
        String backgroundColor = PreviewLAFThemeStyles.webRgba$default(INSTANCE, color6, 0.0, 1, null);
        Color color7 = $this$with.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color7, (String)"defaultForeground");
        return StringsKt.trimIndent((String)("\n              body {\n                  background-color: " + backgroundColor + ";\n                  font-size: " + fontSize + "px !important;\n              }\n              \n              body, p, blockquote, ul, ol, dl, table, pre, code, tr  {\n                  color: " + PreviewLAFThemeStyles.webRgba$default(INSTANCE, color7, 0.0, 1, null) + ";\n              }\n              \n              a {\n                  color: " + PreviewLAFThemeStyles.webRgba$default(INSTANCE, linkActiveForeground, 0.0, 1, null) + ";\n              }\n              \n              table td, table th {\n                border: 1px solid " + PreviewLAFThemeStyles.webRgba$default(INSTANCE, (Color)separatorColor, 0.0, 1, null) + ";\n              }\n              \n              hr {\n                background-color: " + PreviewLAFThemeStyles.webRgba$default(INSTANCE, (Color)separatorColor, 0.0, 1, null) + ";\n              }\n              \n              kbd, tr {\n                border: 1px solid " + PreviewLAFThemeStyles.webRgba$default(INSTANCE, (Color)separatorColor, 0.0, 1, null) + ";\n              }\n              \n              h6 {\n                  color: " + PreviewLAFThemeStyles.webRgba$default(INSTANCE, (Color)infoForeground, 0.0, 1, null) + ";\n              }\n              \n              blockquote {\n                border-left: 2px solid " + INSTANCE.webRgba(linkActiveForeground, 0.4) + ";\n              }\n              \n              ::-webkit-scrollbar-thumb {\n                  background-color: " + scrollbarColor + ";\n              }\n              \n              blockquote, code, pre {\n                background-color: " + INSTANCE.webRgba((Color)markdownFenceBackground, (double)markdownFenceBackground.getAlpha() / 255.0) + ";\n              }\n      "));
    }

    private final String webRgba(Color $this$webRgba, double alpha) {
        return "rgba(" + $this$webRgba.getRed() + ", " + $this$webRgba.getGreen() + ", " + $this$webRgba.getBlue() + ", " + alpha + ")";
    }

    static /* synthetic */ String webRgba$default(PreviewLAFThemeStyles previewLAFThemeStyles, Color color, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = color.getAlpha();
        }
        return previewLAFThemeStyles.webRgba(color, d);
    }

    private final Color contrast(Color $this$contrast, double coefficient) {
        return new Color((int)(coefficient * (double)($this$contrast.getRed() - 128) + (double)128), (int)(coefficient * (double)($this$contrast.getGreen() - 128) + (double)128), (int)(coefficient * (double)($this$contrast.getBlue() - 128) + (double)128), $this$contrast.getAlpha());
    }

    private PreviewLAFThemeStyles() {
    }

    static {
        PreviewLAFThemeStyles previewLAFThemeStyles;
        INSTANCE = previewLAFThemeStyles = new PreviewLAFThemeStyles();
    }
}

