/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript;

import com.intellij.configurationScript.DomKt;
import com.intellij.configurationScript.IntellijConfigurationJsonSchemaProviderFactoryKt;
import com.intellij.configurationScript.yaml.LightScalarResolver;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.parser.Parser;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.resolver.ScalarResolver;
import org.snakeyaml.engine.v2.scanner.StreamReader;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0002H\u0007\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\tH\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"fileExtensions", "", "", "filePrefix", "doRead", "Lorg/snakeyaml/engine/v2/nodes/MappingNode;", "reader", "Ljava/io/Reader;", "findConfigurationFile", "Ljava/nio/file/Path;", "projectIdeaDir", "findValueNode", "Lorg/snakeyaml/engine/v2/nodes/NodeTuple;", "root", "namePath", "isConfigurationFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "name", "", "readProjectConfigurationFile", "intellij.configurationScript"})
public final class ConfigurationFileManagerKt {
    private static final String filePrefix = "intellij.";
    private static final List<String> fileExtensions = CollectionsKt.listOf((Object[])new String[]{"yaml", "yml", "json"});

    @ApiStatus.Internal
    @Nullable
    public static final List<NodeTuple> findValueNode(@NotNull MappingNode root, @NotNull String namePath) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)namePath, (String)"namePath");
        List list = root.getValue();
        if (list == null) {
            return null;
        }
        return DomKt.findValueNodeByPath(namePath, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final MappingNode doRead(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Closeable closeable = reader;
        Throwable throwable = null;
        try {
            Reader it = (Reader)closeable;
            boolean bl = false;
            LoadSettings settings = LoadSettings.builder().setUseMarks(false).setScalarResolver((ScalarResolver)new LightScalarResolver()).build();
            ParserImpl parser = new ParserImpl(new StreamReader(it, settings), settings);
            Object v0 = new Composer((Parser)parser, settings).getSingleNode().orElse(null);
            if (!(v0 instanceof MappingNode)) {
                v0 = null;
            }
            MappingNode mappingNode = v0;
            return mappingNode;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final boolean isConfigurationFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CharSequence charSequence = file.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"file.nameSequence");
        return ConfigurationFileManagerKt.isConfigurationFile(charSequence);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isConfigurationFile(@NotNull CharSequence name) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!StringsKt.startsWith$default((CharSequence)name, (CharSequence)filePrefix, (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = fileExtensions;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl2 = false;
            if (name.length() == filePrefix.length() + it.length() && StringsKt.endsWith$default((CharSequence)name, (CharSequence)it, (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final Path findConfigurationFile(Path projectIdeaDir) {
        Path file = projectIdeaDir.resolve("intellij.yaml");
        if (!file.toFile().exists()) {
            file = projectIdeaDir.resolve("intellij.yml");
        }
        return file;
    }

    @ApiStatus.Internal
    @Nullable
    public static final MappingNode readProjectConfigurationFile(@NotNull Path projectIdeaDir) {
        Intrinsics.checkNotNullParameter((Object)projectIdeaDir, (String)"projectIdeaDir");
        Path path = ConfigurationFileManagerKt.findConfigurationFile(projectIdeaDir);
        if (path == null) {
            return null;
        }
        Path file = path;
        try {
            InputStream inputStream;
            InputStream inputStream2 = PathKt.inputStreamIfExists((Path)file);
            if (inputStream2 == null) {
                return null;
            }
            InputStream inputStream3 = inputStream = inputStream2;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream3, charset);
            int n = 8192;
            return ConfigurationFileManagerKt.doRead(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n));
        }
        catch (Throwable e) {
            IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Cannot parse \"" + file + "\"", e);
            return null;
        }
    }
}

