/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.preview;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.plugins.notebooks.jupyter.preview.JupyterHttpUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/preview/JupyterCefHttpHandlerBase;", "Lorg/jetbrains/ide/HttpRequestHandler;", "absolutePathFiles", "", "", "(Ljava/util/Collection;)V", "appName", "getAppName", "()Ljava/lang/String;", "getFileFromUrl", "fullUri", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "readFile", "channel", "Lio/netty/channel/Channel;", "file", "Companion", "intellij.jupyter.core"})
public abstract class JupyterCefHttpHandlerBase
extends HttpRequestHandler {
    private final Collection<String> absolutePathFiles;
    private static final Set<String> allowedTypes;
    private static final String JUPYTER_HTTP_URI = "jupyter";
    private static final String prefix = "/jupyter";
    @NotNull
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String it = string = request.uri();
        boolean bl = false;
        String string2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
        if (StringsKt.startsWith$default((String)string2, (String)prefix, (boolean)false, (int)2, null)) return true;
        if (!this.absolutePathFiles.contains(it)) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        String fullUri;
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String str = request.uri();
        String string = fullUri = new URI(str).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fullUri");
        String string2 = this.getFileFromUrl(string);
        if (string2 == null) {
            return false;
        }
        String uri = string2;
        String string3 = FileUtilRt.getExtension((String)uri);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FileUtilRt.getExtension(uri)");
        String extension = string3;
        if (allowedTypes.contains(extension)) {
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"context.channel()");
            return this.readFile(request, channel, uri);
        }
        Logger.getInstance(JupyterCefHttpHandlerBase.class).warn("Extension not allowed: " + extension);
        return false;
    }

    private final String getFileFromUrl(String fullUri) {
        if (this.absolutePathFiles.contains(fullUri)) {
            return fullUri;
        }
        if (!StringsKt.startsWith$default((String)fullUri, (String)prefix, (boolean)false, (int)2, null)) {
            return null;
        }
        CharSequence charSequence = StringsKt.replace$default((String)fullUri, (String)"//", (String)"/", (boolean)false, (int)4, null);
        int n = prefix.length();
        String string = ((String)charSequence).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String uri = StringsKt.trimStart((String)string, (char[])new char[]{'/'});
        charSequence = uri;
        if (charSequence.length() == 0) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)uri, (CharSequence)"..", (boolean)false, (int)2, null)) {
            return null;
        }
        return uri;
    }

    @NotNull
    public abstract String getAppName();

    private final boolean readFile(FullHttpRequest request, Channel channel, String file) {
        String appName = this.getAppName();
        URL resource = JupyterCefHttpHandlerBase.Companion.getResource(appName + "/" + file);
        byte[] bytes = TextStreamsKt.readBytes((URL)resource);
        String string = appName + "/" + file;
        EmptyHttpHeaders emptyHttpHeaders = EmptyHttpHeaders.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)emptyHttpHeaders, (String)"EmptyHttpHeaders.INSTANCE");
        return this.sendData(bytes, string, request, channel, (HttpHeaders)emptyHttpHeaders);
    }

    public JupyterCefHttpHandlerBase(@NotNull Collection<String> absolutePathFiles) {
        Intrinsics.checkNotNullParameter(absolutePathFiles, (String)"absolutePathFiles");
        this.absolutePathFiles = absolutePathFiles;
    }

    public /* synthetic */ JupyterCefHttpHandlerBase(Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            collection = CollectionsKt.emptyList();
        }
        this(collection);
    }

    public JupyterCefHttpHandlerBase() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        allowedTypes = SetsKt.setOf((Object[])new String[]{"css", "js", "html", "svg", "woff2", "ttf"});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/preview/JupyterCefHttpHandlerBase$Companion;", "", "()V", "JUPYTER_HTTP_URI", "", "allowedTypes", "", "prefix", "getIndexUrl", "Lorg/apache/http/client/utils/URIBuilder;", "getJupyterHttpUrl", "getResource", "Ljava/net/URL;", "path", "intellij.jupyter.core"})
    public static final class Companion {
        @NotNull
        public final URIBuilder getJupyterHttpUrl() {
            return JupyterHttpUtilsKt.addPathSegment(JupyterHttpUtilsKt.getJupyterBaseUrl("http"), JupyterCefHttpHandlerBase.JUPYTER_HTTP_URI);
        }

        @NotNull
        public final URIBuilder getIndexUrl() {
            return JupyterHttpUtilsKt.addPathSegment(this.getJupyterHttpUrl(), "index.html");
        }

        private final URL getResource(String path) {
            Class<Companion> javaClass = Companion.class;
            URL url = javaClass.getClassLoader().getResource(path);
            if (url != null) {
                return url;
            }
            String string = PathUtil.getJarPathForClass(javaClass);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getJarPathForClass(javaClass)");
            String myPath = string;
            File file = new File(myPath).getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"File(myPath).parentFile");
            File result = new File(file.getParentFile(), path);
            boolean bl = result.exists();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Can't find " + result;
                throw new AssertionError((Object)string2);
            }
            URL uRL = result.toURI().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"result.toURI().toURL()");
            return uRL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

