/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.NlsSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0017J\u0006\u0010\u0015\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "repositoryPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Lorg/jetbrains/plugins/github/api/GHRepositoryPath;)V", "getRepositoryPath", "()Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "getServerPath", "()Lorg/jetbrains/plugins/github/api/GithubServerPath;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "toUrl", "intellij.vcs.github"})
public final class GHRepositoryCoordinates {
    @NotNull
    private final GithubServerPath serverPath;
    @NotNull
    private final GHRepositoryPath repositoryPath;

    @NotNull
    public final String toUrl() {
        return this.serverPath.toUrl() + "/" + this.repositoryPath;
    }

    @NlsSafe
    @NotNull
    public String toString() {
        return this.serverPath + "/" + this.repositoryPath;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHRepositoryCoordinates)) {
            return false;
        }
        if (!this.serverPath.equals(((GHRepositoryCoordinates)other).serverPath, true)) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.repositoryPath, (Object)((GHRepositoryCoordinates)other).repositoryPath) ^ true);
    }

    public int hashCode() {
        int result = this.serverPath.hashCode();
        result = 31 * result + this.repositoryPath.hashCode();
        return result;
    }

    @NotNull
    public final GithubServerPath getServerPath() {
        return this.serverPath;
    }

    @NotNull
    public final GHRepositoryPath getRepositoryPath() {
        return this.repositoryPath;
    }

    public GHRepositoryCoordinates(@NotNull GithubServerPath serverPath, @NotNull GHRepositoryPath repositoryPath) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
        this.serverPath = serverPath;
        this.repositoryPath = repositoryPath;
    }

    @NotNull
    public final GithubServerPath component1() {
        return this.serverPath;
    }

    @NotNull
    public final GHRepositoryPath component2() {
        return this.repositoryPath;
    }

    @NotNull
    public final GHRepositoryCoordinates copy(@NotNull GithubServerPath serverPath, @NotNull GHRepositoryPath repositoryPath) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
        return new GHRepositoryCoordinates(serverPath, repositoryPath);
    }

    public static /* synthetic */ GHRepositoryCoordinates copy$default(GHRepositoryCoordinates gHRepositoryCoordinates, GithubServerPath githubServerPath, GHRepositoryPath gHRepositoryPath, int n, Object object) {
        if ((n & 1) != 0) {
            githubServerPath = gHRepositoryCoordinates.serverPath;
        }
        if ((n & 2) != 0) {
            gHRepositoryPath = gHRepositoryCoordinates.repositoryPath;
        }
        return gHRepositoryCoordinates.copy(githubServerPath, gHRepositoryPath);
    }
}

