/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.toolwindow;

import com.intellij.collaboration.ui.codereview.OpenReviewButton;
import com.intellij.collaboration.ui.codereview.OpenReviewButtonViewModel;
import com.intellij.ui.JBColor;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.ListUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.avatars.GHAvatarIconsProvider;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u001b\u001cB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ8\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "Ljavax/swing/JPanel;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "openButtonViewModel", "Lcom/intellij/collaboration/ui/codereview/OpenReviewButtonViewModel;", "(Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;Lcom/intellij/collaboration/ui/codereview/OpenReviewButtonViewModel;)V", "assignees", "info", "Ljavax/swing/JLabel;", "labels", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRListCellRenderer$LabelsComponent;", "openButtonPanel", "stateIcon", "title", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "LabelsComponent", "LabelsComponentUI", "intellij.vcs.github"})
public final class GHPRListCellRenderer
extends JPanel
implements ListCellRenderer<GHPullRequestShort> {
    private final JLabel stateIcon;
    private final JLabel title;
    private final JLabel info;
    private final LabelsComponent labels;
    private final JPanel assignees;
    private final JPanel openButtonPanel;
    private final GHAvatarIconsProvider avatarIconsProvider;
    private final OpenReviewButtonViewModel openButtonViewModel;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends GHPullRequestShort> list2, @NotNull GHPullRequestShort value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setBackground(ListUiUtil.WithTallRow.INSTANCE.background(list2, isSelected, list2.hasFocus()));
        Color primaryTextColor = ListUiUtil.WithTallRow.INSTANCE.foreground(isSelected, list2.hasFocus());
        Color secondaryTextColor = ListUiUtil.WithTallRow.INSTANCE.secondaryForeground(list2, isSelected);
        JLabel $this$apply = jComponent = this.stateIcon;
        boolean bl = false;
        $this$apply.setIcon(GHUIUtil.INSTANCE.getPullRequestStateIcon(value.getState(), value.isDraft()));
        $this$apply.setToolTipText(GHUIUtil.INSTANCE.getPullRequestStateText(value.getState(), value.isDraft()));
        $this$apply = jComponent = this.title;
        boolean bl2 = false;
        $this$apply.setText(value.getTitle());
        $this$apply.setForeground(primaryTextColor);
        $this$apply = jComponent = this.info;
        boolean bl3 = false;
        Object[] objectArray = new Object[3];
        objectArray[0] = value.getNumber();
        GHActor gHActor = value.getAuthor();
        objectArray[1] = gHActor != null ? gHActor.getLogin() : null;
        objectArray[2] = DateFormatUtil.formatDate((Date)value.getCreatedAt());
        $this$apply.setText(GithubBundle.message("pull.request.list.item.info", objectArray));
        $this$apply.setForeground(secondaryTextColor);
        $this$apply = jComponent = this.labels;
        boolean bl4 = false;
        ((LabelsComponent)((Object)$this$apply)).setLabels(value.getLabels());
        $this$apply = jComponent = this.assignees;
        boolean bl5 = false;
        $this$apply.removeAll();
        for (GHUser assignee2 : value.getAssignees()) {
            void $this$apply2;
            JLabel jLabel;
            if ($this$apply.getComponentCount() != 0) {
                $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)));
            }
            JLabel jLabel2 = jLabel = new JLabel();
            JLabel jLabel3 = $this$apply;
            boolean bl6 = false;
            $this$apply2.setIcon(this.avatarIconsProvider.getIcon(assignee2.getAvatarUrl()));
            $this$apply2.setToolTipText(assignee2.getLogin());
            Unit unit = Unit.INSTANCE;
            jLabel3.add(jLabel);
        }
        $this$apply = jComponent = this.openButtonPanel;
        boolean bl7 = false;
        $this$apply.setVisible(index == this.openButtonViewModel.getHoveredRowIndex());
        $this$apply.setOpaque(this.openButtonViewModel.isButtonHovered());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GHPRListCellRenderer(@NotNull GHAvatarIconsProvider avatarIconsProvider, @NotNull OpenReviewButtonViewModel openButtonViewModel) {
        JPanel jPanel;
        void $this$apply;
        JPanel jPanel2;
        Intrinsics.checkNotNullParameter((Object)((Object)avatarIconsProvider), (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)openButtonViewModel, (String)"openButtonViewModel");
        this.avatarIconsProvider = avatarIconsProvider;
        this.openButtonViewModel = openButtonViewModel;
        this.stateIcon = new JLabel();
        this.title = new JLabel();
        this.info = new JLabel();
        this.labels = new LabelsComponent();
        JPanel jPanel3 = jPanel2 = new JPanel();
        GHPRListCellRenderer gHPRListCellRenderer = this;
        boolean bl = false;
        $this$apply.setOpaque(false);
        $this$apply.setLayout(new BoxLayout((Container)$this$apply, 0));
        Unit unit = Unit.INSTANCE;
        gHPRListCellRenderer.assignees = jPanel2;
        this.openButtonPanel = OpenReviewButton.INSTANCE.createOpenReviewButton(GithubBundle.message("pull.request.open.action", new Object[0]));
        String gapAfter = JBUI.scale((int)5) + "px";
        JPanel $this$apply2 = jPanel = new JPanel(null);
        boolean bl2 = false;
        $this$apply2.setOpaque(false);
        $this$apply2.setBorder((Border)JBUI.Borders.empty((int)5, (int)8));
        $this$apply2.setLayout((LayoutManager)new MigLayout(new LC().gridGap(gapAfter, "0").insets("0", "0", "0", "0").fillX()));
        $this$apply2.add(this.stateIcon);
        $this$apply2.add((Component)this.title, new CC().minWidth("pref/2px").pushX().split(2).shrinkPrioX(1));
        $this$apply2.add((Component)this.labels, new CC().minWidth("0px").pushX().shrinkPrioX(0));
        $this$apply2.add((Component)this.info, new CC().newline().minWidth("0px").pushX().skip(1));
        JPanel infoPanel = jPanel;
        this.setLayout((LayoutManager)new MigLayout(new LC().gridGap(gapAfter, "0").noGrid().insets("0", "0", "0", "0").fillX()));
        this.add((Component)infoPanel, new CC().minWidth("0"));
        this.add((Component)this.assignees, new CC().minWidth("0").gapBefore("push"));
        this.add((Component)this.openButtonPanel, new CC().minWidth("pref").growY());
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R7\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRListCellRenderer$LabelsComponent;", "Ljavax/swing/JComponent;", "()V", "<set-?>", "", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "labels", "getLabels", "()Ljava/util/List;", "setLabels", "(Ljava/util/List;)V", "labels$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.vcs.github"})
    private static final class LabelsComponent
    extends JComponent {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty labels$delegate;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(LabelsComponent.class, "labels", "getLabels()Ljava/util/List;", 0))};
        }

        @NotNull
        public final List<GHLabel> getLabels() {
            return (List)this.labels$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setLabels(@NotNull List<GHLabel> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.labels$delegate.setValue((Object)this, $$delegatedProperties[0], list2);
        }

        public LabelsComponent() {
            Delegates delegates = Delegates.INSTANCE;
            List initialValue$iv = CollectionsKt.emptyList();
            boolean $i$f$observable = false;
            this.labels$delegate = (ReadWriteProperty)new ObservableProperty<List<? extends GHLabel>>((Object)initialValue$iv, this){
                final /* synthetic */ LabelsComponent this$0;
                {
                    this.this$0 = labelsComponent;
                    super($initialValue);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    List list2 = (List)newValue;
                    List list3 = (List)oldValue;
                    KProperty $noName_0 = property;
                    boolean bl = false;
                    this.this$0.repaint();
                }
            };
            this.setUI(new LabelsComponentUI());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRListCellRenderer$LabelsComponentUI;", "Ljavax/swing/plaf/ComponentUI;", "()V", "gap", "Lcom/intellij/util/ui/JBValue;", "Lorg/jetbrains/annotations/NotNull;", "getLabelSize", "Ljava/awt/Dimension;", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "fm", "Ljava/awt/FontMetrics;", "getLabelText", "", "getMaximumSize", "c", "Ljavax/swing/JComponent;", "getMinimumSize", "getPreferredSize", "installUI", "", "paint", "g", "Ljava/awt/Graphics;", "intellij.vcs.github"})
    private static final class LabelsComponentUI
    extends ComponentUI {
        private final JBValue gap;

        @Override
        public void installUI(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            c.setOpaque(false);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            LabelsComponent cfr_ignored_0 = (LabelsComponent)c;
            Graphics graphics = g.create();
            if (graphics == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            Graphics2D g2d = (Graphics2D)graphics;
            try {
                Rectangle r = new Rectangle(c.getSize());
                JBInsets.removeFrom((Rectangle)r, (Insets)((LabelsComponent)c).getInsets());
                g2d.setFont(((LabelsComponent)c).getFont());
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                if (((LabelsComponent)c).isOpaque()) {
                    g2d.setColor(((LabelsComponent)c).getBackground());
                    g2d.fill(r);
                }
                int x = r.x;
                for (GHLabel label2 : ((LabelsComponent)c).getLabels()) {
                    FontMetrics fm;
                    FontMetrics fontMetrics = fm = c.getFontMetrics(((LabelsComponent)c).getFont());
                    Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"fm");
                    Dimension size = this.getLabelSize(label2, fontMetrics);
                    JBColor background = GHUIUtil.INSTANCE.getLabelBackground(label2);
                    g2d.setColor((Color)background);
                    g2d.fillRect(x, r.y, size.width, size.height);
                    Color foreground = GHUIUtil.INSTANCE.getLabelForeground((Color)background);
                    g2d.setColor(foreground);
                    g2d.drawString(this.getLabelText(label2), x, size.height - fm.getMaxDescent());
                    x += size.width + this.gap.get();
                }
            }
            finally {
                g2d.dispose();
            }
        }

        @Override
        @NotNull
        public Dimension getMinimumSize(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return this.getPreferredSize(c);
        }

        @Override
        @NotNull
        public Dimension getPreferredSize(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            List<GHLabel> labels = ((LabelsComponent)c).getLabels();
            if (labels.isEmpty()) {
                return new Dimension(0, 0);
            }
            FontMetrics fm = c.getFontMetrics(((LabelsComponent)c).getFont());
            Dimension dim = new Dimension(0, 0);
            for (GHLabel label2 : labels) {
                FontMetrics fontMetrics = fm;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"fm");
                Dimension labelSize = this.getLabelSize(label2, fontMetrics);
                dim.width += labelSize.width;
                dim.height = Integer.max(dim.height, labelSize.height);
            }
            dim.width += this.gap.get() * (labels.size() - 1);
            JBInsets.addTo((Dimension)dim, (Insets)((LabelsComponent)c).getInsets());
            return dim;
        }

        private final Dimension getLabelSize(GHLabel label2, FontMetrics fm) {
            return new Dimension(fm.stringWidth(this.getLabelText(label2)), fm.getHeight());
        }

        private final String getLabelText(GHLabel label2) {
            return " " + label2.getName() + " ";
        }

        @Override
        @NotNull
        public Dimension getMaximumSize(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return this.getPreferredSize(c);
        }

        public LabelsComponentUI() {
            JBValue jBValue = JBUI.uiIntValue((String)"LabelsComponent.Gap", (int)4);
            Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"JBUI.uiIntValue(\"LabelsComponent.Gap\", 4)");
            this.gap = jBValue;
        }
    }
}

