/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.indexing.ID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HashIndexKey
extends ID<Long, Void> {
    static final String FILE_CONTENT_HASH_INDEX_SUFFIX = "shared.index.hashes.";
    private final ID<?, ?> myBaseIndexId;

    private HashIndexKey(@NotNull String name, ID<?, ?> baseIndexId) {
        if (name == null) {
            HashIndexKey.$$$reportNull$$$0(0);
        }
        super(name, HashIndexKey.getSharedIndexPlugin());
        this.myBaseIndexId = baseIndexId;
    }

    @NotNull
    public ID<?, ?> getBaseIndexId() {
        ID<?, ?> iD = this.myBaseIndexId;
        if (iD == null) {
            HashIndexKey.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @NotNull
    public static synchronized HashIndexKey createHashIndexKey(@NonNls @NotNull ID<?, ?> baseIndexId) {
        String name;
        ID existing;
        if (baseIndexId == null) {
            HashIndexKey.$$$reportNull$$$0(2);
        }
        if ((existing = HashIndexKey.findByName((String)(name = FILE_CONTENT_HASH_INDEX_SUFFIX + baseIndexId.getName()))) != null) {
            if (existing instanceof HashIndexKey) {
                HashIndexKey hashIndexKey = (HashIndexKey)existing;
                if (hashIndexKey == null) {
                    HashIndexKey.$$$reportNull$$$0(3);
                }
                return hashIndexKey;
            }
            throw new IllegalStateException("key with id " + name + " is already registered", existing.getRegistrationTrace());
        }
        return new HashIndexKey(name, baseIndexId);
    }

    @Nullable
    private static PluginId getSharedIndexPlugin() {
        ClassLoader classLoader = HashIndexKey.class.getClassLoader();
        return classLoader instanceof PluginAwareClassLoader ? ((PluginAwareClassLoader)classLoader).getPluginId() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/HashIndexKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIndexId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/HashIndexKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIndexId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashIndexKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHashIndexKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

